/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.transformation.java9;

import com.singularity.ee.agent.appagent.services.bciengine.IByteCodeTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.Java9TransformerFactory;
import com.singularity.ee.agent.util.JavaVersionUtil;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.lang.instrument.ClassFileTransformer;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class Java9ClassTransformerFactory {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.Java9ClassTransformerFactory");

    @Inject
    public Java9ClassTransformerFactory() {
    }

    public ClassFileTransformer createJava9ByteCodeTransformer(IByteCodeTransformer originalByteCodeTransformer) {
        ClassFileTransformer classFileTransformer = null;
        if (JavaVersionUtil.isJava9orHigher()) {
            try {
                Java9TransformerFactory transformerFactory = new Java9TransformerFactory(originalByteCodeTransformer);
                classFileTransformer = transformerFactory.createClassFileTransformer(logger);
            }
            catch (Exception e) {
                logger.error(String.format("Exception '%s\" caught in createJava9ByteCodeTransformer()", e.toString()), e);
            }
        }
        return classFileTransformer;
    }
}

