/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.management;

import com.singularity.ee.agent.appagent.services.management.MemoryUsageInfo;
import com.singularity.ee.agent.appagent.services.management.memory.IMemoryLimitCheck;

public class MemoryLimitCheck
implements IMemoryLimitCheck {
    public static final int MB_MULTIPLIER = 0x100000;
    private static final MemoryLimitCheck _instance = new MemoryLimitCheck();
    private final MemoryUsageInfo memoryUsageInfo;
    private long minClassMemoryNeededForRetransform = 0x500000L;
    private boolean classMemoryLimitCheckEnabled = true;
    private long max;
    private long used;

    public static MemoryLimitCheck getInstance() {
        return _instance;
    }

    public MemoryLimitCheck() {
        this(new MemoryUsageInfo());
    }

    protected MemoryLimitCheck(MemoryUsageInfo memoryUsageInfo) {
        this.memoryUsageInfo = memoryUsageInfo;
    }

    public void setMinClassMemoryInMBNeededForRetransform(int minPermGenNeededForRetransformInMB) {
        this.minClassMemoryNeededForRetransform = minPermGenNeededForRetransformInMB * 0x100000;
    }

    public void setClassMemoryLimitCheckEnabled(boolean classMemoryLimitCheckEnabled) {
        this.classMemoryLimitCheckEnabled = classMemoryLimitCheckEnabled;
    }

    public void initializeMemoryMXBean() {
        this.memoryUsageInfo.initializeMemoryMXBean();
    }

    public boolean isMemoryAvailableForRetransform() {
        if (this.classMemoryLimitCheckEnabled && this.memoryUsageInfo.isMemoryInfoAvailable()) {
            this.max = this.memoryUsageInfo.getMaxAllocatedMemory();
            this.used = this.memoryUsageInfo.getUsedMemoryFromLastUpdate();
            if (this.max > this.used) {
                long availableMemory = this.max - this.used;
                return availableMemory > this.minClassMemoryNeededForRetransform;
            }
        }
        return true;
    }

    public String getLimitReachedMessage(String context) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("Not running ").append(context).append(", Class memory ");
        sb.append("used [").append(this.used).append("], max[").append(this.max).append("],");
        sb.append(" available [" + (this.max - this.used) + "] is < ").append(this.minClassMemoryNeededForRetransform);
        sb.append(" You may consider increasing the max class memory size (also known as Perm Gen in Sun JVM) in your JVM startup parameters (e.g. For Sun JVM : -XX:PermSize=<..>m -XX:MaxPermSize=<..>m");
        return sb.toString();
    }
}

