/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.management;

import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;

public class MemoryUsageInfo {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.management.MemoryUsageInfo");
    private static final String[] trackableClassMemPoolNames = new String[]{"Metaspace", "PS Perm Gen", "CMS Perm Gen", "Perm Gen", "GenPauseless Perm Gen"};
    public static final long SENTINAL_FOR_MAX_WHEN_NOTAVAILABLE = -1L;
    public static final long SENTINAL_FOR_USED_WHEN_NOTAVAILABLE = -1L;
    private MemoryPoolMXBean trackableClassMemoryMXBean = null;
    private boolean memoryInfoAvailable = false;

    public void initializeMemoryMXBean() {
        List<MemoryPoolMXBean> memoryPoolMXBeans = this.getMemoryPoolMXBeans();
        block0: for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            for (String classMemPoolName : trackableClassMemPoolNames) {
                if (!classMemPoolName.equals(memoryPoolMXBean.getName())) continue;
                this.trackableClassMemoryMXBean = memoryPoolMXBean;
                long max = this.trackableClassMemoryMXBean.getUsage().getMax();
                logger.info("MemoryMXBean available for " + classMemPoolName + " with max " + max);
                if (max <= 0L) continue block0;
                this.memoryInfoAvailable = true;
                continue block0;
            }
        }
    }

    protected List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return ManagementFactory.getMemoryPoolMXBeans();
    }

    public boolean isMemoryInfoAvailable() {
        return this.memoryInfoAvailable;
    }

    public long getMaxAllocatedMemory() {
        if (this.memoryInfoAvailable) {
            return this.trackableClassMemoryMXBean.getUsage().getMax();
        }
        return -1L;
    }

    public long getUsedMemoryFromLastUpdate() {
        if (this.memoryInfoAvailable) {
            return this.trackableClassMemoryMXBean.getUsage().getUsed();
        }
        return -1L;
    }

    public long getAvailableMemory() {
        long max = this.trackableClassMemoryMXBean.getUsage().getMax();
        long used = this.trackableClassMemoryMXBean.getUsage().getUsed();
        return max - used;
    }
}

