/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.retransformation;

import com.singularity.ee.agent.appagent.IAgentClassLoader;
import com.singularity.ee.agent.appagent.java9.IJava9Util;
import com.singularity.ee.agent.appagent.kernel.boot.JavaAgentBootExtension;
import com.singularity.ee.agent.appagent.kernel.spi.IAgentService;
import com.singularity.ee.agent.appagent.kernel.spi.IClassLoadListener;
import com.singularity.ee.agent.appagent.kernel.spi.IConfigManager;
import com.singularity.ee.agent.appagent.kernel.spi.IServiceContext;
import com.singularity.ee.agent.appagent.kernel.spi.IServicePropertyListener;
import com.singularity.ee.agent.appagent.kernel.spi.data.IServiceConfig;
import com.singularity.ee.agent.appagent.kernel.spi.exception.ConfigException;
import com.singularity.ee.agent.appagent.kernel.spi.exception.ServiceStartException;
import com.singularity.ee.agent.appagent.kernel.spi.exception.ServiceStopException;
import com.singularity.ee.agent.appagent.services.bciengine.InstrumentationTracker;
import com.singularity.ee.agent.appagent.services.bciengine.RuntimeExcludeManager;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.ABCIRuleApplier;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.UnableToRetransformException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationLimitExceededException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ClassMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.MethodInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.RuntimeClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.bytecodeclassfilters.ALLByteCodeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.runtimeclassfilters.ALLRuntimeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MatchClassNameFilter;
import com.singularity.ee.agent.appagent.services.management.JVMClassLoadingInfoProvider;
import com.singularity.ee.agent.appagent.services.transactionmonitor.instrumentation.DynamicRulesManager;
import com.singularity.ee.agent.appagent.services.transactionmonitor.instrumentation.RetransformInfo;
import com.singularity.ee.agent.configuration.spi.IAgentSchedulerManager;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.reflect.AgentReflectionUtility;
import com.singularity.ee.agent.util.reflect.ReflectionException;
import com.singularity.ee.agent.util.version.determiner.TomcatVersionDeterminer;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import com.singularity.ee.util.string.StringOperations;
import dagger.CustomImpl;
import java.lang.instrument.Instrumentation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@CustomImpl
public class BCIFixerService
extends ABCIRuleApplier
implements IServicePropertyListener,
IClassLoadListener,
IAgentService {
    private static final int MSECS_IN_MINUTE = 60000;
    static final String BCI_FIXER_REVISIT_INTERVAL = "bcifixer-revisit-interval-in-minutes";
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.BCIFixer");
    private static final int INITIAL_DELAY_IN_MSECS = 180000;
    private static final int INITIAL_INTERVAL_IN_MSECS = 300000;
    private static final String DEFAULT_DYNAMIC_PROPERTY = "bci-fixer-other-classes";
    private static final String BCI_FIXER_OFF = "off";
    private static final String BCI_FIXER_ON = "on";
    private static final int DEFAULT_BATCH_TIME_LIMIT_IN_MSECS = 100;
    private static final int DEFAULT_BATCH_PERIOD_IN_SECS = 5;
    private static final int LIMIT_TO_TRIGGER_FULL_CLASS_SCAN = 2000;
    private static final int NUMBER_OF_CLASSES_TO_PROCESS_PER_CHECK = 50;
    private volatile int batchTimeLimitInMsecs = 100;
    private volatile int batchPeriodInSecs = 5;
    private volatile int serviceIntervalInMsecs = 300000;
    private static final String EJB_CLASSLOADER = "com.sun.enterprise.loader.EJBClassLoader";
    private static final String TOMCATWEBAPP_CLASSLOADER = "org.apache.catalina.loader.WebappClassLoader";
    private static final String TOMCATWEBAPP_CLASSLOADER_BASE = "org.apache.catalina.loader.WebappClassLoaderBase";
    private static final String EVALUATE_RUNTIME_BCI_RULES_SYSTEM_PROPERTY = "appdynamics." + "evaluate-runtime-bci-rules".replace('-', '.');
    private boolean firstRun = true;
    private final Instrumentation instrumentation;
    private final IAgentScheduledExecutorService agentGlobalScheduler;
    private final Set<String> blacklistedClasses = Collections.synchronizedSet(new HashSet());
    private final AtomicBoolean active = new AtomicBoolean(true);
    private final AtomicBoolean rulesChanged = new AtomicBoolean(false);
    private final IJava9Util java9Util;
    private String lastSearch;
    private IAgentScheduledFuture future;
    private IAgentScheduledFuture batchFuture;
    private final AtomicReference<Map<String, String>> newlyLoadedClasses = new AtomicReference(new ConcurrentHashMap());
    private volatile boolean initialized = false;
    private final DynamicRulesManager dynamicRulesManager;
    private int numberOfClassesLoaded;
    private final boolean disabled;
    private Map<AClassTransformationRule, Map<String, Set<AClassTransformationRule>>> originalRuleVsClassVsTR = new HashMap<AClassTransformationRule, Map<String, Set<AClassTransformationRule>>>();
    private final IConfigManager configManager;
    private final JVMClassLoadingInfoProvider classLoadingInfoProvider;
    private final TomcatVersionDeterminer tomcatVersionDeterminer;

    @Inject
    public BCIFixerService(Instrumentation instrumentation, IBCIEngineService bciEngine, IAgentSchedulerManager agentSchedulerManager, DynamicRulesManager dynamicRulesManager, IConfigManager configManager, JVMClassLoadingInfoProvider classLoadingInfoProvider, IJava9Util java9Util, TomcatVersionDeterminer tomcatVersionDeterminer) {
        super(logger, bciEngine, false);
        this.instrumentation = instrumentation;
        this.agentGlobalScheduler = agentSchedulerManager.getAgentGlobalScheduler();
        this.dynamicRulesManager = dynamicRulesManager;
        this.disabled = this.shouldOverrideAndDisableBCIFixer();
        this.configManager = configManager;
        this.classLoadingInfoProvider = classLoadingInfoProvider;
        this.java9Util = java9Util;
        this.tomcatVersionDeterminer = tomcatVersionDeterminer;
        super.setCheckDuplicateRules(true);
    }

    @Override
    public void allServicesStarted() {
        if (this.disabled) {
            logger.info("Disabled by property flag: -D" + EVALUATE_RUNTIME_BCI_RULES_SYSTEM_PROPERTY + " or because class look ahead is enabled");
            return;
        }
        this.initialized = true;
        this.reschedule(180000, this.serviceIntervalInMsecs);
        if (!this.bciEngine.isRetransformClassesSupported()) {
            logger.info("Retransformation is NOT supported on this JVM. BCIFixer is active - but will NOT retransform classes");
        }
    }

    private void reschedule(int initialDelay, int interval) {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        this.rulesChanged();
        logger.info("Scheduling BCIFixer at [" + interval + "] ms intervals.");
        this.future = this.agentGlobalScheduler.scheduleWithFixedDelay(new BCIFixRunner(), initialDelay, interval, AgentTimeUnit.MILLISECONDS);
    }

    public void setActive(boolean bool) {
        if (!this.active.get() && bool) {
            this.reschedule(this.serviceIntervalInMsecs, this.serviceIntervalInMsecs);
        }
        this.active.set(bool);
        if (!this.active.get()) {
            if (this.future != null) {
                logger.info("Stopping BCIFixer run.");
                this.future.cancel(true);
                this.future = null;
            }
            if (this.batchFuture != null) {
                logger.info("Stopping BCI batch future invocation.");
                this.batchFuture.cancel(true);
                this.batchFuture = null;
            }
        }
    }

    public void applyCustomRules() {
        try {
            this.dynamicRulesManager.loadRules();
        }
        catch (Exception e) {
            logger.error("Error processing transaction processing rules : ", e);
        }
    }

    private void addedNewRule(String className, AClassTransformationRule originatingRule, Set<AClassTransformationRule> newRules) {
        Map<String, Set<AClassTransformationRule>> classVsTR = this.originalRuleVsClassVsTR.get(originatingRule);
        if (classVsTR == null) {
            classVsTR = new HashMap<String, Set<AClassTransformationRule>>();
            this.originalRuleVsClassVsTR.put(originatingRule, classVsTR);
        }
        classVsTR.put(className, newRules);
    }

    private synchronized void startMultipleInheritanceCheck(Set<AClassTransformationRule> transformationRules) {
        if (!this.active.get() || this.disabled || !JavaAgentBootExtension.getInstance().getBootServiceProvider().getConfigChannel().isRegistered()) {
            return;
        }
        if (this.batchFuture != null) {
            return;
        }
        Map loadedClasses = this.newlyLoadedClasses.getAndSet(new ConcurrentHashMap());
        boolean rulesHaveChanged = this.rulesChanged.getAndSet(false);
        if (this.firstRun) {
            rulesHaveChanged = true;
            loadedClasses.clear();
            this.firstRun = false;
        }
        int numNewClassesLoaded = this.getNumNewClassesLoaded();
        if (loadedClasses.size() == 0 && numNewClassesLoaded == 0 && !rulesHaveChanged) {
            if (logger.isDebugEnabled()) {
                logger.debug("No classes have been loaded, and no rules have changed. Skip running BCIFixer.");
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Number of classes loaded:" + loadedClasses.size() + ", rules changed:" + rulesHaveChanged);
        }
        HashSet<String> instrumentedClassNames = new HashSet<String>();
        HashSet<AClassTransformationRule> rulesToBeRetained = new HashSet<AClassTransformationRule>();
        boolean shouldApplyNewRuleSet = false;
        Iterator<AClassTransformationRule> originalRules = this.originalRuleVsClassVsTR.keySet().iterator();
        while (originalRules.hasNext()) {
            AClassTransformationRule originalRule = originalRules.next();
            Map<String, Set<AClassTransformationRule>> classVsTR = this.originalRuleVsClassVsTR.get(originalRule);
            if (!transformationRules.contains(originalRule)) {
                if (classVsTR != null) {
                    for (Set<AClassTransformationRule> oldRules : classVsTR.values()) {
                        this.bciEngine.geTransformationRuleEngine().unregisterTransformationRulesIfPresent(oldRules);
                        if (logger.isDebugEnabled()) {
                            logger.debug("BCIFixer removed rule for originalRule:" + originalRule);
                        }
                        shouldApplyNewRuleSet = true;
                    }
                }
                originalRules.remove();
                continue;
            }
            if (classVsTR == null) continue;
            instrumentedClassNames.addAll(classVsTR.keySet());
            Collection<Set<AClassTransformationRule>> ruleSets = classVsTR.values();
            Iterator iterator = ruleSets.iterator();
            while (iterator.hasNext()) {
                Set ruleSet = (Set)iterator.next();
                rulesToBeRetained.addAll(ruleSet);
            }
        }
        Class[] allLoadedClasses = this.instrumentation.getAllLoadedClasses();
        WeakReference[] classesToExamine = new WeakReference[allLoadedClasses.length];
        if (logger.isDebugEnabled()) {
            logger.debug("Creating a weakly-referenced class array of size " + allLoadedClasses.length + " for BCIBatchRunner to process");
        }
        int idx = 0;
        for (Class clazz : allLoadedClasses) {
            classesToExamine[idx++] = new WeakReference<Object>(clazz);
        }
        BCIBatchRunner runner = new BCIBatchRunner(classesToExamine, loadedClasses, instrumentedClassNames, transformationRules, rulesHaveChanged, shouldApplyNewRuleSet, rulesToBeRetained, this.java9Util);
        this.batchFuture = this.agentGlobalScheduler.scheduleWithFixedDelay(runner, 0L, this.batchPeriodInSecs, AgentTimeUnit.SECONDS);
        if (logger.isDebugEnabled()) {
            logger.debug("Scheduling BCIFixer to process batches every " + this.batchPeriodInSecs + " seconds.");
        }
    }

    private boolean isClassStillAlive(Class clazz) {
        ClassLoader loader = clazz.getClassLoader();
        if (loader != null) {
            Class<?> loaderClass = loader.getClass();
            if (loaderClass.getName().equals(EJB_CLASSLOADER) || AgentReflectionUtility.extendsFromClass(loaderClass, EJB_CLASSLOADER)) {
                try {
                    Boolean isDone = (Boolean)AgentReflectionUtility.invokeSimpleGetterWithoutReporting(loader, "isDone");
                    if (isDone != null && isDone.booleanValue()) {
                        return false;
                    }
                }
                catch (ReflectionException e) {
                    return true;
                }
            }
            if (BCIFixerService.isTomcatWebAppClassLoader(loader)) {
                return this.tomcatVersionDeterminer.isTomcatClassLoaderStarted(loader);
            }
        }
        return true;
    }

    private static boolean isTomcatWebAppClassLoader(ClassLoader loader) {
        Class<?> loaderClass = loader.getClass();
        String classLoaderName = loaderClass.getName();
        return classLoaderName.equals(TOMCATWEBAPP_CLASSLOADER) || AgentReflectionUtility.extendsFromClass(loaderClass, TOMCATWEBAPP_CLASSLOADER) || classLoaderName.equals(TOMCATWEBAPP_CLASSLOADER_BASE) || AgentReflectionUtility.extendsFromClass(loaderClass, TOMCATWEBAPP_CLASSLOADER_BASE);
    }

    private final boolean shouldOverrideAndDisableBCIFixer() {
        String property = System.getProperty(EVALUATE_RUNTIME_BCI_RULES_SYSTEM_PROPERTY);
        return property != null && !StringOperations.safeParseBoolean((String)property, (boolean)false);
    }

    private MethodInfo isCandidateForRetransform(AClassTransformationRule transformationRule, ClassMethodFilter classMethodFilter, Class clazz, BasicClassInfo basicInfo, RuntimeClassInfo runtimeInfo) {
        block5: {
            if (!classMethodFilter.getRuntimeClassFilter().matchClassWithHierarchy(basicInfo, runtimeInfo)) {
                return null;
            }
            try {
                MethodInfo methodInfo;
                transformationRule.checkShouldApplyToClass(basicInfo.getClassName(), basicInfo.getLoader());
                for (Method method : clazz.getDeclaredMethods()) {
                    methodInfo = new MethodInfo(method);
                    if (!classMethodFilter.getMethodFilter().matchMethod(methodInfo)) continue;
                    return methodInfo;
                }
                for (Executable executable : clazz.getConstructors()) {
                    methodInfo = new MethodInfo((Constructor)executable);
                    if (!classMethodFilter.getMethodFilter().matchMethod(methodInfo)) continue;
                    return methodInfo;
                }
            }
            catch (TransformationLimitExceededException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug(String.format("%s caught in isCandidateForRetransform() method", e), e);
            }
        }
        return null;
    }

    private RetransformInfo createRetransformationInfoBasedOnMethodMatch(AClassTransformationRule rule, ClassMethodFilter classMethodFilter, String className, String methodName) {
        this.logTransformationRule(rule, className, methodName);
        if (rule.getDynamicProperty() != null) {
            this.dynamicRulesManager.registerPropertyMatch(rule.getDynamicProperty(), className);
            return new RetransformInfo(rule.getDynamicProperty());
        }
        try {
            MatchClassNameFilter classFilter = new MatchClassNameFilter(className, classMethodFilter.getMethodFilter());
            AClassTransformationRule classRule = (AClassTransformationRule)rule.clone();
            classRule.setFilter(classFilter);
            HashSet<AClassTransformationRule> rulesForClass = new HashSet<AClassTransformationRule>();
            rulesForClass.add(classRule);
            return new RetransformInfo(rulesForClass);
        }
        catch (CloneNotSupportedException e) {
            logger.error("CloneNotSupported for rule " + rule.getClass().getName() + ", for class " + className);
            return null;
        }
    }

    private void logTransformationRule(AClassTransformationRule rule, String className, String methodName) {
        if (rule.isLogRetransformation()) {
            logger.info("Rule [" + rule + "] for class: [" + className + "]  Matching Method [" + methodName + "] Dynamic Property [" + rule.getDynamicProperty() + "] is a candidate for re-transformation.");
        } else if (logger.isDebugEnabled()) {
            logger.debug("Rule [" + rule + "] for class: [" + className + "]  Matching Method [" + methodName + "] Dynamic Property [" + rule.getDynamicProperty() + "] is a candidate for re-transformation.");
        }
    }

    public boolean excludeProcessingForRule(AClassTransformationRule transformationRule, ClassMethodFilter classMethodFilter, String className, String bciClassName, BasicClassInfo basicClassInfo) {
        if (InstrumentationTracker.isClassInstrumentedForRule(bciClassName, transformationRule)) {
            return true;
        }
        if (basicClassInfo.getLoader() != null ? classMethodFilter.getRuntimeClassFilter() instanceof ALLRuntimeClassFilter || classMethodFilter.getByteCodeClassFilter() instanceof ALLByteCodeClassFilter : classMethodFilter.getRuntimeClassFilter() instanceof ALLRuntimeClassFilter) {
            return true;
        }
        if (transformationRule.isBCIFixerExcluded()) {
            return true;
        }
        if (!classMethodFilter.getBasicClassFilter().matchClass(basicClassInfo)) {
            return true;
        }
        if (transformationRule.getDynamicProperty() != null) {
            return this.dynamicRulesManager.isPropertyRegisteredForClass(transformationRule.getDynamicProperty(), className);
        }
        return false;
    }

    public synchronized void runOnce() {
        try {
            if (!this.initialized) {
                return;
            }
            this.startMultipleInheritanceCheck(this.bciEngine.geTransformationRuleEngine().getTransformationRules());
        }
        catch (Throwable e) {
            logger.error("Error running BCIFixer", e);
        }
    }

    @Override
    public void loadedClass(String name) {
        if (!this.active.get()) {
            return;
        }
        if (this.rulesChanged.get()) {
            return;
        }
        if (this.newlyLoadedClasses.get().size() < 2000) {
            String bciClassName = name.replace('/', '.');
            this.newlyLoadedClasses.get().put(bciClassName, "");
        } else {
            this.rulesChanged();
        }
    }

    public synchronized void rulesChanged() {
        this.rulesChanged.set(true);
        this.newlyLoadedClasses.get().clear();
        if (this.batchFuture != null) {
            this.batchFuture.cancel(false);
            this.batchFuture = null;
        }
    }

    @Override
    public void servicePropertyChanged(String serviceName, String propertyName, String newPropertyValue) {
        int oldIntervalInMinutes;
        int intervalInMinutes;
        logger.info("Applying property " + propertyName + ", val " + newPropertyValue);
        if (propertyName.equals("bcifixer-batch-time-limit")) {
            this.batchTimeLimitInMsecs = StringOperations.safeParseInteger((String)newPropertyValue, (int)this.batchTimeLimitInMsecs);
        } else if (propertyName.equals("bcifixer-batch-period")) {
            this.batchPeriodInSecs = StringOperations.safeParseInteger((String)newPropertyValue, (int)this.batchPeriodInSecs);
        } else if (propertyName.equals("evaluate-runtime-bci-rules")) {
            if (StringOperations.isEmpty((String)newPropertyValue)) {
                return;
            }
            if (!newPropertyValue.equals(this.lastSearch)) {
                if (newPropertyValue.equals(BCI_FIXER_OFF)) {
                    this.setActive(false);
                    return;
                }
                if (newPropertyValue.equals(BCI_FIXER_ON)) {
                    this.setActive(true);
                    this.runOnce();
                    return;
                }
                this.lastSearch = newPropertyValue;
            }
        } else if (propertyName.equals(BCI_FIXER_REVISIT_INTERVAL) && (intervalInMinutes = StringOperations.safeParseInteger((String)newPropertyValue, (int)(oldIntervalInMinutes = this.serviceIntervalInMsecs / 60000))) > 0 && intervalInMinutes != oldIntervalInMinutes) {
            this.serviceIntervalInMsecs = intervalInMinutes * 60000;
            if (this.active.get()) {
                this.reschedule(this.serviceIntervalInMsecs, this.serviceIntervalInMsecs);
            }
        }
    }

    private int getNumNewClassesLoaded() {
        int numNewClassesLoaded = -1;
        int currentNumberOfClassesLoaded = this.classLoadingInfoProvider.getNumberOfClassesLoaded();
        numNewClassesLoaded = currentNumberOfClassesLoaded - this.numberOfClassesLoaded;
        this.numberOfClassesLoaded = currentNumberOfClassesLoaded;
        return numNewClassesLoaded;
    }

    @Override
    public String getName() {
        return "BCIFixer";
    }

    @Override
    public void setServiceContext(IServiceContext serviceContext) {
        if (!this.disabled) {
            this.bciEngine.addClassLoadListener(this);
        }
    }

    @Override
    public void configure(IServiceConfig serviceConfig) throws ConfigException {
    }

    @Override
    public void start() throws ServiceStartException {
        if (!this.disabled) {
            String[] bciProps = new String[]{"evaluate-runtime-bci-rules", "bcifixer-batch-time-limit", "bcifixer-batch-period", BCI_FIXER_REVISIT_INTERVAL};
            this.configManager.registerConfigPropertyChangeListener(this.getName(), bciProps, (IServicePropertyListener)this);
        }
    }

    @Override
    public void stop() throws ServiceStopException {
        this.setActive(false);
    }

    @Override
    public void hotDisable() {
        this.setActive(false);
    }

    @Override
    public void hotEnable() {
        this.setActive(true);
    }

    protected class BCIBatchRunner
    implements IAgentRunnable {
        private final Set<AClassTransformationRule> transformationRules;
        private final Map<String, String> loadedClasses;
        private final Set<String> instrumentedClassNames;
        private final boolean rulesHaveChanged;
        private final WeakReference<Class>[] classesToExamine;
        private final Set<AClassTransformationRule> ruleSet;
        private final IJava9Util java9Util;
        private volatile boolean shouldApplyNewRuleSet;
        private int classIdx;
        private int skipped;

        protected BCIBatchRunner(WeakReference<Class>[] classesToExamine, Map<String, String> loadedClasses, Set<String> instrumentedClassNames, Set<AClassTransformationRule> transformationRules, boolean rulesHaveChanged, boolean shouldApplyNewRuleSet, Set<AClassTransformationRule> rulesToBeRetained, IJava9Util java9Util) {
            this.transformationRules = transformationRules;
            this.loadedClasses = loadedClasses;
            this.instrumentedClassNames = instrumentedClassNames;
            this.rulesHaveChanged = rulesHaveChanged;
            this.shouldApplyNewRuleSet = shouldApplyNewRuleSet;
            this.classesToExamine = classesToExamine;
            this.ruleSet = rulesToBeRetained;
            this.java9Util = java9Util;
            this.classIdx = 0;
            this.skipped = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long startTime = System.currentTimeMillis();
            int numOfClassesProcessed = 0;
            try {
                numOfClassesProcessed = this.processRetransformationBatch();
                BCIFixerService.this.dynamicRulesManager.writeXML();
            }
            catch (Throwable e) {
                logger.error("Error running batch BCIFixer", e);
            }
            finally {
                long runTimeInMs = System.currentTimeMillis() - startTime;
                if (logger.isDebugEnabled()) {
                    logger.debug("Time taken to kick off retransform process for [" + numOfClassesProcessed + "] classes = [" + runTimeInMs + "] ms. It will be a batched retransform");
                }
            }
        }

        protected int processRetransformationBatch() {
            BasicClassInfo basicClassInfo = new BasicClassInfo(null, null);
            Set<AClassTransformationRule> newRules = this.ruleSet;
            long startTime = System.currentTimeMillis();
            int numOfClassesProcessed = 0;
            boolean isDebugEnabled = logger.isDebugEnabled();
            while (this.classIdx < this.classesToExamine.length) {
                block27: {
                    Class clazz = (Class)this.classesToExamine[this.classIdx].get();
                    if (this.classIdx % 50 == 0 && System.currentTimeMillis() - startTime > (long)BCIFixerService.this.batchTimeLimitInMsecs) {
                        return numOfClassesProcessed;
                    }
                    if (clazz == null) {
                        ++this.skipped;
                    } else {
                        BCIFixerService.this.isClassStillAlive(clazz);
                        if (!RuntimeExcludeManager.isLambdaClass(clazz)) {
                            String className = clazz.getName();
                            basicClassInfo.reset(clazz, this.java9Util.getModuleForClass(clazz));
                            if (this.rulesHaveChanged || this.loadedClasses.get(className) != null || clazz.getClassLoader() == null) {
                                if (this.instrumentedClassNames.contains(className)) {
                                    if (isDebugEnabled) {
                                        logger.debug("Ignoring already instrumented class " + clazz.getName());
                                    }
                                } else if (!BCIFixerService.this.blacklistedClasses.contains(className)) {
                                    if (clazz.getClassLoader() != null && IAgentClassLoader.class.isAssignableFrom(clazz.getClassLoader().getClass())) {
                                        if (isDebugEnabled) {
                                            logger.debug("Ignored class " + clazz.getName() + " from agent bootloader");
                                        }
                                    } else {
                                        ++numOfClassesProcessed;
                                        try {
                                            if (BCIFixerService.this.bciEngine.geTransformationRuleEngine().excludeFromProcessing(clazz, clazz.getClassLoader())) break block27;
                                            BasicClassInfo basicInfo = new BasicClassInfo(clazz.getClassLoader(), clazz.getName());
                                            RuntimeClassInfo runtimeInfo = new RuntimeClassInfo(clazz, BCIFixerService.this.bciEngine.isClassLookAheadEnabledForClass(clazz.getName()), BCIFixerService.this.bciEngine.isSafeToCallHasAnnotation(clazz), BCIFixerService.this.bciEngine.getClassMetaDataManager());
                                            String bciClassName = clazz.getName().replace('.', '/');
                                            for (AClassTransformationRule transformationRule : this.transformationRules) {
                                                ClassMethodFilter classMethodFilter;
                                                if (BCIFixerService.this.excludeProcessingForRule(transformationRule, classMethodFilter = transformationRule.getFilter(), className, bciClassName, basicClassInfo)) continue;
                                                RetransformInfo retransformInfo = null;
                                                try {
                                                    MethodInfo methodInfo = BCIFixerService.this.isCandidateForRetransform(transformationRule, classMethodFilter, clazz, basicInfo, runtimeInfo);
                                                    if (methodInfo != null) {
                                                        retransformInfo = BCIFixerService.this.createRetransformationInfoBasedOnMethodMatch(transformationRule, classMethodFilter, className, methodInfo.getName());
                                                    }
                                                }
                                                catch (Throwable e) {
                                                    logger.warn("Error matching class [" + className + "] [" + e.getMessage() + "]. Blacklisting the class");
                                                    if (isDebugEnabled) {
                                                        logger.debug("Error matching class [" + className + "] [" + e.getMessage() + "]. Blacklisting the class", e);
                                                    }
                                                    BCIFixerService.this.blacklistedClasses.add(className);
                                                }
                                                if (retransformInfo == null) continue;
                                                if (retransformInfo.isPropertyBased()) {
                                                    BCIFixerService.this.dynamicRulesManager.notifyListener(retransformInfo.getDynamicProperty(), className);
                                                    continue;
                                                }
                                                newRules.addAll(retransformInfo.getRulesForClass());
                                                this.shouldApplyNewRuleSet = true;
                                                BCIFixerService.this.addedNewRule(className, transformationRule, retransformInfo.getRulesForClass());
                                                BCIFixerService.this.dynamicRulesManager.registerPropertyMatch(BCIFixerService.DEFAULT_DYNAMIC_PROPERTY, className);
                                            }
                                        }
                                        catch (Throwable e) {
                                            logger.warn("Error checking on class " + className, e);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                ++this.classIdx;
            }
            if (this.shouldApplyNewRuleSet && BCIFixerService.this.bciEngine.isRetransformClassesSupported()) {
                try {
                    BCIFixerService.super.startApplyingNewSet();
                    for (AClassTransformationRule newRule : newRules) {
                        BCIFixerService.super.addTransformationRule(newRule);
                    }
                    BCIFixerService.super.finishApplyingNewSet();
                }
                catch (UnableToRetransformException e) {
                    e.sendError(logger, this.getClass().getSimpleName() + ".processRetransformationBatch()");
                }
                newRules.clear();
            }
            if (this.classIdx == this.classesToExamine.length && BCIFixerService.this.batchFuture != null) {
                BCIFixerService.this.batchFuture.cancel(false);
                BCIFixerService.this.batchFuture = null;
                if (isDebugEnabled) {
                    logger.debug("Number of skipped classes due to GC'ed weak references: " + this.skipped);
                }
            }
            return numOfClassesProcessed;
        }
    }

    protected class BCIFixRunner
    implements IAgentRunnable {
        protected BCIFixRunner() {
        }

        public void run() {
            BCIFixerService.this.runOnce();
        }
    }
}

