/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.transactionmonitor.error.common.spi;

import com.singularity.ee.agent.appagent.services.transactionmonitor.error.common.spi.AErrorObject;
import com.singularity.ee.agent.appagent.services.transactionmonitor.error.common.spi.ErrorKey;
import com.singularity.ee.agent.appagent.services.transactionmonitor.error.common.spi.ErrorType;

public class AgentInternalError
extends AErrorObject {
    public static final String AGENT_INTERNAL_ERROR_MESSAGE_PREFIX = "com.singularity.ReflectionError";
    public static final AgentInternalError REFLECTION_UTIL_ERROR = new AgentInternalError("com.singularity.ReflectionError");
    private String message;
    private String displayName;
    private ErrorKey errorKey;

    public AgentInternalError(String msg) {
        super(msg);
        this.message = msg;
        this.displayName = "Agent Internal: " + this.message;
        this.errorKey = new AgentInteralErrorKey(msg);
    }

    @Override
    public ErrorType getType() {
        return ErrorType.AGENT_INTERNAL_ERROR;
    }

    @Override
    public boolean matchName(String name) {
        return this.message.equals(name);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getSummary() {
        return this.displayName;
    }

    @Override
    public ErrorKey getErrorKey() {
        return this.errorKey;
    }

    @Override
    public String getUniqueKeyString() {
        return this.message;
    }

    @Override
    public String getEventSummary() {
        return this.displayName;
    }

    @Override
    public String getKeyForEventDetail() {
        return this.displayName;
    }

    @Override
    public String getEventDetail() {
        return this.message;
    }

    private class AgentInteralErrorKey
    implements ErrorKey {
        private String message;

        public AgentInteralErrorKey(String message) {
            this.message = message;
        }

        @Override
        public int hashCode() {
            return this.message.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.message.equals(((AgentInteralErrorKey)obj).message);
        }
    }
}

