/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.transactionmonitor.instrumentation;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.appdynamics.org.xml.sax.SAXException;
import com.singularity.ee.agent.appagent.kernel.IAgentInstallManager;
import com.singularity.ee.agent.appagent.services.transactionmonitor.spi.IInstrumentationPropertyListener;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.xml.XMLParseUtility;
import com.singularity.ee.util.xml.XMLWriteException;
import com.singularity.ee.util.xml.XMLWriter;
import dagger.CustomImpl;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@CustomImpl
public class DynamicRulesManager {
    public static final String FILE_NAME = "bcirules.xml";
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.DynamicRulesManager");
    private final ConcurrentMap<String, IInstrumentationPropertyListener> listeners = new ConcurrentHashMap<String, IInstrumentationPropertyListener>();
    private final ConcurrentMap<String, Set<String>> registeredPropertyMatches = new ConcurrentHashMap<String, Set<String>>();
    private final IAgentInstallManager installManager;

    @Inject
    public DynamicRulesManager(IAgentInstallManager installManager) {
        this.installManager = installManager;
    }

    public void loadRules() {
        try {
            Map<String, String> props = this.readXML();
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                Set classNames = StringOperations.parseCommaSeparatedStringAsSet((String)value);
                IInstrumentationPropertyListener listener = this.getListener(key);
                if (listener != null) {
                    listener.instrumentationPropertyChanged(key, classNames);
                }
                this.registeredPropertyMatches.put(key, new CopyOnWriteArraySet(classNames));
            }
        }
        catch (Exception e) {
            logger.info("Could not parse Custom BCI Match Rules", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initialized DynamicsRulesManager");
        }
    }

    public void addListener(String propertyName, IInstrumentationPropertyListener listener) {
        this.listeners.put(propertyName, listener);
        if (logger.isDebugEnabled()) {
            logger.debug("Associated IInstrumentationPropertyListener [" + listener + "] to property [" + propertyName + "]");
        }
    }

    public boolean notifyListener(String propertyName, String className) {
        IInstrumentationPropertyListener listener = (IInstrumentationPropertyListener)this.listeners.get(propertyName);
        if (listener != null) {
            listener.instrumentationPropertyChanged(propertyName, Collections.singleton(className));
            return true;
        }
        return false;
    }

    public boolean isPropertyRegisteredForClass(String propertyName, String className) {
        Set classNames = (Set)this.registeredPropertyMatches.get(propertyName);
        return classNames == null ? false : classNames.contains(className);
    }

    public void registerPropertyMatch(String propertyName, String className) {
        if (!this.registeredPropertyMatches.containsKey(propertyName)) {
            this.registeredPropertyMatches.putIfAbsent(propertyName, new CopyOnWriteArraySet());
        }
        ((Set)this.registeredPropertyMatches.get(propertyName)).add(className);
    }

    IInstrumentationPropertyListener getListener(String propertyName) {
        return (IInstrumentationPropertyListener)this.listeners.get(propertyName);
    }

    Map<String, String> readXML() throws IOException, SAXException, ParserConfigurationException {
        File rulesFile = this.getRulesFile();
        if (!rulesFile.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Rules file [" + rulesFile + "] does not exist on disk");
            }
            return Collections.EMPTY_MAP;
        }
        logger.info("Reading current dynamic rules from [" + rulesFile.getCanonicalPath() + "]");
        Map props = Collections.EMPTY_MAP;
        Document xmlDoc = XMLParseUtility.getXmlDocumentFromFile((File)rulesFile);
        Element propsNode = XMLParseUtility.getFirstDirectChildUnderWithName((Node)xmlDoc.getDocumentElement(), (String)"instrumentation-properties");
        if (propsNode != null) {
            props = XMLParseUtility.getPropertiesForElementAsMap((Element)propsNode, (String)"property");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Read properties [" + props + "] from rules file [" + rulesFile.getCanonicalPath() + "]");
        }
        return props;
    }

    public void writeXML() throws ParserConfigurationException, XMLWriteException {
        File rulesFile = this.getRulesFile();
        if (!rulesFile.getParentFile().exists()) {
            logger.info("The config directory " + rulesFile.getParentFile() + " is not initialized, not writing " + rulesFile);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Writing properties [" + this.registeredPropertyMatches + "] to file [" + rulesFile + "]");
        }
        XMLWriter xmlWriter = new XMLWriter();
        Document xmlDoc = xmlWriter.getDocument();
        Element rootElement = xmlDoc.createElement("multiple-inheritance-rules");
        xmlDoc.appendChild((Node)rootElement);
        Element propRootElement = xmlDoc.createElement("instrumentation-properties");
        rootElement.appendChild((Node)propRootElement);
        for (String property : this.registeredPropertyMatches.keySet()) {
            Set classNames = (Set)this.registeredPropertyMatches.get(property);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("name", property);
            attributes.put("value", StringOperations.convertToCommaSeparateString((Collection)classNames));
            xmlWriter.addTextNode(propRootElement, "property", attributes);
        }
        XMLWriter.saveToFile((Element)xmlWriter.getDocument().getDocumentElement(), (File)rulesFile);
        if (logger.isDebugEnabled()) {
            logger.debug("Wrote properties [" + this.registeredPropertyMatches + "] to file [" + rulesFile + "]");
        }
    }

    private File getRulesFile() {
        String path = this.installManager.getRuntimeConfDirectory() + File.separator + this.installManager.getNodeDirName() + File.separator + FILE_NAME;
        return new File(path);
    }
}

