/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.transactionmonitor.jms.boot;

import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ABasicClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.appagent.services.transactionmonitor.jms.boot.JMSProviders;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.util.HashSet;
import java.util.Set;

public class JMSClassNameFilter
extends ABasicClassFilter {
    private static Set<String> pkgToExclude = new HashSet<String>();
    private static Set<String> pkgNameOverride = new HashSet<String>();
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.JMSClassNameFilter");

    public JMSClassNameFilter() {
        logger.debug("Package To Exclude :" + pkgToExclude);
        logger.debug("Package Exclude Override :" + pkgNameOverride);
    }

    @Override
    public boolean matchClass(BasicClassInfo basicClassInfo) {
        String clsName = basicClassInfo.getClassName();
        for (String pkgName : pkgNameOverride) {
            if (!clsName.startsWith(pkgName)) continue;
            return true;
        }
        for (String pkgExcl : pkgToExclude) {
            if (!clsName.startsWith(pkgExcl)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void preLoadReferencedClasses() throws ClassNotFoundException {
        Class.forName(BasicClassInfo.class.getName());
    }

    @Override
    public int hashCode() {
        return JMSClassNameFilter.class.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o instanceof JMSClassNameFilter;
    }

    static {
        for (String pkgName : JMSProviders.getJmsPackageID()) {
            pkgToExclude.add(pkgName.replace('.', '/'));
        }
        pkgToExclude.add("$Proxy");
        pkgNameOverride.add("com/ibm/websphere/samples");
    }
}

