/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.transactionmonitor.jms.boot;

import com.singularity.ee.util.collections.CollectionHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JMSProviders {
    public static final String ACTIVE_MQ = "Active MQ";
    public static final String WEBSPHERE_MQ = "Websphere MQ";
    public static final String IBM_WEBSPHERE = "IBM Websphere";
    public static final String ORACLE_WEBLOGIC = "Oracle Weblogic";
    public static final String OPEN_MQ = "Open MQ";
    public static final String TIBCO_MQ = "TIBCO Message Server";
    public static final String FIORANO_MQ = "Fiorano MQ";
    public static final String PROGRESS_SONIC_MQ = "Progress Sonic MQ";
    public static final String JBOSS_MQ = "JBoss Message Server";
    public static final String ORACLE_AQ = "Oracle AQ";
    public static final String OC4J = "OC4J Message Server";
    private static Map<String, String> jmsPackageIDVsProviderName = JMSProviders.initializeJmsPackageIDVsProviderName();
    private static Collection<String> jmsPackageID = JMSProviders.initializeJmsPackageId();

    private static Map<String, String> initializeJmsPackageIDVsProviderName() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("activemq.", ACTIVE_MQ);
        result.put("ibm.mq.", WEBSPHERE_MQ);
        result.put("com.ibm.", IBM_WEBSPHERE);
        result.put("weblogic.", ORACLE_WEBLOGIC);
        result.put("com.sun.", OPEN_MQ);
        result.put("com.tibco.", TIBCO_MQ);
        result.put("fiorano.", FIORANO_MQ);
        result.put("progress.", PROGRESS_SONIC_MQ);
        result.put("org.jboss.", JBOSS_MQ);
        result.put("oracle.", ORACLE_AQ);
        result.put("com.evermind.", OC4J);
        return CollectionHelper.unmodifiableMap(result);
    }

    private static Set<String> initializeJmsPackageId() {
        return CollectionHelper.unmodifiableSet(CollectionHelper.getAllKeys(jmsPackageIDVsProviderName));
    }

    public static Map<String, String> getJmsPackageIDVsProviderName() {
        return jmsPackageIDVsProviderName;
    }

    public static Collection<String> getJmsPackageID() {
        return jmsPackageID;
    }
}

