/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util;

import com.singularity.ee.agent.util.SystemInfo;
import com.singularity.ee.agent.util.scrub.ISensitiveDataScrubber;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.system.SystemUtils;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class AgentSystemInfo
extends SystemInfo {
    public static String[] getVMArgs() {
        try {
            List<String> inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
            LinkedHashSet<String> uniqueInputArgs = new LinkedHashSet<String>(inputArgs);
            return uniqueInputArgs.toArray(new String[uniqueInputArgs.size()]);
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public static Map<String, String> getVMSystemProperties() {
        try {
            HashMap<String, String> stringProperties = new HashMap<String, String>();
            Properties properties = System.getProperties();
            for (Map.Entry entry : properties.entrySet()) {
                stringProperties.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
            return stringProperties;
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    public static Map<String, String> getEnvironmentVariables() {
        try {
            return System.getenv();
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    public static void logVMInfo(ILogger logger) {
        AgentSystemInfo.logVMInfo(logger, null);
    }

    public static void logVMInfo(ILogger logger, ISensitiveDataScrubber scrubber) {
        logger.info("JVM Runtime: \n\tjava.home=" + System.getProperty("java.home") + "\n\t" + "java.vm.vendor" + "=" + System.getProperty("java.vm.vendor") + "\n\t" + "java.vm.name" + "=" + System.getProperty("java.vm.name") + "\n\t" + "java.version" + "=" + System.getProperty("java.version") + "\n\t" + "java.specification.version" + "=" + System.getProperty("java.specification.version") + "\n\t" + "java.runtime.version" + "=" + System.getProperty("java.runtime.version") + "\n\t" + "java.io.tmpdir" + "=" + System.getProperty("java.io.tmpdir", "<unknown>") + "\n\t" + "user.language" + "=" + System.getProperty("user.language", "") + "\n\t" + "user.country" + "=" + System.getProperty("user.country", "") + "\n\t" + "user.variant" + "=" + System.getProperty("user.variant", "") + "\n\tDefault locale=" + Locale.getDefault());
        logger.info("OS Runtime: \n\tos.name=" + System.getProperty("os.name") + "\n\t" + "os.arch" + "=" + System.getProperty("os.arch") + "\n\t" + "os.version" + "=" + System.getProperty("os.version") + "\n\t" + "user.name" + "=" + System.getProperty("user.name", "<unknown>") + "\n\t" + "user.home" + "=" + System.getProperty("user.home", "<unknown>") + "\n\t" + "user.dir" + "=" + System.getProperty("user.dir", "<unknown>"));
        try {
            String[] inputArgs = AgentSystemInfo.getVMArgs();
            if (scrubber != null) {
                scrubber.scrubSystemProperties(inputArgs);
            }
            StringBuilder sb = new StringBuilder();
            for (String inputArg : inputArgs) {
                sb.append(inputArg).append(" | ");
            }
            logger.info("JVM Args : " + sb);
        }
        catch (Exception e) {
            logger.info("JVM Args not available: " + e.getLocalizedMessage());
        }
        SystemUtils.getVMPID((ILogger)logger);
    }

    public static boolean isSoleAgent() {
        try {
            List<String> inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
            return AgentSystemInfo.hasExactlyOneJavaagent(inputArgs);
        }
        catch (Exception e) {
            return false;
        }
    }

    static boolean hasExactlyOneJavaagent(List<String> arguments) {
        int agentCount = 0;
        for (String arg : arguments) {
            if (arg == null || !arg.startsWith("-javaagent:")) continue;
            ++agentCount;
        }
        return agentCount == 1;
    }
}

