/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util;

import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;

public class CountTracker {
    private final AtomicInteger countThisMinute;
    private final int max;
    private final CountTrackerCallback callback;
    private IAgentScheduledFuture countResetFuture;

    public CountTracker(int max) {
        this(max, null);
    }

    public CountTracker(int max, CountTrackerCallback callback) {
        this.max = max;
        this.countThisMinute = new AtomicInteger(0);
        this.callback = callback;
    }

    public boolean startResetTask(IAgentScheduledExecutorService scheduler, int intervalMs) {
        this.countResetFuture = scheduler.scheduleAtFixedRate(new PerMinuteResetTask(), intervalMs, intervalMs, AgentTimeUnit.MILLISECONDS);
        return this.countResetFuture != null;
    }

    public boolean cancelResetTask() {
        if (this.countResetFuture == null) {
            return false;
        }
        return this.countResetFuture.cancel(false);
    }

    public boolean isWithinLimits() {
        return this.countThisMinute.get() <= this.max;
    }

    public AtomicInteger getCountThisMinute() {
        return this.countThisMinute;
    }

    public int getMax() {
        return this.max;
    }

    public static interface CountTrackerCallback {
        public void call();
    }

    private class PerMinuteResetTask
    implements IAgentRunnable {
        private PerMinuteResetTask() {
        }

        public void run() {
            CountTracker.this.countThisMinute.set(0);
            if (CountTracker.this.callback != null) {
                CountTracker.this.callback.call();
            }
        }
    }
}

