/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util;

import com.singularity.ee.agent.util.IMonitoredObject;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.collections.AdaptableConcurrentHashMap;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;
import java.util.HashMap;
import java.util.Map;

public class ObjectMonitor {
    private final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.agentleak.ObjectMonitor");
    private static final long DEFAULT_POLL_FREQUENCY = 60L;
    private static final long DEFAULT_HANG_DETECT = 120L;
    private static final long DEFAULT_MAX_LOG_PER_MONITORED_OBJECT = 5L;
    private static final String POLL_FREQUENCY_PROP = "appdynamics.object.monitor.poll.frequency";
    private static final String HANG_DETECT_PROP = "appdynamics.object.monitor.hang.detect";
    private static final String MAX_LOG_PER_MONITORED_OBJECT_PROP = "appdynamics.object.monitor.max_log";
    private long pollFrequency = StringOperations.safeParseLong((String)SystemUtils.getProperty((String)"appdynamics.object.monitor.poll.frequency"), (long)60L) * 1000L;
    private long hangDetect = StringOperations.safeParseLong((String)SystemUtils.getProperty((String)"appdynamics.object.monitor.hang.detect"), (long)120L) * 1000L;
    private long maxLogPerObject = StringOperations.safeParseLong((String)SystemUtils.getProperty((String)"appdynamics.object.monitor.max_log"), (long)5L);
    private static volatile ObjectMonitor instance;
    private volatile boolean isMonitoring;
    private final AdaptableConcurrentHashMap<IMonitoredObject, MonitoredObjectInfo> mapOfMonitoredObjects = new AdaptableConcurrentHashMap();
    private volatile ObjectMonitorThread thread;

    public static ObjectMonitor getInstance() {
        if (instance == null) {
            ObjectMonitor.getInstanceSync();
        }
        return instance;
    }

    private static synchronized ObjectMonitor getInstanceSync() {
        if (instance == null) {
            instance = new ObjectMonitor();
        }
        return instance;
    }

    private ObjectMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        long cycleNum = 0L;
        try {
            while (true) {
                boolean majorCycle;
                ObjectMonitor objectMonitor = this;
                synchronized (objectMonitor) {
                    if (this.isMonitoring) {
                        this.wait(this.pollFrequency);
                    }
                    if (!this.isMonitoring) {
                        break;
                    }
                }
                boolean bl = majorCycle = ++cycleNum % 10L == 0L;
                if (majorCycle) {
                    this.logger.info("This is a major ObjectMonitor cycle");
                }
                HashMap<String, Integer> classNameCountMap = new HashMap<String, Integer>();
                long currentTime = System.currentTimeMillis();
                for (Map.Entry nextEntry : this.mapOfMonitoredObjects.entrySet()) {
                    String className;
                    Integer countForClass;
                    long timeAlive;
                    IMonitoredObject object = (IMonitoredObject)nextEntry.getKey();
                    MonitoredObjectInfo info = (MonitoredObjectInfo)nextEntry.getValue();
                    if ((majorCycle || (long)info.numTimesLogged < this.maxLogPerObject) && (timeAlive = currentTime - info.timeCreated) >= this.hangDetect && object.shouldLogIfStillAlive()) {
                        this.logger.info(String.format("\n\nThe following object has been alive for %d seconds:\n%s", timeAlive / 1000L, object.getLogStringIfStillAlive()));
                        ++info.numTimesLogged;
                    }
                    countForClass = (countForClass = (Integer)classNameCountMap.get(className = object.getClass().getName())) == null ? Integer.valueOf(1) : Integer.valueOf(countForClass + 1);
                    classNameCountMap.put(className, countForClass);
                }
                if (classNameCountMap.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("\n\nCount of monitored objects by class:");
                    for (Map.Entry nextEntry : classNameCountMap.entrySet()) {
                        sb.append(String.format("\n    %s = %d", nextEntry.getKey(), nextEntry.getValue()));
                    }
                    this.logger.info(sb.toString());
                    continue;
                }
                this.logger.info("There are no monitored objects");
            }
        }
        catch (InterruptedException e) {
            this.logger.error(e.toString(), e);
        }
    }

    public synchronized void register(IMonitoredObject monitoredObject) {
        if (this.isMonitoring) {
            this.mapOfMonitoredObjects.put((Object)monitoredObject, (Object)new MonitoredObjectInfo());
        }
    }

    public synchronized void startMonitoring() {
        if (!this.isMonitoring) {
            this.isMonitoring = true;
            this.thread = new ObjectMonitorThread();
            this.thread.start();
        }
    }

    public synchronized void stopMonitoring() {
        if (this.isMonitoring) {
            this.isMonitoring = false;
            this.notify();
            this.mapOfMonitoredObjects.clear();
            this.thread = null;
        }
    }

    private class ObjectMonitorThread
    extends Thread {
        ObjectMonitorThread() {
            super("ADObjectMonitor");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            ObjectMonitor.this.run();
        }
    }

    private class MonitoredObjectInfo {
        long timeCreated = System.currentTimeMillis();
        int numTimesLogged;

        MonitoredObjectInfo() {
        }
    }
}

