/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util;

import com.singularity.ee.agent.configuration.impl.AgentSchedulerManager;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.collections.poolable.PoolableEntryFactory;
import com.singularity.ee.util.collections.poolable.PoolingHashMap;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import java.util.ArrayList;
import java.util.List;

public class SynchronizedPoolingHashMapPool {
    public static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.SynchronizedPoolingHashMap");
    public static final int MAX_SIZE = 100;
    public static final boolean debug = true;
    private static int hits = 0;
    private static int misses = 0;
    private static final SynchronizedPoolingHashMapPool instance = new SynchronizedPoolingHashMapPool();
    private static IAgentScheduledFuture future;
    private List<PoolingHashMap> pool = new ArrayList<PoolingHashMap>();

    private SynchronizedPoolingHashMapPool() {
        future = AgentSchedulerManager.getAgentGlobalScheduler().scheduleAtFixedRate(new IAgentRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SynchronizedPoolingHashMapPool synchronizedPoolingHashMapPool = instance;
                synchronized (synchronizedPoolingHashMapPool) {
                    SynchronizedPoolingHashMapPool.printStats();
                    hits = 0;
                    misses = 0;
                }
            }
        }, 1800000L, 60000L, AgentTimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PoolingHashMap checkout(int maxEntriesToPool) {
        SynchronizedPoolingHashMapPool synchronizedPoolingHashMapPool = instance;
        synchronized (synchronizedPoolingHashMapPool) {
            int size = SynchronizedPoolingHashMapPool.instance.pool.size();
            if (size > 0) {
                ++hits;
                PoolingHashMap map = SynchronizedPoolingHashMapPool.instance.pool.remove(size - 1);
                if (map.size() > 0) {
                    throw new IllegalStateException("Map not recycled when checking out - " + new Throwable());
                }
                return map;
            }
            ++misses;
        }
        return new PoolingHashMap(new PoolableEntryFactory(maxEntriesToPool));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkin(PoolingHashMap toCheckin) {
        SynchronizedPoolingHashMapPool synchronizedPoolingHashMapPool = instance;
        synchronized (synchronizedPoolingHashMapPool) {
            int size = SynchronizedPoolingHashMapPool.instance.pool.size();
            if (size < 100) {
                toCheckin.clear();
                if (toCheckin.size() > 0) {
                    throw new IllegalStateException("Map not recycled when checking out - " + new Throwable());
                }
                SynchronizedPoolingHashMapPool.instance.pool.add(toCheckin);
            }
        }
    }

    public static void printStats() {
        if (misses != 0) {
            logger.info("Hits [" + hits + "], Misses [" + misses + "]");
        }
    }
}

