/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util;

import com.singularity.ee.agent.configuration.spi.IAgentSchedulerManager;
import com.singularity.ee.agent.util.ICleanupThreadArrayObject;
import com.singularity.ee.agent.util.bounded.collections.BoundedConcurrentLinkedQueue;
import com.singularity.ee.agent.util.bounded.collections.BoundsEnforcer;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Deprecated
public class ThreadArrayCleanupDaemon
implements IAgentRunnable {
    private final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.tm.ThreadArrayCleanupDaemon");
    private static final long MONITOR_FREQUENCY = 60L;
    private final ConcurrentLinkedQueue<CleanupWeakReference<Object[]>> queueOfArraysToMonitor = new BoundedConcurrentLinkedQueue<CleanupWeakReference<Object[]>>(500, BoundsEnforcer.DEFAULT_POLICY, "MetricService", "ThreadArrayCleanupDaemon-queueOfArraysToMonitor-limit");
    private final ThreadMXBean threadMXBean;

    @Inject
    public ThreadArrayCleanupDaemon(IAgentSchedulerManager schedulerManager) {
        this(ManagementFactory.getThreadMXBean(), schedulerManager);
    }

    protected ThreadArrayCleanupDaemon(ThreadMXBean threadMXBean, IAgentSchedulerManager schedulerManager) {
        this.threadMXBean = threadMXBean;
        try {
            schedulerManager.getAgentGlobalScheduler().scheduleAtFixedRate(this, 60L, 60L, AgentTimeUnit.SECONDS);
        }
        catch (IllegalStateException e) {
            this.logger.error(e.toString(), e);
        }
    }

    public void monitor(Object[] arrayToMonitor) {
        this.queueOfArraysToMonitor.add(new CleanupWeakReference<Object[]>(arrayToMonitor));
    }

    public void stopMonitoring(Object[] arrayToStopMonitoring) {
        ArrayList<CleanupWeakReference<Object[]>> elementsToRemove = new ArrayList<CleanupWeakReference<Object[]>>();
        for (CleanupWeakReference<Object[]> cleanupWeakReference : this.queueOfArraysToMonitor) {
            Object[] nextArrayToMonitor = (Object[])cleanupWeakReference.get();
            if (nextArrayToMonitor == null) {
                elementsToRemove.add(cleanupWeakReference);
                continue;
            }
            if (nextArrayToMonitor != arrayToStopMonitoring) continue;
            elementsToRemove.add(cleanupWeakReference);
            break;
        }
        for (CleanupWeakReference<Object> cleanupWeakReference : elementsToRemove) {
            this.queueOfArraysToMonitor.remove(cleanupWeakReference);
        }
    }

    public void run() {
        Set<Long> allActiveThreads = this.getThreadIdActiveSet();
        ArrayList<CleanupWeakReference<Object[]>> elementsToRemove = new ArrayList<CleanupWeakReference<Object[]>>();
        for (CleanupWeakReference<Object[]> cleanupWeakReference : this.queueOfArraysToMonitor) {
            boolean requiresCleanup = cleanupWeakReference.requiresCleanup();
            Object[] nextArray = (Object[])cleanupWeakReference.get();
            if (nextArray == null) {
                elementsToRemove.add(cleanupWeakReference);
                continue;
            }
            for (int i = 0; i < nextArray.length; ++i) {
                Object objectToRemove = nextArray[i];
                if (objectToRemove == null || allActiveThreads.contains(i)) continue;
                if (requiresCleanup) {
                    ((ICleanupThreadArrayObject)objectToRemove).cleanup();
                }
                nextArray[i] = null;
            }
        }
        for (CleanupWeakReference<Object> cleanupWeakReference : elementsToRemove) {
            this.queueOfArraysToMonitor.remove(cleanupWeakReference);
        }
    }

    private Set<Long> getThreadIdActiveSet() {
        long[] allThreadInfo;
        HashSet<Long> returnSet = new HashSet<Long>();
        for (long nextThreadId : allThreadInfo = this.threadMXBean.getAllThreadIds()) {
            returnSet.add(nextThreadId);
        }
        return returnSet;
    }

    private static class CleanupWeakReference<T>
    extends WeakReference<T> {
        private final boolean requiresCleanup;

        public CleanupWeakReference(T referent) {
            super(referent);
            this.requiresCleanup = ICleanupThreadArrayObject.class.isAssignableFrom(referent.getClass().getComponentType());
        }

        public boolean requiresCleanup() {
            return this.requiresCleanup;
        }
    }
}

