/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.bounded.collections;

import com.singularity.ee.agent.configuration.spi.IAgentSchedulerManager;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.reflect.AgentReflectionUtility;
import com.singularity.ee.agent.util.thread.ThreadUtil;
import com.singularity.ee.util.collections.AdaptableConcurrentHashMap;
import com.singularity.ee.util.collections.bounded.IBoundedCollection;
import com.singularity.ee.util.collections.bounded.IBoundsMonitor;
import com.singularity.ee.util.collections.bounded.SharedBoundsEnforcer;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.thread.CurrentRequestThread;
import com.singularity.ee.util.thread.IRequestThread;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class BoundedCollectionMonitor
implements IAgentRunnable,
IBoundsMonitor {
    static IADLogger logger = ADLoggerFactory.getLogger("com.singularity.util.boundedcollections.BoundedCollectionMonitor");
    private static final long MONITOR_FREQUENCY = 300L;
    private static final String thisPackageName = BoundedCollectionMonitor.getPackageName(BoundedCollectionMonitor.class);
    private static final String parentPackageName = BoundedCollectionMonitor.getPackageName(IBoundsMonitor.class);
    private static BoundedCollectionMonitor instance;
    private final ConcurrentMap<SharedBoundsEnforcer, StackTraceElement> monitoredCollections = new AdaptableConcurrentHashMap();

    private static String getPackageName(Class<?> clazz) {
        String packageName = "";
        Package pkg = clazz.getPackage();
        if (pkg != null) {
            packageName = pkg.getName();
        } else {
            String className = clazz.getName();
            int lastQualifierOffset = className.lastIndexOf(46);
            if (lastQualifierOffset > 0) {
                packageName = className.substring(0, lastQualifierOffset - 1);
            }
        }
        return packageName;
    }

    public static final BoundedCollectionMonitor getInstance() {
        if (instance == null) {
            BoundedCollectionMonitor.getInstanceSync();
        }
        return instance;
    }

    private static final synchronized BoundedCollectionMonitor getInstanceSync() {
        if (instance == null) {
            instance = new BoundedCollectionMonitor();
        }
        return instance;
    }

    private BoundedCollectionMonitor() {
    }

    public void startMonitoring(IAgentSchedulerManager agentSchedulerManager) {
        if (logger.isDebugEnabled()) {
            agentSchedulerManager.getAgentGlobalScheduler().scheduleAtFixedRate(this, 300L, 300L, AgentTimeUnit.SECONDS);
            logger.debug("Monitoring task has been created");
        }
    }

    public void run() {
        for (Map.Entry nextMapEntry : this.monitoredCollections.entrySet()) {
            SharedBoundsEnforcer boundsEnforcer = (SharedBoundsEnforcer)nextMapEntry.getKey();
            StackTraceElement creatingLocation = (StackTraceElement)nextMapEntry.getValue();
            IBoundedCollection collection = boundsEnforcer.getCollection();
            int size = collection.getCurrentSize();
            if (size <= 0) continue;
            logger.debug("Collection " + AgentReflectionUtility.getName(collection.getClass()) + " created by " + creatingLocation.toString() + (boundsEnforcer.getBoundsPropertyName() != null ? " property name " + boundsEnforcer.getBoundsPropertyName() : "") + "  contains " + size + " elements.  Upper Bound is " + boundsEnforcer.getUpperLimit() + ".  Policy is " + boundsEnforcer.getPolicy().toString());
        }
    }

    @Override
    public void registerCollection(SharedBoundsEnforcer boundsEnforcer) {
        StackTraceElement[] stackTrace;
        if (logger.isDebugEnabled() && (stackTrace = ThreadUtil.getStackTrace((IRequestThread)new CurrentRequestThread())) != null) {
            for (int i = 0; i < stackTrace.length; ++i) {
                String className = stackTrace[i].getClassName();
                if (className.startsWith("java.lang.") || className.startsWith(thisPackageName) || className.startsWith(parentPackageName)) continue;
                this.monitoredCollections.put(boundsEnforcer, stackTrace[i]);
                break;
            }
        }
    }
}

