/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.bounded.collections;

import com.singularity.ee.agent.appagent.services.transactionmonitor.error.common.spi.AErrorObject;
import com.singularity.ee.agent.appagent.services.transactionmonitor.error.common.spi.ErrorKey;
import com.singularity.ee.agent.appagent.services.transactionmonitor.error.common.spi.ErrorType;
import com.singularity.ee.agent.util.bounded.collections.BoundsEnforcer;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;

public class BoundedCollectionOverflowError
extends AErrorObject {
    BoundsEnforcer boundsEnforcer;
    private final String displayName;
    private final String summary;

    public BoundedCollectionOverflowError(BoundsEnforcer boundsEnforcer) {
        super(boundsEnforcer);
        this.boundsEnforcer = boundsEnforcer;
        BoundsPolicy policy = boundsEnforcer.getPolicyToUse();
        this.displayName = "com.singularity.BoundedCollectionOverflowError - " + boundsEnforcer.getBoundsPropertyName();
        this.summary = BoundedCollectionOverflowError.createSummaryText(policy, boundsEnforcer);
    }

    private static String createSummaryText(BoundsPolicy policy, BoundsEnforcer boundsEnforcer) {
        StringBuilder sb = new StringBuilder();
        if (policy == BoundsPolicy.WARN_IF_BOUND_EXCEEDED) {
            sb.append("Warning");
        } else {
            sb.append("Error");
        }
        sb.append(" - Overflow for " + boundsEnforcer);
        return sb.toString();
    }

    @Override
    public ErrorType getType() {
        return ErrorType.AGENT_INTERNAL_ERROR;
    }

    @Override
    public boolean matchName(String name) {
        return this.boundsEnforcer.toString().equals(name);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public ErrorKey getErrorKey() {
        return new OverflowErrorKey(this.boundsEnforcer);
    }

    @Override
    public String getUniqueKeyString() {
        return this.displayName;
    }

    @Override
    public String getEventSummary() {
        return this.summary;
    }

    @Override
    public String getKeyForEventDetail() {
        return this.displayName;
    }

    @Override
    public String getEventDetail() {
        return this.displayName;
    }

    private class OverflowErrorKey
    implements ErrorKey {
        final BoundsEnforcer boundsEnforcer;

        OverflowErrorKey(BoundsEnforcer boundsEnforcer) {
            this.boundsEnforcer = boundsEnforcer;
        }

        @Override
        public int hashCode() {
            return this.boundsEnforcer.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            boolean bReturn;
            boolean bl = bReturn = this == o;
            if (!bReturn && o instanceof OverflowErrorKey) {
                OverflowErrorKey other = (OverflowErrorKey)o;
                bReturn = this.getBoundsEnforcer() == other.getBoundsEnforcer();
            }
            return bReturn;
        }

        private BoundsEnforcer getBoundsEnforcer() {
            return this.boundsEnforcer;
        }
    }
}

