/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.bounded.collections;

import com.singularity.ee.agent.util.bounded.collections.BoundsEnforcer;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.IBoundedCollection;
import com.singularity.ee.util.collections.bounded.SharedBoundsEnforcer;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BoundedConcurrentLinkedQueue<E>
extends ConcurrentLinkedQueue<E>
implements IBoundedCollection {
    private static final long serialVersionUID = 1L;
    private final BoundsEnforcer boundsEnforcer;

    public BoundedConcurrentLinkedQueue(int upperLimit) {
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).build();
    }

    public BoundedConcurrentLinkedQueue(int upperLimit, BoundsPolicy policy) {
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).withPolicy(policy).build();
    }

    public BoundedConcurrentLinkedQueue(int upperLimit, BoundsPolicy policy, String serviceName, String propertyName) {
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).withPolicy(policy).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
    }

    public BoundedConcurrentLinkedQueue(int upperLimit, String serviceName, String propertyName) {
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
    }

    @Override
    public boolean offer(E e) {
        boolean bReturn = false;
        if (this.boundsEnforcer.checkCapacity(1)) {
            bReturn = super.offer(e);
        }
        return bReturn;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean bReturn = false;
        if (this.boundsEnforcer.checkCapacity(c.size())) {
            bReturn = super.addAll(c);
        }
        return bReturn;
    }

    @Override
    public void _resize(int newLimit) {
    }

    @Override
    public int getCurrentSize() {
        return this.size();
    }

    @Override
    public void setNewUpperBound(int newUpperBound) {
        this.boundsEnforcer.setNewLimit(newUpperBound);
    }

    @Override
    public void setNewPolicy(BoundsPolicy policy) {
        this.boundsEnforcer.setNewPolicy(policy);
    }

    @Override
    public SharedBoundsEnforcer getBoundsEnforcer() {
        return this.boundsEnforcer;
    }

    @Override
    public void setShouldIssue80PercentWarning(boolean shouldIssue80PercentWarning) {
        this.boundsEnforcer.setShouldIssue80PercentWarning(shouldIssue80PercentWarning);
    }

    public void drainTo(Collection<E> collection) {
        Object element;
        int polled = 0;
        while ((element = this.poll()) != null && polled++ < this.boundsEnforcer.getUpperLimit()) {
            collection.add(element);
        }
    }
}

