/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.bounded.collections;

import com.singularity.ee.agent.util.bounded.collections.BoundsEnforcer;
import com.singularity.ee.util.collections.bounded.BoundedCollectionLimits;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.IBoundedCollection;
import com.singularity.ee.util.collections.bounded.SharedBoundsEnforcer;
import java.util.HashMap;

public class BoundedHashMap<K, V>
extends HashMap<K, V>
implements IBoundedCollection {
    private static final long serialVersionUID = 1L;
    private final BoundsEnforcer boundsEnforcer;

    public BoundedHashMap(int initialCapacity, int upperLimit) {
        super(initialCapacity);
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).build();
    }

    public BoundedHashMap(int initialCapacity, float loadFactor, int upperLimit) {
        super(initialCapacity, loadFactor);
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).build();
    }

    public BoundedHashMap(int upperLimit, BoundsPolicy policy) {
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).withPolicy(policy).build();
    }

    public BoundedHashMap(int initialCapacity, int upperLimit, BoundsPolicy policy, String serviceName, String propertyName) {
        super(initialCapacity);
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).withPolicy(policy).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
    }

    public BoundedHashMap(int initialCapacity, float loadFactor, int upperLimit, BoundsPolicy policy, String serviceName, String propertyName) {
        super(initialCapacity, loadFactor);
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).withPolicy(policy).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
    }

    public BoundedHashMap(int upperLimit, BoundsPolicy policy, String serviceName, String propertyName) {
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).withPolicy(policy).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
    }

    public BoundedHashMap(int upperLimit, String serviceName, String propertyName) {
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
    }

    public BoundedHashMap(int initialCapacity, int upperLimit, String serviceName, String propertyName) {
        super(initialCapacity);
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
    }

    public BoundedHashMap(int initialCapacity, float loadFactor, int upperLimit, String serviceName, String propertyName) {
        super(initialCapacity, loadFactor);
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).withPolicy(BoundedCollectionLimits.DEFAULT_BOUNDS_POLICY).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
    }

    @Override
    public void _resize(int newLimit) {
    }

    @Override
    public V put(K k, V v) {
        V returnValue = null;
        if (this.get(k) != null || this.boundsEnforcer.checkCapacity(1)) {
            returnValue = super.put(k, v);
        }
        return returnValue;
    }

    @Override
    public int getCurrentSize() {
        return this.size();
    }

    @Override
    public void setNewUpperBound(int newUpperBound) {
        this.boundsEnforcer.setNewLimit(newUpperBound);
    }

    @Override
    public void setNewPolicy(BoundsPolicy policy) {
        this.boundsEnforcer.setNewPolicy(policy);
    }

    @Override
    public SharedBoundsEnforcer getBoundsEnforcer() {
        return this.boundsEnforcer;
    }

    @Override
    public void setShouldIssue80PercentWarning(boolean shouldIssue80PercentWarning) {
        this.boundsEnforcer.setShouldIssue80PercentWarning(shouldIssue80PercentWarning);
    }
}

