/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.bounded.collections;

import com.singularity.ee.agent.util.bounded.collections.BoundsEnforcer;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.IBoundedCollection;
import com.singularity.ee.util.collections.bounded.SharedBoundsEnforcer;
import com.singularity.ee.util.collections.poolable.PoolableEntryFactory;
import com.singularity.ee.util.collections.poolable.PoolingHashMap;
import java.util.Map;

public class BoundedPoolingHashMap<K, V>
extends PoolingHashMap<K, V>
implements IBoundedCollection {
    private final BoundsEnforcer boundsEnforcer;

    public BoundedPoolingHashMap(PoolableEntryFactory<K, V> entryFactory, int upperLimit) {
        super(entryFactory);
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).build();
    }

    public BoundedPoolingHashMap(PoolableEntryFactory<K, V> entryFactory, int upperLimit, BoundsPolicy policy) {
        super(entryFactory);
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).withPolicy(policy).build();
    }

    public BoundedPoolingHashMap(PoolableEntryFactory<K, V> entryFactory, int upperLimit, BoundsPolicy policy, String serviceName, String propertyName) {
        super(entryFactory);
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).withPolicy(policy).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
    }

    public BoundedPoolingHashMap(PoolableEntryFactory<K, V> entryFactory, int upperLimit, String serviceName, String propertyName) {
        super(entryFactory);
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
    }

    @Override
    public V put(K key, V value) {
        V returnValue = null;
        if (this.get(key) != null || this.boundsEnforcer.checkCapacity(1)) {
            returnValue = super.put(key, value);
        }
        return returnValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (this.boundsEnforcer.checkCapacity(m.size())) {
            super.putAll(m);
        }
    }

    @Override
    public int getCurrentSize() {
        return this.size();
    }

    @Override
    public void setNewUpperBound(int newUpperBound) {
        this.boundsEnforcer.setNewLimit(newUpperBound);
    }

    @Override
    public void setNewPolicy(BoundsPolicy policy) {
        this.boundsEnforcer.setNewPolicy(policy);
    }

    @Override
    public SharedBoundsEnforcer getBoundsEnforcer() {
        return this.boundsEnforcer;
    }

    @Override
    public void _resize(int newSize) {
    }

    @Override
    public void setShouldIssue80PercentWarning(boolean shouldIssue80PercentWarning) {
        this.boundsEnforcer.setShouldIssue80PercentWarning(shouldIssue80PercentWarning);
    }
}

