/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.bounded.collections;

import com.singularity.ee.agent.util.bounded.collections.BoundsEnforcer;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.IBoundedCollection;
import com.singularity.ee.util.collections.bounded.SharedBoundsEnforcer;
import java.util.Collection;
import java.util.TreeSet;

public class BoundedTreeSet<E>
extends TreeSet<E>
implements IBoundedCollection {
    private static final long serialVersionUID = 1L;
    private final BoundsEnforcer boundsEnforcer;

    public BoundedTreeSet(int upperLimit) {
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).build();
    }

    public BoundedTreeSet(int upperLimit, BoundsPolicy policy, String serviceName, String propertyName) {
        this.boundsEnforcer = new BoundsEnforcer.Builder().withCollection((IBoundedCollection)this).withUpperLimit(upperLimit).withPolicy(policy).withServiceName(serviceName).withOverridePropertyName(propertyName).build();
    }

    @Override
    public boolean add(E e) {
        boolean bReturn = false;
        if (this.contains(e) || this.boundsEnforcer.checkCapacity(1)) {
            bReturn = super.add(e);
        }
        return bReturn;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean bReturn = false;
        if (this.boundsEnforcer.checkCapacity(c.size())) {
            bReturn = super.addAll(c);
        }
        return bReturn;
    }

    @Override
    public int getCurrentSize() {
        return this.size();
    }

    @Override
    public void setNewUpperBound(int newUpperBound) {
        this.boundsEnforcer.setNewLimit(newUpperBound);
    }

    @Override
    public void setNewPolicy(BoundsPolicy policy) {
        this.boundsEnforcer.setNewPolicy(policy);
    }

    @Override
    public SharedBoundsEnforcer getBoundsEnforcer() {
        return this.boundsEnforcer;
    }

    @Override
    public void setShouldIssue80PercentWarning(boolean shouldIssue80PercentWarning) {
        this.boundsEnforcer.setShouldIssue80PercentWarning(shouldIssue80PercentWarning);
    }

    @Override
    public void _resize(int newLimit) {
    }
}

