/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.cache;

import com.singularity.ee.agent.util.cache.ILRUCacheDeletionAdvisor;
import com.singularity.ee.agent.util.cache.LRUCacheBase;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class WeakLRUCache<K, V>
extends LRUCacheBase<K, V>
implements IAgentRunnable {
    ReferenceQueue<? super K> refQueue = new ReferenceQueue();
    private volatile int numGCdElementsRemoved;

    public WeakLRUCache(int maxSize, int freePctIfMaxReached, IAgentScheduledThreadPoolExecutor agentGlobalScheduler) {
        this(maxSize, freePctIfMaxReached, null, 0L, agentGlobalScheduler);
    }

    public WeakLRUCache(int maxSize, int freePctIfMaxReached, String nameOfCache, IAgentScheduledThreadPoolExecutor agentGlobalScheduler) {
        this(maxSize, freePctIfMaxReached, nameOfCache, 0L, agentGlobalScheduler);
    }

    public WeakLRUCache(int maxSize, int freePctIfMaxReached, String nameOfCache, long maxInactiveTime, IAgentScheduledThreadPoolExecutor agentGlobalScheduler) {
        this(maxSize, freePctIfMaxReached, nameOfCache, maxInactiveTime, null, agentGlobalScheduler);
    }

    public WeakLRUCache(int maxSize, int freePctIfMaxReached, String nameOfCache, long maxInactiveTime, ILRUCacheDeletionAdvisor<K, V> deletionAdvisor, IAgentScheduledThreadPoolExecutor agentGlobalScheduler) {
        super(maxSize, freePctIfMaxReached, nameOfCache, maxInactiveTime, deletionAdvisor, agentGlobalScheduler);
        if (!this.periodicMaintenanceScheduled) {
            agentGlobalScheduler.scheduleAtFixedRate(this, currentMonitorFrequency, currentMonitorFrequency, AgentTimeUnit.SECONDS);
        }
    }

    protected LRUCacheBase.Key getKey(K actualKey) {
        return new WeakKey(actualKey);
    }

    protected void manage() {
        this.removeDeadReferences();
        super.manage();
    }

    void removeOld() {
        this.removeDeadReferences();
        super.removeOld();
    }

    protected void performAdditionalMaintenance() {
        this.removeDeadReferences();
    }

    private void removeDeadReferences() {
        LRUWeakReference refRemoved = null;
        while ((refRemoved = (LRUWeakReference)this.refQueue.poll()) != null) {
            this.wrappedMap.remove((Object)refRemoved.weakKey);
            ++this.numGCdElementsRemoved;
        }
    }

    public void run() {
        this.removeDeadReferences();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("  number of GC'd elements removed = ").append(Integer.toString(this.numGCdElementsRemoved));
        return sb.toString();
    }

    private class WeakKey
    extends LRUCacheBase.Key {
        private final LRUWeakReference ref;
        private final int hashValue;

        WeakKey(K actualKey) {
            super((LRUCacheBase)WeakLRUCache.this);
            this.ref = new LRUWeakReference(actualKey, this);
            this.hashValue = actualKey.hashCode();
        }

        K getActualKey() {
            return this.ref.get();
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object o) {
            boolean bReturn;
            boolean bl = bReturn = this == o;
            if (!bReturn && o instanceof WeakKey) {
                Object otherRef;
                WeakKey other = (WeakKey)((Object)o);
                Object thisRef = this.ref.get();
                boolean bl2 = bReturn = thisRef == (otherRef = other.ref.get());
                if (!bReturn && this.hashValue == other.hashValue) {
                    bReturn = thisRef != null ? thisRef.equals(otherRef) : otherRef == null;
                }
            }
            return bReturn;
        }
    }

    private class LRUWeakReference
    extends WeakReference<K> {
        WeakKey weakKey;

        LRUWeakReference(K reffedObject, WeakKey weakKey) {
            super(reffedObject, WeakLRUCache.this.refQueue);
            this.weakKey = weakKey;
        }
    }
}

