/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.calltracer;

import com.singularity.ee.agent.appagent.kernel.boot.JavaAgentBootExtension;
import com.singularity.ee.agent.commonservices.IPropertyChangeListener;
import com.singularity.ee.agent.util.calltracer.trace.AllocationTraceStore;
import com.singularity.ee.agent.util.calltracer.trace.AllocationTraces;
import com.singularity.ee.agent.util.calltracer.trace.CallTraceInterceptor;
import com.singularity.ee.agent.util.calltracer.trace.ITraceStore;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.dtobootimpl.EventTypeBoot;
import com.singularity.ee.util.dtobootimpl.NotificationSeverityBoot;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.reflect.ClassCacheHashKey;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class CallTraceService
implements IAgentRunnable,
IPropertyChangeListener {
    private static IADLogger logger = ADLoggerFactory.getLogger("com.singularity.CallTracer");
    public static final String ENABLE_CALL_TRACE = "enable-call-trace";
    private static final int INTERVAL_IN_SECONDS = 60;
    private ITraceStore traceStore = new AllocationTraceStore(logger);

    public CallTraceService(IAgentScheduledExecutorService scheduler, boolean enable) {
        this.traceStore.setTraceEnabled(enable);
        CallTraceInterceptor.setTraceStore(this.traceStore);
        scheduler.scheduleAtFixedRate(this, 60L, 60L, AgentTimeUnit.SECONDS);
    }

    public void run() {
        if (!this.traceStore.isTracingEnabled()) {
            return;
        }
        this.processCallTraces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCallTraces() {
        Map<ClassCacheHashKey, AllocationTraces> tracesMap = this.traceStore.getAllAllocationTraces();
        try {
            for (ClassCacheHashKey tracerKey : tracesMap.keySet()) {
                String summary = "Call Tracer diagnostic data for " + tracerKey;
                HashMap<String, String> detailMap = new HashMap<String, String>();
                Map<String, AtomicInteger> occMap = tracesMap.get(tracerKey).getAllocationTraces();
                for (String trace : occMap.keySet()) {
                    detailMap.put("Occurrence [" + occMap.get(trace) + "] times", "Invoker [" + trace + "]");
                }
                JavaAgentBootExtension.getInstance().getBootServiceProvider().writeAgentEventData(ClockUtils.getCurrentTime(), NotificationSeverityBoot.INFO, EventTypeBoot.ACTIVITY_TRACE, detailMap, summary);
            }
            if (tracesMap.size() > 0) {
                logger.info("Published event with call trace info for " + tracesMap);
            }
        }
        catch (Throwable t) {
            logger.error("Error in processing call trace map " + tracesMap.keySet(), t);
        }
        finally {
            this.traceStore.clear();
        }
    }

    public void propertyChanged(String propertyName, String newPropertyValue) {
        logger.info("Updated property " + propertyName + ", Val " + newPropertyValue);
        if (propertyName.equals(ENABLE_CALL_TRACE)) {
            this.traceStore.setTraceEnabled(Boolean.parseBoolean(newPropertyValue));
        }
    }
}

