/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.calltracer.trace;

import com.singularity.ee.agent.util.calltracer.trace.AllocationTraces;
import com.singularity.ee.agent.util.calltracer.trace.ITraceStore;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.reflect.ClassCacheHashKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AllocationTraceStore
implements ITraceStore {
    private static Map<ClassCacheHashKey, AllocationTraces> tracesMap = new ConcurrentHashMap<ClassCacheHashKey, AllocationTraces>();
    private static final int MAX_CONCURRENT_TRACES = 5;
    private static final int MAX_TOTAL_TRACES = 50;
    private static final int MAX_UNIQUE_TRACES = 20;
    private int maxConcurrentTraces;
    private int maxTotalTraces;
    private int maxUniqueTraces;
    private boolean traceEnabled;
    private IADLogger logger;

    public AllocationTraceStore(IADLogger logger) {
        this(logger, 5, 50, 20);
    }

    public AllocationTraceStore(IADLogger logger, int maxConcurrentTraces, int maxTotalTraces, int maxUniqueTraces) {
        this.logger = logger;
        this.maxConcurrentTraces = maxConcurrentTraces;
        this.maxTotalTraces = maxTotalTraces;
        this.maxUniqueTraces = maxUniqueTraces;
    }

    @Override
    public boolean isTracingEnabled() {
        return this.traceEnabled;
    }

    @Override
    public void setTraceEnabled(boolean enable) {
        this.traceEnabled = enable;
    }

    @Override
    public Map<ClassCacheHashKey, AllocationTraces> getAllAllocationTraces() {
        return tracesMap;
    }

    @Override
    public AllocationTraces getAllocationTracesFor(ClassCacheHashKey key) {
        return tracesMap.get(key);
    }

    @Override
    public AllocationTraces getAllocationTracesForEdit(ClassCacheHashKey key) {
        AllocationTraces traces = tracesMap.get(key);
        if (traces == null) {
            if (tracesMap.size() >= 5) {
                this.logger.warn("Max Concurrent Trace limit 5 reached for. Traces will not be collected for " + key.getClassAndMethodName());
                return null;
            }
            traces = new AllocationTraces();
            tracesMap.put(key, traces);
            return traces;
        }
        if (traces.getTotalStackTraces() >= 50 || traces.getTotalUniqueStackTraces() >= 20) {
            this.logger.warn("Max traces limit max total[50], max unique[20] reached for " + key.getClassAndMethodName());
            return null;
        }
        return traces;
    }

    @Override
    public void clear() {
        tracesMap.clear();
    }
}

