/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.calltracer.trace;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class AllocationTraces {
    private static final String APPDYNAMICS_PKG = "singularity";
    public static final int ALLOCATION_STACK_DEPTH = 10;
    private static final String NEW_LINE = "\n";
    private AtomicInteger totalStackTraces = new AtomicInteger();
    private Map<String, AtomicInteger> allocationTraces = new ConcurrentHashMap<String, AtomicInteger>();

    public void addStackTrace(StackTraceElement[] traceElements) {
        String trace;
        AtomicInteger count;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (StackTraceElement traceElement : traceElements) {
            if (!traceElement.toString().contains(APPDYNAMICS_PKG)) {
                if (i > 0) {
                    sb.append(traceElement).append(NEW_LINE);
                }
                ++i;
            }
            if (i > 10) break;
        }
        if ((count = this.allocationTraces.get(trace = sb.toString())) == null) {
            this.allocationTraces.put(trace, new AtomicInteger(1));
        } else {
            count.incrementAndGet();
        }
        this.totalStackTraces.incrementAndGet();
    }

    public Map<String, AtomicInteger> getAllocationTraces() {
        return this.allocationTraces;
    }

    public int getTotalUniqueStackTraces() {
        return this.allocationTraces.size();
    }

    public int getTotalStackTraces() {
        return this.totalStackTraces.get();
    }
}

