/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.calltracer.trace;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.MethodExecutionEnvironment;
import com.singularity.ee.agent.appagent.services.transactionmonitor.common.boot.ATrackedMethodInterceptor;
import com.singularity.ee.agent.util.calltracer.trace.AllocationTraces;
import com.singularity.ee.agent.util.calltracer.trace.ITraceStore;
import com.singularity.ee.util.reflect.ClassCacheHashKey;

public class CallTraceInterceptor
extends ATrackedMethodInterceptor {
    private static final String NAME = "com.singularity.CallTraceInterceptor";
    private static final String DESCRIPTION = "data.CallTrace";
    private static ITraceStore traceStore = null;

    public static void setTraceStore(ITraceStore traceStore) {
        CallTraceInterceptor.traceStore = traceStore;
    }

    @Override
    public void onMethodBeginTracked(MethodExecutionEnvironment env) {
        ClassCacheHashKey key;
        AllocationTraces traces;
        if (traceStore.isTracingEnabled() && (traces = traceStore.getAllocationTracesForEdit(key = new ClassCacheHashKey(env.getClassName(), env.getMethodName(), env.getParamClasses()))) != null) {
            traces.addStackTrace(Thread.currentThread().getStackTrace());
        }
    }

    @Override
    public void onMethodEndTracked(MethodExecutionEnvironment env) {
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }
}

