/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.debug;

import com.singularity.ee.agent.configuration.impl.AgentSchedulerManager;
import com.singularity.ee.agent.util.io.Console;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import java.util.Vector;

public class MethodTimer {
    private static boolean runtimeEnabled = true;
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.debug.MethodTimer");
    static final Id[] enabledList = new Id[0];
    protected static final boolean[] enabled;
    static ThreadLocal<MyLong[]> startTime;
    static ThreadLocal<MyLong[]> numberOfTimes;
    static ThreadLocal<MyLong[]> totalTimeTaken;
    static Vector<Counter> allCounters;

    public static void methodTimerEumHeaderEnd() {
        if (enabled[Id.EUMReadHeader.ordinal()]) {
            MethodTimer.reportEnd(Id.EUMReadHeader);
        }
    }

    public static void methodTimerEumReadHeaderBegin() {
        if (enabled[Id.EUMReadHeader.ordinal()]) {
            MethodTimer.reportBegin(Id.EUMReadHeader);
        }
    }

    public static void methodTimerEumOnTxBeginEnd() {
        if (enabled[Id.EUMOnTxBegin.ordinal()]) {
            MethodTimer.reportEnd(Id.EUMOnTxBegin);
        }
    }

    public static void methodTimerEumOnTxBeginStart() {
        if (enabled[Id.EUMOnTxBegin.ordinal()]) {
            MethodTimer.reportBegin(Id.EUMOnTxBegin);
        }
    }

    public static void methodTimerEumWatchCheckEnd() {
        if (enabled[Id.EUMWatchCheck.ordinal()]) {
            MethodTimer.reportEnd(Id.EUMWatchCheck);
        }
    }

    private static boolean enabledListContains(int id) {
        for (Id b : enabledList) {
            if (b.ordinal() != id) continue;
            return true;
        }
        return false;
    }

    public static void reportBegin(Id id) {
        if (!runtimeEnabled) {
            return;
        }
        MyLong localStartTime = null;
        if (startTime.get() == null) {
            localStartTime = new MyLong();
            startTime.set(MethodTimer.createNewMyLongArray());
            MethodTimer.startTime.get()[id.ordinal()] = localStartTime;
            numberOfTimes.set(MethodTimer.createNewMyLongArray());
            totalTimeTaken.set(MethodTimer.createNewMyLongArray());
            allCounters.add(new Counter(startTime.get(), numberOfTimes.get(), totalTimeTaken.get()));
        }
        localStartTime = startTime.get()[id.ordinal()];
        localStartTime.value = System.nanoTime();
    }

    public static void reportEnd(Id id) {
        if (!runtimeEnabled) {
            return;
        }
        MethodTimer.totalTimeTaken.get()[id.ordinal()].value += System.nanoTime() - MethodTimer.startTime.get()[id.ordinal()].value;
        ++MethodTimer.numberOfTimes.get()[id.ordinal()].value;
    }

    private static MyLong[] createNewMyLongArray() {
        MyLong[] newArray = new MyLong[Id.values().length];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = new MyLong();
        }
        return newArray;
    }

    private static Counter collectValues() {
        Counter[] counters = allCounters.toArray(new Counter[allCounters.size()]);
        Counter collection = new Counter(MethodTimer.createNewMyLongArray(), MethodTimer.createNewMyLongArray(), MethodTimer.createNewMyLongArray());
        for (Counter counter : counters) {
            for (Id id : enabledList) {
                collection.count[id.ordinal()].value += counter.count[id.ordinal()].value;
                collection.totalTime[id.ordinal()].value += counter.totalTime[id.ordinal()].value;
            }
            counter.reset();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printTimes() {
        runtimeEnabled = false;
        try {
            Counter collection = MethodTimer.collectValues();
            for (Id id : enabledList) {
                long numOfTimes = collection.count[id.ordinal()].value;
                long totalTimeTaken = collection.totalTime[id.ordinal()].value;
                logger.info(id.name());
                logger.info("  #times          : " + numOfTimes);
                logger.info("  total time      : " + totalTimeTaken);
                logger.info("  avg time per req: " + (double)totalTimeTaken * 1.0 / (double)numOfTimes);
            }
        }
        finally {
            runtimeEnabled = true;
        }
    }

    public static Counter dumpMethodData() {
        runtimeEnabled = false;
        try {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace(Console.out());
            }
            Counter e = MethodTimer.collectValues();
            return e;
        }
        catch (Exception e) {
            e.printStackTrace(Console.out());
            Counter counter = null;
            return counter;
        }
        finally {
            runtimeEnabled = true;
        }
    }

    static {
        boolean[] values = new boolean[Id.values().length];
        for (int a = 0; a < values.length; ++a) {
            values[a] = MethodTimer.enabledListContains(a);
        }
        enabled = values;
        if (enabled.length > 0) {
            AgentSchedulerManager.getAgentGlobalScheduler().scheduleWithFixedDelay(new MethodTimerDump(), 60L, 60L, AgentTimeUnit.SECONDS);
        }
        startTime = new ThreadLocal();
        numberOfTimes = new ThreadLocal();
        totalTimeTaken = new ThreadLocal();
        allCounters = new Vector();
    }

    public static class MyLong {
        public long value;
    }

    public static class Counter {
        public MyLong[] startTime;
        public MyLong[] count;
        public MyLong[] totalTime;

        public Counter(MyLong[] startTime, MyLong[] count, MyLong[] totalTime) {
            this.startTime = startTime;
            this.count = count;
            this.totalTime = totalTime;
        }

        public void reset() {
            this.resetArray(this.startTime);
            this.resetArray(this.count);
            this.resetArray(this.totalTime);
        }

        private void resetArray(MyLong[] totalTime) {
            for (MyLong myLong : totalTime) {
                myLong.value = 0L;
            }
        }
    }

    static class MethodTimerDump
    implements IAgentRunnable {
        MethodTimerDump() {
        }

        public void run() {
            try {
                MethodTimer.printTimes();
            }
            catch (Throwable e) {
                logger.error("Error printing times", e);
            }
        }
    }

    public static enum Id {
        EUMOnTxBegin,
        EUMReadHeader,
        EUMWatchCheck,
        EUMPageContextInterceptor,
        EUMOnTxEnd,
        TopBackends,
        TopKAlgo,
        Hotspots,
        ATEP_reportMetrics,
        ATEP_endTransaction,
        ATA_acceptAndIdentifyTransaction,
        TR_resolveTransaction;

    }
}

