/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.expression.eval;

import com.singularity.ee.agent.util.expression.eval.ConstantStringEvalSegment;
import com.singularity.ee.agent.util.expression.eval.IEvalSegment;
import com.singularity.ee.agent.util.expression.eval.InvalidExpressionException;
import com.singularity.ee.agent.util.expression.eval.RuntimeExpressionError;
import com.singularity.ee.agent.util.expression.eval.TargetReferenceEvalSegment;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import java.util.ArrayList;

public class ParsedExpression {
    protected static IADLogger logger = ADLoggerFactory.getLogger("com.singularity.ParsedExpression");
    private static final byte SEGMENT_TYPE_CONSTANT_STRING = 1;
    private static final byte SEGMENT_TYPE_TARGET_REFERENCE = 2;
    private IEvalSegment[] segments;
    private static final ParsedExpression INVALID_EXPRESSION = new ParsedExpression(null);
    private static ADConcurrentHashMap<String, ParsedExpression> mapOfParsedExpressions = new ADConcurrentHashMap();
    private String originalExpression;
    private volatile boolean previousRuntimeError;

    private ParsedExpression(IEvalSegment[] segments) {
        this.segments = segments;
    }

    public static ParsedExpression getParsedExpression(String expression) throws InvalidExpressionException {
        ParsedExpression returnObject;
        if (logger.isDebugEnabled()) {
            logger.debug("Received expression: " + expression);
        }
        if ((returnObject = (ParsedExpression)mapOfParsedExpressions.get((Object)expression)) == null) {
            try {
                returnObject = ParsedExpression.parse(expression);
                mapOfParsedExpressions.put((Object)expression, (Object)returnObject);
            }
            catch (InvalidExpressionException e) {
                mapOfParsedExpressions.put((Object)expression, (Object)INVALID_EXPRESSION);
                throw e;
            }
        } else if (returnObject == INVALID_EXPRESSION) {
            throw new InvalidExpressionException(expression, "Error previously found in exception", true);
        }
        return returnObject;
    }

    public static ParsedExpression parse(String expression) throws InvalidExpressionException {
        char[] chars = expression.toCharArray();
        IEvalSegment[] segments = null;
        ArrayList<IEvalSegment> listOfSegments = new ArrayList<IEvalSegment>();
        StringBuilder currentSegmentString = new StringBuilder();
        int index = -1;
        byte currentType = 0;
        while (++index < chars.length) {
            if (chars[index] == '$' && index < chars.length - 2 && chars[index + 1] == '{') {
                if (currentType == 2) {
                    throw new InvalidExpressionException(expression, "Nested \"${}\" expression found");
                }
                if (currentSegmentString.length() > 0 && currentType == 1) {
                    listOfSegments.add(ParsedExpression.createSegment(currentType, currentSegmentString.toString()));
                    currentSegmentString = new StringBuilder();
                }
                currentType = 2;
                ++index;
                continue;
            }
            if (chars[index] == '}') {
                if (currentType != 2) {
                    throw new InvalidExpressionException(expression, "Found \"}\" without prior \"${\"");
                }
                listOfSegments.add(ParsedExpression.createSegment(currentType, currentSegmentString.toString()));
                currentSegmentString = new StringBuilder();
                currentType = 0;
                continue;
            }
            if (currentType == 0) {
                currentType = 1;
            }
            currentSegmentString.append(chars[index]);
        }
        if (currentSegmentString.length() > 0) {
            if (currentType == 1) {
                listOfSegments.add(ParsedExpression.createSegment(currentType, currentSegmentString.toString()));
            } else {
                throw new InvalidExpressionException(expression, "Found \"${\" without following \"}\"");
            }
        }
        segments = CollectionHelper.collectionToArray(listOfSegments, new IEvalSegment[listOfSegments.size()]);
        return new ParsedExpression(segments);
    }

    private static IEvalSegment createSegment(byte segmentType, String segmentText) {
        IEvalSegment returnObject = null;
        switch (segmentType) {
            case 1: {
                returnObject = new ConstantStringEvalSegment(segmentText);
                break;
            }
            case 2: {
                returnObject = new TargetReferenceEvalSegment(segmentText);
            }
        }
        return returnObject;
    }

    public Object evaluate(Object target) throws RuntimeExpressionError {
        Object returnObject = null;
        try {
            for (IEvalSegment nextSegment : this.segments) {
                returnObject = nextSegment.evaluate(target, returnObject);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Return value for expression \"" + this.originalExpression + "\" is " + returnObject.toString());
            }
        }
        catch (RuntimeExpressionError e) {
            e.setRepeatingException(this.previousRuntimeError);
            this.previousRuntimeError = true;
            throw e;
        }
        return returnObject;
    }

    public String toString() {
        return super.toString() + "  expression: " + this.originalExpression;
    }
}

