/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.expression.eval;

import com.singularity.ee.agent.util.expression.eval.IEvalSegment;
import com.singularity.ee.agent.util.expression.eval.RuntimeExpressionError;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.reflect.ReflectionUtility;

class TargetReferenceEvalSegment
implements IEvalSegment {
    protected static IADLogger logger = ADLoggerFactory.getLogger("com.singularity.TargetReferenceEvalSegment");
    private final String originalExpression;

    TargetReferenceEvalSegment(String expression) {
        this.originalExpression = expression;
    }

    @Override
    public Object evaluate(Object target, Object resultOfPreviousSegment) throws RuntimeExpressionError {
        String returnObject = null;
        try {
            String resultString;
            Object resultObject = ReflectionUtility.invokeSimpleGetterRecursiveWithString(target, this.originalExpression);
            String string = resultString = resultObject != null ? resultObject.toString() : "null";
            returnObject = resultOfPreviousSegment != null ? resultOfPreviousSegment.toString() + resultString : resultString;
        }
        catch (Throwable t) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception " + t.toString() + " caught trying to evaluate expression \"" + this.originalExpression + "\"", t);
            }
            return new RuntimeExpressionError(t);
        }
        return returnObject;
    }

    public String toString() {
        return super.toString() + "  expression: " + this.originalExpression;
    }
}

