/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.log4j;

import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ADShadedLogger {
    public static final String GLOBAL_LOGGER_NAME = "ADShaded-global";
    public static final ADShadedLogger global = new ADShadedLogger(ADLoggerFactory.getLogger("ADShaded-global"));
    private final IADLogger baseLogger;
    private ResourceBundle resourceBundle;

    private ADShadedLogger(IADLogger baseLogger) {
        this.baseLogger = baseLogger;
    }

    public static ADShadedLogger getLogger(String name) {
        return new ADShadedLogger(ADLoggerFactory.getLogger(name));
    }

    public void severe(String msg) {
        this.baseLogger.error(msg);
    }

    public void warning(String msg) {
        this.baseLogger.warn(msg);
    }

    public void info(String msg) {
        this.baseLogger.info(msg);
    }

    public void config(String msg) {
        this.baseLogger.info(msg);
    }

    public void fine(String msg) {
        this.baseLogger.debug(msg);
    }

    public void finer(String msg) {
        this.baseLogger.trace(msg);
    }

    public void finest(String msg) {
        this.baseLogger.trace(msg);
    }

    public void log(LogRecord record) {
        Level level = record.getLevel();
        if (level.intValue() >= Level.SEVERE.intValue()) {
            if (this.baseLogger.isErrorEnabled()) {
                this.baseLogger.error(ADShadedLogger.getMessage(record), record.getThrown());
            }
        } else if (level.intValue() >= Level.WARNING.intValue()) {
            if (this.baseLogger.isWarnEnabled()) {
                this.baseLogger.warn(ADShadedLogger.getMessage(record), record.getThrown());
            }
        } else if (level.intValue() >= Level.CONFIG.intValue()) {
            if (this.baseLogger.isInfoEnabled()) {
                this.baseLogger.info(ADShadedLogger.getMessage(record), record.getThrown());
            }
        } else if (level.intValue() >= Level.FINE.intValue()) {
            if (this.baseLogger.isDebugEnabled()) {
                this.baseLogger.debug(ADShadedLogger.getMessage(record), record.getThrown());
            }
        } else if (this.baseLogger.isTraceEnabled()) {
            this.baseLogger.trace(ADShadedLogger.getMessage(record), record.getThrown());
        }
    }

    public void log(Level level, String msg) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            this.baseLogger.error(msg);
        } else if (level.intValue() >= Level.WARNING.intValue()) {
            this.baseLogger.warn(msg);
        } else if (level.intValue() >= Level.CONFIG.intValue()) {
            this.baseLogger.info(msg);
        } else if (level.intValue() >= Level.FINE.intValue()) {
            this.baseLogger.debug(msg);
        } else {
            this.baseLogger.trace(msg);
        }
    }

    public void log(Level level, String msg, Object param1) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            if (this.baseLogger.isErrorEnabled()) {
                this.baseLogger.error(MessageFormat.format(msg, param1));
            }
        } else if (level.intValue() >= Level.WARNING.intValue()) {
            if (this.baseLogger.isWarnEnabled()) {
                this.baseLogger.warn(MessageFormat.format(msg, param1));
            }
        } else if (level.intValue() >= Level.CONFIG.intValue()) {
            if (this.baseLogger.isInfoEnabled()) {
                this.baseLogger.info(MessageFormat.format(msg, param1));
            }
        } else if (level.intValue() >= Level.FINE.intValue()) {
            if (this.baseLogger.isDebugEnabled()) {
                this.baseLogger.debug(MessageFormat.format(msg, param1));
            }
        } else if (this.baseLogger.isTraceEnabled()) {
            this.baseLogger.trace(MessageFormat.format(msg, param1));
        }
    }

    public void log(Level level, String msg, Object[] params) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            if (this.baseLogger.isErrorEnabled()) {
                this.baseLogger.error(MessageFormat.format(msg, params));
            }
        } else if (level.intValue() >= Level.WARNING.intValue()) {
            if (this.baseLogger.isWarnEnabled()) {
                this.baseLogger.warn(MessageFormat.format(msg, params));
            }
        } else if (level.intValue() >= Level.CONFIG.intValue()) {
            if (this.baseLogger.isInfoEnabled()) {
                this.baseLogger.info(MessageFormat.format(msg, params));
            }
        } else if (level.intValue() >= Level.FINE.intValue()) {
            if (this.baseLogger.isDebugEnabled()) {
                this.baseLogger.debug(MessageFormat.format(msg, params));
            }
        } else if (this.baseLogger.isTraceEnabled()) {
            this.baseLogger.trace(MessageFormat.format(msg, params));
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            this.baseLogger.error(msg, thrown);
        } else if (level.intValue() >= Level.WARNING.intValue()) {
            this.baseLogger.warn(msg, thrown);
        } else if (level.intValue() >= Level.CONFIG.intValue()) {
            this.baseLogger.info(msg, thrown);
        } else if (level.intValue() >= Level.FINE.intValue()) {
            this.baseLogger.debug(msg, thrown);
        } else {
            this.baseLogger.trace(msg, thrown);
        }
    }

    public boolean isLoggable(Level level) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            return this.baseLogger.isErrorEnabled();
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return this.baseLogger.isWarnEnabled();
        }
        if (level.intValue() >= Level.CONFIG.intValue()) {
            return this.baseLogger.isInfoEnabled();
        }
        if (level.intValue() >= Level.FINE.intValue()) {
            return this.baseLogger.isDebugEnabled();
        }
        return this.baseLogger.isTraceEnabled();
    }

    public Level getLevel() {
        if (this.baseLogger.isErrorEnabled()) {
            return Level.SEVERE;
        }
        if (this.baseLogger.isWarnEnabled()) {
            return Level.WARNING;
        }
        if (this.baseLogger.isInfoEnabled()) {
            return Level.CONFIG;
        }
        if (this.baseLogger.isDebugEnabled()) {
            return Level.FINE;
        }
        if (this.baseLogger.isTraceEnabled()) {
            return Level.FINEST;
        }
        return Level.OFF;
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        this.log(level, msg);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.log(level, msg, param1);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.log(level, msg, params);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        this.log(level, msg);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        this.log(level, msg, param1);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        this.log(level, msg, params);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, ResourceBundle bundle, String msg, Object ... params) {
        this.log(level, msg, params);
    }

    public void logrb(Level level, ResourceBundle bundle, String msg, Object ... params) {
        this.log(level, msg, params);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, ResourceBundle bundle, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void logrb(Level level, ResourceBundle bundle, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void entering(String sourceClass, String sourceMethod) {
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
    }

    public void exiting(String sourceClass, String sourceMethod) {
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getResourceBundleName() {
        return null;
    }

    public ADShadedLogger getParent() {
        return ADShadedLogger.getLogger("");
    }

    public void setParent(ADShadedLogger parent) {
    }

    public void setLevel(Level newLevel) {
    }

    public Handler[] getHandlers() {
        return new Handler[0];
    }

    public void addHandler(Handler handler) {
    }

    public static ADShadedLogger getAnonymousLogger() {
        return ADShadedLogger.getLogger("");
    }

    public static ADShadedLogger getAnonymousLogger(String resourceBundleName) {
        return ADShadedLogger.getLogger("");
    }

    public static ADShadedLogger getGlobal() {
        return global;
    }

    private static String getMessage(LogRecord record) {
        String msg = record.getMessage();
        Object[] params = record.getParameters();
        if (params == null) {
            return msg;
        }
        return MessageFormat.format(msg, params);
    }
}

