/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.log4j;

import com.singularity.ee.agent.appagent.kernel.boot.IJavaAgentBootExtension;
import com.singularity.ee.agent.appagent.kernel.boot.JavaAgentBootExtension;
import com.singularity.ee.agent.appagent.kernel.spi.IBootServiceProvider;
import com.singularity.ee.agent.appagent.services.agentdiagnostics.spi.ErrorHandlerFactory;
import com.singularity.ee.agent.appagent.services.agentdiagnostics.spi.IAgentErrorHandler;
import com.singularity.ee.agent.util.log4j.ADLevel;
import com.singularity.ee.agent.util.log4j.ADLoggerWrapper;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.log4j.IAgentLogger;

public class AgentLoggerWrapper
extends ADLoggerWrapper
implements IAgentLogger {
    private IAgentErrorHandler errorHandler;
    private static final IJavaAgentBootExtension javaAgentBootExtension = JavaAgentBootExtension.getInstance();

    public AgentLoggerWrapper(IADLogger baseLogger) {
        super(baseLogger);
        try {
            this.errorHandler = ErrorHandlerFactory.createAgentErrorHandler(this);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (this.errorHandler == null) {
            this.errorHandler = new FakeErrorHandler();
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (this.errorHandler.safeIsHandleErrorAlreadyCalled()) {
            this.log(ADLevel.ERROR, message, t);
        } else {
            this.errorHandler.safeHandleError(message, t, ADLevel.ERROR);
        }
        this.sendIfLogListenersPresent("error", message, t);
    }

    @Override
    public void error(String message, Throwable t) {
        this.error((Object)message, t);
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (this.errorHandler.safeIsHandleErrorAlreadyCalled()) {
            super.warn(message, t);
        } else {
            this.errorHandler.safeHandleError(message, t, ADLevel.WARN);
        }
        this.sendIfLogListenersPresent("warn", message, t);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.warn((Object)message, t);
    }

    @Override
    public void debug(String msg) {
        this.baseLogger.debug(msg);
        this.sendIfLogListenersPresent("debug", msg, null);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.baseLogger.debug(msg, t);
        this.sendIfLogListenersPresent("debug", msg, t);
    }

    @Override
    public void fatal(String msg) {
        this.baseLogger.fatal(msg);
        this.sendIfLogListenersPresent("fatal", msg, null);
    }

    @Override
    public void fatal(String msg, Throwable t) {
        this.baseLogger.fatal(msg, t);
        this.sendIfLogListenersPresent("fatal", msg, t);
    }

    @Override
    public void info(String msg) {
        this.baseLogger.info(msg);
        this.sendIfLogListenersPresent("info", msg, null);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.baseLogger.info(msg, t);
        this.sendIfLogListenersPresent("info", msg, t);
    }

    @Override
    public void error(String msg) {
        this.baseLogger.error(msg);
        this.sendIfLogListenersPresent("error", msg, null);
    }

    @Override
    public void warn(String msg) {
        this.baseLogger.warn(msg);
        this.sendIfLogListenersPresent("warn", msg, null);
    }

    private void sendIfLogListenersPresent(String type, Object message, Throwable t) {
        IBootServiceProvider bootServiceProvider;
        if (javaAgentBootExtension != null && (bootServiceProvider = javaAgentBootExtension.getBootServiceProvider()) != null && bootServiceProvider.agentDebugEventSenderHasLogListeners()) {
            bootServiceProvider.getDebugEventSender().sendLogEvent(type, message, t);
        }
    }

    private static class FakeErrorHandler
    implements IAgentErrorHandler {
        FakeErrorHandler() {
        }

        @Override
        public void safeHandleError(Object message, Throwable t, ADLevel level) {
        }

        @Override
        public boolean safeIsHandleErrorAlreadyCalled() {
            return false;
        }
    }
}

