/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.log4j;

import com.singularity.ee.agent.util.log4j.ADLevel;
import com.singularity.ee.agent.util.log4j.ADLevelUtil;
import com.singularity.ee.agent.util.log4j.IADLogger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Log4J2Logger
implements IADLogger {
    private Logger wrappedLogger;
    private LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
    private LoggerConfig loggerConfig;

    public Log4J2Logger(Logger wrappedLogger) {
        this.loggerConfig = this.ctx.getConfiguration().getLoggerConfig(wrappedLogger.getName());
        this.wrappedLogger = wrappedLogger;
    }

    @Override
    public void debug(Object o) {
        this.wrappedLogger.debug(o);
    }

    @Override
    public void debug(Object o, Throwable throwable) {
        this.wrappedLogger.debug(o, throwable);
    }

    @Override
    public void debugParams(String msg, Object ... objects) {
        this.wrappedLogger.debug(msg, objects);
    }

    public void debug(String s) {
        this.wrappedLogger.debug(s);
    }

    public void debug(String s, Throwable throwable) {
        this.wrappedLogger.debug(s, throwable);
    }

    @Override
    public void error(Object o) {
        this.wrappedLogger.error(o);
    }

    @Override
    public void error(Object o, Throwable throwable) {
        this.wrappedLogger.error(o, throwable);
    }

    public void error(String s) {
        this.wrappedLogger.error(s);
    }

    public void error(String s, Throwable throwable) {
        this.wrappedLogger.error(s, throwable);
    }

    @Override
    public void fatal(Object o) {
        this.wrappedLogger.fatal(o);
    }

    @Override
    public void fatal(Object o, Throwable throwable) {
        this.wrappedLogger.fatal(o, throwable);
    }

    @Override
    public void log(ADLevel level, Object m) {
        this.wrappedLogger.log(ADLevelUtil.toLog4J2Level(level), m);
    }

    @Override
    public void log(ADLevel level, Object m, Throwable t) {
        this.wrappedLogger.log(ADLevelUtil.toLog4J2Level(level), m, t);
    }

    public void fatal(String s) {
        this.wrappedLogger.fatal(s);
    }

    public void fatal(String s, Throwable throwable) {
        this.wrappedLogger.fatal(s, throwable);
    }

    @Override
    public ADLevel getLevel() {
        return ADLevelUtil.toADLevel(this.wrappedLogger.getLevel());
    }

    @Override
    public void setAdditivity(boolean additivity) {
        this.loggerConfig.setAdditive(false);
        this.ctx.updateLoggers();
    }

    @Override
    public void info(Object o) {
        this.wrappedLogger.info(o);
    }

    @Override
    public void info(Object o, Throwable throwable) {
        this.wrappedLogger.info(o, throwable);
    }

    public void info(String s) {
        this.wrappedLogger.info(s);
    }

    public void info(String s, Throwable throwable) {
        this.wrappedLogger.info(s, throwable);
    }

    public boolean isDebugEnabled() {
        return this.wrappedLogger.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.wrappedLogger.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.wrappedLogger.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.wrappedLogger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.wrappedLogger.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.wrappedLogger.isWarnEnabled();
    }

    @Override
    public void addAppender(Object appender) {
    }

    public void addAppender(Appender appender) {
        this.loggerConfig.addAppender(appender, Level.ALL, null);
        this.ctx.updateLoggers();
    }

    @Override
    public void removeAppender(Object appender) {
    }

    public void removeAppender(Appender appender) {
        this.loggerConfig.removeAppender(appender.getName());
        this.ctx.updateLoggers();
    }

    @Override
    public void removeAllAppenders() {
    }

    @Override
    public void setLevel(ADLevel level) {
        if (!this.loggerConfig.getName().equals(this.wrappedLogger.getName())) {
            this.loggerConfig = new LoggerConfig(this.wrappedLogger.getName(), ADLevelUtil.toLog4J2Level(level), true);
            this.ctx.getConfiguration().addLogger(this.wrappedLogger.getName(), this.loggerConfig);
        }
        this.loggerConfig.setLevel(ADLevelUtil.toLog4J2Level(level));
        this.ctx.updateLoggers();
    }

    @Override
    public String getName() {
        return this.wrappedLogger.getName();
    }

    @Override
    public void trace(Object o) {
        this.wrappedLogger.trace(o);
    }

    @Override
    public void trace(Object o, Throwable throwable) {
        this.wrappedLogger.trace(o, throwable);
    }

    public void trace(String s) {
        this.wrappedLogger.trace(s);
    }

    public void trace(String s, Throwable throwable) {
        this.wrappedLogger.trace(s, throwable);
    }

    @Override
    public void traceParams(String s, Object ... objects) {
        this.wrappedLogger.trace(s, objects);
    }

    @Override
    public void warn(Object o) {
        this.wrappedLogger.warn(o);
    }

    @Override
    public void warn(Object o, Throwable throwable) {
        this.wrappedLogger.warn(o, throwable);
    }

    public void warn(String s) {
        this.wrappedLogger.warn(s);
    }

    public void warn(String s, Throwable throwable) {
        this.wrappedLogger.warn(s, throwable);
    }

    public Logger getBaseLogger() {
        return this.wrappedLogger;
    }
}

