/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.log4j;

import com.singularity.ee.agent.util.log4j.ADLevel;
import com.singularity.ee.agent.util.log4j.ADLevelUtil;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.log4j.ParameterFormatter;
import com.singularity.util.org.apache.log4j.Appender;
import com.singularity.util.org.apache.log4j.Level;
import com.singularity.util.org.apache.log4j.Logger;
import com.singularity.util.org.apache.log4j.Priority;
import com.singularity.util.org.apache.log4j.spi.LoggingEvent;

public class Log4JLogger
implements IADLogger {
    Logger baseLogger;

    public Log4JLogger(Logger baseLogger) {
        this.baseLogger = baseLogger;
    }

    public void debug(String msg) {
        this.baseLogger.debug((Object)msg);
    }

    public void debug(String msg, Throwable t) {
        this.baseLogger.debug((Object)msg, t);
    }

    public void error(String msg) {
        this.baseLogger.error((Object)msg);
    }

    public void error(String msg, Throwable t) {
        this.baseLogger.error((Object)msg, t);
    }

    public void fatal(String msg) {
        this.baseLogger.fatal((Object)msg);
    }

    public void fatal(String msg, Throwable t) {
        this.baseLogger.fatal((Object)msg, t);
    }

    public void info(String msg) {
        this.baseLogger.info((Object)msg);
    }

    public void info(String msg, Throwable t) {
        this.baseLogger.info((Object)msg, t);
    }

    public void trace(String msg) {
        this.baseLogger.trace((Object)msg);
    }

    public void trace(String msg, Throwable t) {
        this.baseLogger.trace((Object)msg, t);
    }

    public void warn(String msg) {
        this.baseLogger.warn((Object)msg);
    }

    public void warn(String msg, Throwable t) {
        this.baseLogger.warn((Object)msg, t);
    }

    public boolean isDebugEnabled() {
        return this.baseLogger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.baseLogger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.baseLogger.isTraceEnabled();
    }

    public void log(LoggingEvent loggingEvent) {
        this.baseLogger.callAppenders(loggingEvent);
    }

    @Override
    public String getName() {
        return this.baseLogger.getName();
    }

    @Override
    public void trace(Object o) {
        this.baseLogger.warn(o);
    }

    @Override
    public void trace(Object o, Throwable t) {
        this.baseLogger.trace(o, t);
    }

    @Override
    public void traceParams(String msg, Object ... objects) {
        if (this.isTraceEnabled()) {
            this.baseLogger.trace((Object)ParameterFormatter.format(msg, objects));
        }
    }

    @Override
    public void debug(Object o) {
        this.baseLogger.debug(o);
    }

    @Override
    public void debug(Object o, Throwable t) {
        this.baseLogger.debug(o, t);
    }

    @Override
    public void debugParams(String msg, Object ... objects) {
        if (this.isDebugEnabled()) {
            this.baseLogger.debug((Object)ParameterFormatter.format(msg, objects));
        }
    }

    @Override
    public void info(Object o) {
        this.baseLogger.info(o);
    }

    @Override
    public void info(Object o, Throwable t) {
        this.baseLogger.info(o, t);
    }

    @Override
    public void warn(Object o) {
        this.baseLogger.warn(o);
    }

    @Override
    public void warn(Object o, Throwable t) {
        this.baseLogger.warn(o, t);
    }

    @Override
    public void error(Object o) {
        this.baseLogger.error(o);
    }

    @Override
    public void error(Object o, Throwable t) {
        this.baseLogger.error(o, t);
    }

    @Override
    public void fatal(Object o) {
        this.baseLogger.fatal(o);
    }

    @Override
    public void fatal(Object o, Throwable t) {
        this.baseLogger.fatal(o, t);
    }

    @Override
    public void log(ADLevel level, Object m) {
        switch (level) {
            case OFF: {
                return;
            }
            case ALL: {
                this.baseLogger.fatal(m);
                break;
            }
            case TRACE: {
                this.baseLogger.trace(m);
                break;
            }
            case FATAL: {
                this.baseLogger.fatal(m);
                break;
            }
            case ERROR: {
                this.baseLogger.error(m);
                break;
            }
            case DEBUG: {
                this.baseLogger.debug(m);
                break;
            }
            case WARN: {
                this.baseLogger.warn(m);
                break;
            }
            case INFO: {
                this.baseLogger.info(m);
            }
        }
    }

    @Override
    public void log(ADLevel level, Object m, Throwable t) {
        switch (level) {
            case OFF: {
                return;
            }
            case ALL: {
                this.baseLogger.fatal(m, t);
                break;
            }
            case TRACE: {
                this.baseLogger.trace(m, t);
                break;
            }
            case FATAL: {
                this.baseLogger.fatal(m, t);
                break;
            }
            case ERROR: {
                this.baseLogger.error(m, t);
                break;
            }
            case DEBUG: {
                this.baseLogger.debug(m, t);
                break;
            }
            case WARN: {
                this.baseLogger.warn(m, t);
                break;
            }
            case INFO: {
                this.baseLogger.info(m, t);
            }
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.baseLogger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.baseLogger.isEnabledFor((Priority)Level.FATAL);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.baseLogger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public void addAppender(Object appender) {
        this.baseLogger.addAppender((Appender)appender);
    }

    @Override
    public void removeAppender(Object appender) {
        this.baseLogger.removeAppender((Appender)appender);
    }

    @Override
    public void removeAllAppenders() {
        this.baseLogger.removeAllAppenders();
    }

    @Override
    public void setLevel(ADLevel level) {
        this.baseLogger.setLevel(ADLevelUtil.toLog4JLevel(level));
    }

    @Override
    public ADLevel getLevel() {
        Level level = this.baseLogger.getEffectiveLevel();
        return ADLevelUtil.toADLevel1(level);
    }

    @Override
    public void setAdditivity(boolean additivity) {
        this.baseLogger.setAdditivity(additivity);
    }
}

