/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.pool;

import com.singularity.ee.agent.util.pool.IObjectPool;
import com.singularity.ee.agent.util.pool.IPooledObject;
import com.singularity.ee.agent.util.reflect.AgentReflectionUtility;
import com.singularity.ee.agent.util.reflect.ReflectionUtility;
import com.singularity.ee.util.logging.ILogger;

public class AlwaysNewObjectPool
implements IObjectPool {
    private ILogger logger;

    public AlwaysNewObjectPool(ILogger logger) {
        this.logger = logger;
    }

    @Override
    public IPooledObject getPooledObject(Class<IPooledObject> type) {
        IPooledObject pooledObject;
        try {
            pooledObject = ReflectionUtility.newInstance(type);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Created pooledObject [" + AgentReflectionUtility.getClassName(type) + "]");
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to instantiate pooledObject " + type, (Throwable)e);
            throw new IllegalStateException("Failed to create pooledObject object for [" + type + "]");
        }
        pooledObject.acquire();
        return pooledObject;
    }

    @Override
    public void releasePooledObject(IPooledObject payload) {
        if (payload != null) {
            payload.release();
        }
    }
}

