/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.pool;

import com.singularity.ee.agent.util.pool.IObjectPool;
import com.singularity.ee.agent.util.pool.IPooledObject;
import com.singularity.ee.agent.util.reflect.ReflectionUtility;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.logging.ILogger;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;

public class SimpleObjectPool
implements IObjectPool {
    private ILogger logger;
    private Map<Class<IPooledObject>, ArrayList<IPooledObject>> thePool = new IdentityHashMap<Class<IPooledObject>, ArrayList<IPooledObject>>(20);

    public SimpleObjectPool(ILogger logger) {
        this.logger = logger;
    }

    @Override
    public IPooledObject getPooledObject(Class<IPooledObject> type) {
        int size;
        IPooledObject pooledObject = null;
        ArrayList<IPooledObject> payloadList = this.thePool.get(type);
        if (payloadList == null) {
            payloadList = new ArrayList();
            this.thePool.put(type, payloadList);
        }
        if ((size = payloadList.size()) == 0) {
            try {
                pooledObject = ReflectionUtility.newInstance(type);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Created pooledObject [" + ReflectionUtility.getClassName(type) + "]");
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to instantiate pooledObject " + type, (Throwable)e);
            }
        } else {
            pooledObject = CollectionHelper.removeAt(payloadList, size - 1);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Returning pooled pooledObject [" + ReflectionUtility.getClassName(pooledObject) + "]");
            }
        }
        if (pooledObject == null) {
            throw new IllegalStateException("Failed to create pooledObject object for [" + type + "]");
        }
        pooledObject.acquire();
        return pooledObject;
    }

    @Override
    public void releasePooledObject(IPooledObject payload) {
        if (payload != null && payload.isInUse()) {
            ArrayList<IPooledObject> pooledObjects = this.thePool.get(payload.getClass());
            if (pooledObjects == null) {
                pooledObjects = new ArrayList();
                Class<?> clazz = payload.getClass();
                this.thePool.put(clazz, pooledObjects);
            }
            pooledObjects.add(payload);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Releasing object [" + ReflectionUtility.getClassName(payload) + "]");
            }
            payload.release();
        }
    }

    public Map<Class<IPooledObject>, ArrayList<IPooledObject>> getThePool() {
        return this.thePool;
    }
}

