/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.reflect;

import com.singularity.ee.agent.appagent.kernel.boot.Java9ModuleStaticDelegate;
import com.singularity.ee.agent.util.bounded.collections.BoundedConcurrentReferenceHashMapBuilder;
import com.singularity.ee.agent.util.io.Console;
import com.singularity.ee.agent.util.reflect.ReflectionException;
import com.singularity.ee.agent.util.reflect.Types;
import com.singularity.ee.util.collections.AdaptableConcurrentHashMap;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.logging.SysOutLogger;
import com.singularity.ee.util.reflect.MethodCacheEntry;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class AgentReflectionUtility
extends Types {
    protected static volatile ILogger logger = new SysOutLogger("com.singularity.ReflectionUtility", Console.out());
    protected static Method noSuchMethod = null;
    protected static Field noSuchField = null;
    private static int dummyField = 0;
    public static final int REFLECTION_CACHE_UPPER_LIMIT = 2000;
    public static final String REFLECTION_CACHE_LIMIT_PROPERTY = "reflection-cache-limit";
    protected static ReflectionException cachedNoSuchFieldException;
    protected static ReflectionException cachedNoSuchMethodException;
    protected static final AdaptableConcurrentHashMap<Class<?>, List<WeakReference<Annotation>>> mapOfDeclaredClassAnnotations;
    protected static final AdaptableConcurrentHashMap<Class<?>, List<WeakReference<Annotation>>> mapOfClassAnnotations;
    protected static AdaptableConcurrentHashMap<Class, String[]> clazzToAllInterfaces;
    protected static ConcurrentMap<Class, ConcurrentMap<String, Field>> fieldCache;
    protected static ConcurrentMap<Class, ConcurrentMap<MethodCacheEntry, Method>> methodCache;

    private static void dummyMethod() {
    }

    public static String getName(Class aClass) {
        return aClass.getName();
    }

    public static String getClassName(Class<?> aClass) {
        return aClass.getName();
    }

    public static ClassLoader getClassLoader(Object obj) {
        return obj.getClass().getClassLoader();
    }

    public static Object getFieldFromSpecifiedClassWithoutReporting(Class cls, String fieldName, boolean scanSuperClass) throws ReflectionException {
        try {
            return AgentReflectionUtility.getDeclaredField(cls, fieldName, scanSuperClass);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException("Field [" + fieldName + "] of class [" + cls.getName() + "] does not exist in class hierarchy", (Throwable)e);
        }
    }

    public static Field getDeclaredField(Class cls, String fieldName, boolean scanSuperClass) throws NoSuchFieldException {
        Field field = null;
        if (scanSuperClass) {
            while (cls != null) {
                try {
                    AgentReflectionUtility.getJava9Permission(cls);
                    field = cls.getDeclaredField(fieldName);
                    if (field != null) {
                        break;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                cls = cls.getSuperclass();
            }
            if (field == null) {
                throw new NoSuchFieldException();
            }
            AgentReflectionUtility.getJava9Permission(field.getDeclaringClass());
            field.setAccessible(true);
            return field;
        }
        field = cls.getDeclaredField(fieldName);
        AgentReflectionUtility.getJava9Permission(cls);
        field.setAccessible(true);
        return field;
    }

    protected static List<Annotation> getDeclaredAnnotationsForClass(Class cls) {
        return AgentReflectionUtility.getAnnotationsForClass(cls, AnnotationType.DECLARED_ANNOTATIONS, mapOfDeclaredClassAnnotations);
    }

    protected static List<Annotation> getAnnotationsForClass(Class cls, AnnotationType annotationType, Map<Class<?>, List<WeakReference<Annotation>>> mapOfClassAnnotations) {
        List<Annotation> returnList;
        List<WeakReference<WeakReference<Annotation>>> weakRefToAnnotationsList = mapOfClassAnnotations.get(cls);
        if (weakRefToAnnotationsList == null) {
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = annotationType == AnnotationType.ALL_ANNOTATIONS ? cls.getAnnotations() : cls.getDeclaredAnnotations();
            if (annotations.length > 0) {
                returnList = Arrays.asList(annotations);
                weakRefToAnnotationsList = new LinkedList();
                for (Annotation nextAnnotation : annotations) {
                    weakRefToAnnotationsList.add(new WeakReference<Annotation>(nextAnnotation));
                }
                mapOfClassAnnotations.put(cls, weakRefToAnnotationsList);
            } else {
                returnList = Collections.EMPTY_LIST;
                mapOfClassAnnotations.put(cls, Collections.EMPTY_LIST);
            }
        } else {
            returnList = weakRefToAnnotationsList.size() > 0 ? AgentReflectionUtility.convertToStrongReferenceList(weakRefToAnnotationsList) : Collections.EMPTY_LIST;
        }
        return returnList;
    }

    private static <E> List<E> convertToStrongReferenceList(List<WeakReference<E>> weakReferenceList) {
        LinkedList returnList = new LinkedList();
        for (WeakReference<E> refToObject : weakReferenceList) {
            Object obj = refToObject.get();
            if (obj == null) continue;
            returnList.add(obj);
        }
        return returnList;
    }

    public static boolean hasDirectAnnotation(Class cls, StringMatchBoot annotationNameData) {
        List<Annotation> annos = AgentReflectionUtility.getDirectAnnotations(cls);
        for (Annotation annotation : annos) {
            if (!annotationNameData.matchString(annotation.annotationType().getName())) continue;
            return true;
        }
        return false;
    }

    protected static List<Annotation> getDirectAnnotations(Class cls) {
        List<Annotation> annotations = AgentReflectionUtility.getDeclaredAnnotationsForClass(cls);
        return annotations;
    }

    public static boolean hasAnnotation(Class cls, StringMatchBoot annotationCls) {
        if (AgentReflectionUtility.isObjectClass(cls)) {
            return false;
        }
        List<Annotation> annotations = AgentReflectionUtility.getAllAnnotationsForClass(cls);
        for (Annotation annotation : annotations) {
            if (!annotationCls.matchString(annotation.annotationType().getName())) continue;
            return true;
        }
        return AgentReflectionUtility.hasAnnotation(cls.getSuperclass(), annotationCls);
    }

    protected static boolean isObjectClass(Class clazz) {
        return clazz == Object.class;
    }

    static List<Annotation> getAllAnnotationsForClass(Class cls) {
        return AgentReflectionUtility.getAnnotationsForClass(cls, AnnotationType.ALL_ANNOTATIONS, mapOfClassAnnotations);
    }

    public static boolean extendsFromClass(Class cls, StringMatchBoot superClassMatchData) {
        if (cls.getName().equals("java.lang.Object")) {
            return false;
        }
        Class superClass = cls.getSuperclass();
        if (superClass == null) {
            return false;
        }
        if (superClassMatchData.matchString(superClass.getName())) {
            return true;
        }
        return AgentReflectionUtility.extendsFromClass(cls.getSuperclass(), superClassMatchData);
    }

    public static boolean implementsInterface(Class cls, StringMatchBoot matchIntfData) {
        String[] strings = AgentReflectionUtility.getInterfacesForClass(cls);
        for (int i = 0; i < strings.length; ++i) {
            if (!matchIntfData.matchString(strings[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean implementsInterface(Class cls, String matchIntf) {
        String[] interfacesForClass = AgentReflectionUtility.getInterfacesForClass(cls);
        for (int i = 0; i < interfacesForClass.length; ++i) {
            if (!interfacesForClass[i].equals(matchIntf)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsOrIsAssignableFrom(Class cls, String className) {
        if (cls.getName().equals(className)) {
            return true;
        }
        if (AgentReflectionUtility.implementsInterface(cls, className)) {
            return true;
        }
        return AgentReflectionUtility.extendsFromClass(cls, className);
    }

    public static String[] getInterfacesForClass(Class clazz) {
        String[] strings = (String[])clazzToAllInterfaces.get((Object)clazz);
        if (strings == null) {
            LinkedHashSet<String> intfNames = new LinkedHashSet<String>();
            if (clazz.isInterface()) {
                AgentReflectionUtility.getInterfacesThatExtendsThisInterface(clazz, intfNames);
            } else {
                AgentReflectionUtility.getInterfacesImplementedByThisClass(clazz, intfNames);
            }
            strings = intfNames.toArray(new String[intfNames.size()]);
            clazzToAllInterfaces.put((Object)clazz, (Object)strings);
        }
        return strings;
    }

    protected static void getInterfacesThatExtendsThisInterface(Class intfClass, LinkedHashSet<String> intfClasseNames) {
        Class<?>[] intfs = intfClass.getInterfaces();
        for (int j = 0; j < intfs.length; ++j) {
            Class<?> myIntf = intfs[j];
            intfClasseNames.add(myIntf.getName());
            AgentReflectionUtility.getInterfacesThatExtendsThisInterface(myIntf, intfClasseNames);
        }
    }

    private static void getInterfacesImplementedByThisClass(Class clazz, LinkedHashSet<String> intfClasseNames) {
        Class cls = clazz;
        while (cls.getSuperclass() != null) {
            Class<?>[] interfaces = cls.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                intfClasseNames.add(interfaces[i].getName());
                AgentReflectionUtility.getInterfacesThatExtendsThisInterface(interfaces[i], intfClasseNames);
            }
            cls = cls.getSuperclass();
        }
    }

    public static boolean isAssignableFrom(Class targetClass, Class srcClass) {
        return targetClass.isAssignableFrom(srcClass);
    }

    public static Object getFieldWithoutReporting(Object object, String fieldName, boolean scanSuperClass) throws ReflectionException {
        return AgentReflectionUtility.getFieldFromSpecifiedClassWithoutReporting(object.getClass(), object, fieldName, scanSuperClass);
    }

    public static Object getFieldFromSpecifiedClassWithoutReporting(Class cls, Object object, String fieldName, boolean scanSuperClass) throws ReflectionException {
        Field field;
        ConcurrentMap fieldMap = (ConcurrentMap)fieldCache.get(cls);
        if (fieldMap == null) {
            fieldCache.putIfAbsent(cls, (ConcurrentMap<String, Field>)new BoundedConcurrentReferenceHashMapBuilder().withUpperLimit(2000).withPolicy(BoundsPolicy.SILENT_FAIL_BOUND_EXCEEDED).withServiceName("TransactionMonitoringService").withPropertyName(REFLECTION_CACHE_LIMIT_PROPERTY).build());
            fieldMap = (ConcurrentMap)fieldCache.get(cls);
        }
        if ((field = (Field)fieldMap.get(fieldName)) == noSuchField) {
            if (logger.isTraceEnabled()) {
                logger.trace("Field [" + fieldName + "] of class [" + cls.getName() + "] does not exist in class hierarchy");
            }
            throw cachedNoSuchFieldException;
        }
        try {
            Field fieldFromMap;
            if (field == null && (fieldFromMap = fieldMap.putIfAbsent(fieldName, field = AgentReflectionUtility.getDeclaredField(cls, fieldName, scanSuperClass))) != null) {
                field = fieldFromMap;
            }
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            if (scanSuperClass) {
                fieldMap.putIfAbsent(fieldName, noSuchField);
                throw new ReflectionException("Field [" + fieldName + "] of class [" + cls.getName() + "] does not exist in class hierarchy", (Throwable)e);
            }
            fieldMap.putIfAbsent(fieldName, noSuchField);
            throw new ReflectionException("Field [" + fieldName + "] of class [" + cls.getName() + "] does not exist", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            fieldMap.putIfAbsent(fieldName, noSuchField);
            throw new ReflectionException("Error accessing field [" + fieldName + "] of class [" + cls.getName() + "]", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String classLoaderMessage = "";
            if (field != null && object != null) {
                classLoaderMessage = "Field CL " + field.getDeclaringClass().getClassLoader() + ", object  CL " + object.getClass().getClassLoader();
            }
            fieldMap.putIfAbsent(fieldName, noSuchField);
            throw new ReflectionException("Error  accessing field [" + fieldName + "] of class [" + cls.getName() + "] " + classLoaderMessage, (Throwable)e);
        }
    }

    public static Object invokeSimpleGetterWithoutReporting(Object object, String methodName) throws ReflectionException {
        return AgentReflectionUtility.invokeMethod(object, methodName, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public static Object invokeMethod(Object object, String methodName, Class[] paramCls, Object[] params) throws ReflectionException {
        if (object == null) {
            throw new ReflectionException("Reflection target cannot be null");
        }
        return AgentReflectionUtility.invokeMethodOnSpecifiedClass(object.getClass(), object, methodName, paramCls, params);
    }

    private static Object invokeMethodOnSpecifiedClass(Class cls, Object object, String methodName, Class[] paramCls, Object[] params) throws ReflectionException {
        return AgentReflectionUtility.doInvokeMethodOnSpecifiedClass(cls, object, methodName, paramCls, params, true);
    }

    private static Object doInvokeMethodOnSpecifiedClass(Class cls, Object object, String methodName, Class[] paramCls, Object[] params, boolean publicAccess) throws ReflectionException {
        if (object == null) {
            throw new ReflectionException("Object cannot be null");
        }
        try {
            Method method = null;
            Map methodCacheSet = (Map)methodCache.get(cls);
            if (methodCacheSet == null) {
                methodCache.putIfAbsent(cls, (ConcurrentMap<MethodCacheEntry, Method>)new BoundedConcurrentReferenceHashMapBuilder().withUpperLimit(2000).withPolicy(BoundsPolicy.SILENT_FAIL_BOUND_EXCEEDED).withServiceName("TransactionMonitoringService").withPropertyName(REFLECTION_CACHE_LIMIT_PROPERTY).build());
                methodCacheSet = (Map)methodCache.get(cls);
            }
            if ((method = (Method)methodCacheSet.get(new MethodCacheEntry(methodName, AgentReflectionUtility.convertParams(paramCls)))) == noSuchMethod) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Method [" + methodName + "] of class [" + cls.getName() + "] with param length " + paramCls.length + " does not exist.");
                }
                throw cachedNoSuchMethodException;
            }
            if (method == null) {
                try {
                    AgentReflectionUtility.getJava9Permission(cls);
                    if (publicAccess) {
                        try {
                            method = cls.getMethod(methodName, paramCls);
                        }
                        catch (NoSuchMethodException ex) {
                            try {
                                method = cls.getDeclaredMethod(methodName, paramCls);
                            }
                            catch (NoSuchMethodException m) {
                                methodCacheSet.put(new MethodCacheEntry(methodName, AgentReflectionUtility.convertParams(paramCls)), noSuchMethod);
                                throw new ReflectionException("Method [" + methodName + "] of class [" + cls.getName() + "] with param length " + paramCls.length + " does not exist.", (Throwable)m);
                            }
                        }
                    } else {
                        method = cls.getDeclaredMethod(methodName, paramCls);
                    }
                    method.setAccessible(true);
                    methodCacheSet.put(new MethodCacheEntry(methodName, AgentReflectionUtility.convertParams(paramCls)), method);
                }
                catch (NoSuchMethodException e) {
                    methodCacheSet.put(new MethodCacheEntry(methodName, AgentReflectionUtility.convertParams(paramCls)), noSuchMethod);
                    throw new ReflectionException("Method [" + methodName + "] of class [" + cls.getName() + "] with param length " + paramCls.length + " does not exist.", (Throwable)e);
                }
                catch (Throwable t) {
                    methodCacheSet.put(new MethodCacheEntry(methodName, AgentReflectionUtility.convertParams(paramCls)), noSuchMethod);
                    if (t instanceof ReflectionException) {
                        throw (ReflectionException)t;
                    }
                    throw new ReflectionException("Error accessing method [" + methodName + "] of class [" + cls.getName() + "]", t);
                }
            }
            try {
                return method.invoke(object, params);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionException("Error invoking Method [" + methodName + "] of class [" + cls.getName() + "] ", e.getTargetException());
            }
            catch (IllegalAccessException e) {
                methodCacheSet.put(new MethodCacheEntry(methodName, AgentReflectionUtility.convertParams(paramCls)), noSuchMethod);
                throw new ReflectionException("Error accessing method [" + methodName + "] of class [" + cls.getName() + "]", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                String classLoaderMessage = "";
                if (method != null && object != null) {
                    classLoaderMessage = "Field CL " + method.getDeclaringClass().getClassLoader() + ", object  CL " + object.getClass().getClassLoader();
                }
                methodCacheSet.put(new MethodCacheEntry(methodName, AgentReflectionUtility.convertParams(paramCls)), noSuchMethod);
                throw new ReflectionException("Error  accessing field [" + methodName + "] of class [" + cls.getName() + "] " + classLoaderMessage, (Throwable)e);
            }
        }
        catch (Throwable e) {
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            throw new ReflectionException("Error invoking Method [" + methodName + "] of class [" + cls.getName() + "] ", e);
        }
    }

    protected static List<String> convertParams(Class[] params) {
        if (params.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> paramArray = new ArrayList<String>(params.length);
        for (Class param : params) {
            paramArray.add(param.getName());
        }
        return paramArray;
    }

    public static boolean extendsFromClass(Class cls, String superClassName) {
        if (cls.getName().equals("java.lang.Object")) {
            return false;
        }
        Class superClass = cls.getSuperclass();
        if (superClass.getName().equals(superClassName)) {
            return true;
        }
        return AgentReflectionUtility.extendsFromClass(cls.getSuperclass(), superClassName);
    }

    public static boolean hasNoArgConstructor(Class clazz) {
        for (Constructor<?> c : clazz.getConstructors()) {
            if (c.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(String targetClassName, Object srcObject) throws ClassNotFoundException {
        Class<?> targetClass = Class.forName(targetClassName, true, srcObject.getClass().getClassLoader());
        return targetClass.isAssignableFrom(srcObject.getClass());
    }

    protected static void getJava9Permission(Class<?> clazz) {
        Java9ModuleStaticDelegate.getJava9Permission(clazz);
    }

    static {
        try {
            AgentReflectionUtility.dummyMethod();
            noSuchMethod = AgentReflectionUtility.class.getDeclaredMethod("dummyMethod", new Class[0]);
            noSuchField = AgentReflectionUtility.class.getDeclaredField("dummyField");
            if (noSuchField == null || noSuchMethod == null) {
                throw new IllegalStateException("static variables could not be initialized");
            }
        }
        catch (Exception e) {
            logger.debug("Cannot initialize AgentReflectionUtility", (Throwable)e);
            throw new IllegalStateException(e);
        }
        cachedNoSuchFieldException = new ReflectionException("cached - no such field", true);
        cachedNoSuchMethodException = new ReflectionException("cached - no such method", true);
        mapOfDeclaredClassAnnotations = new AdaptableConcurrentHashMap(AdaptableConcurrentHashMap.ReferenceType.WEAK, AdaptableConcurrentHashMap.ReferenceType.STRONG);
        mapOfClassAnnotations = new AdaptableConcurrentHashMap(AdaptableConcurrentHashMap.ReferenceType.WEAK, AdaptableConcurrentHashMap.ReferenceType.STRONG);
        clazzToAllInterfaces = new AdaptableConcurrentHashMap();
        fieldCache = new AdaptableConcurrentHashMap(AdaptableConcurrentHashMap.Option.IDENTITY_COMPARISONS);
        methodCache = new AdaptableConcurrentHashMap(AdaptableConcurrentHashMap.Option.IDENTITY_COMPARISONS);
    }

    public static enum AnnotationType {
        ALL_ANNOTATIONS,
        DECLARED_ANNOTATIONS;

    }
}

