/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.reflect;

import com.singularity.ee.agent.util.classloader.BootStrapClassLoaderProxy;
import com.singularity.ee.agent.util.log4j.IADLogger;

public class ClassLoaderUtil {
    public static Class loadClass(Class cls, String name) throws ClassNotFoundException {
        ClassLoader classLoader = cls.getClassLoader();
        if (classLoader != null) {
            return classLoader.loadClass(name);
        }
        Class clazz = BootStrapClassLoaderProxy.getInstance().findBootstrapClassWithReflection(name);
        if (clazz == null) {
            throw new ClassNotFoundException("Unable to load class " + name + " from Bootstrap ClassLoader");
        }
        return clazz;
    }

    public static boolean isBootstrapLoaded(Object object) {
        return object.getClass().getClassLoader() == null;
    }

    public static boolean isBootstrapLoaded(Class<?> clazz) {
        return clazz.getClassLoader() == null;
    }

    public static String getHierarchMessage(ClassLoader classLoader, IADLogger logger) {
        ClassLoader nextClassLoader;
        StringBuilder sb = new StringBuilder("\n");
        StringBuilder margin = new StringBuilder();
        ClassLoader currentClassLoader = classLoader;
        do {
            sb.append(currentClassLoader.toString());
            nextClassLoader = currentClassLoader.getParent();
            if (nextClassLoader == null) continue;
            sb.append(" delegates to:\n");
            margin.append("  ");
        } while ((currentClassLoader = nextClassLoader) != null);
        return sb.toString();
    }
}

