/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.reflect;

import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.reflect.AgentReflectionUtility;
import com.singularity.ee.agent.util.reflect.IClassList;
import com.singularity.ee.agent.util.reflect.ReflectionUtility;
import com.singularity.ee.util.logging.ILogger;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DeepDiveObjectFinder {
    private static ILogger logger = ADLoggerFactory.getLogger("com.singularity.tm.jdbc.DeepDiveObjectFinder");

    public void setLogger(ILogger logger) {
        DeepDiveObjectFinder.logger = logger;
    }

    public Object getObjectFromFieldLocation(Object input, List<Field> fields) throws IllegalAccessException {
        if (fields == null) {
            return null;
        }
        for (int inx = 0; inx < fields.size(); ++inx) {
            Field fld = fields.get(inx);
            Object targetObject = fld.get(input);
            if (inx == fields.size() - 1) {
                return targetObject;
            }
            input = targetObject;
        }
        return null;
    }

    public Object findUnderlyingObject(Object rootObject, int maxDepthToScan, Class toScanFor, IClassList classList, Map<Class, List<Field>> locationMap) throws IllegalAccessException {
        if (maxDepthToScan < 1) {
            if (logger.isDebugEnabled()) {
                logger.debug(" Max depth to scan for is set to [" + maxDepthToScan + " , i.e. < 1, returning null");
            }
            return null;
        }
        LinkedList<Field> fields = new LinkedList<Field>();
        Object underlyingObject = this._findUnderlyingObjectRecursive(rootObject, maxDepthToScan, 1, toScanFor, classList, fields);
        if (underlyingObject != null && locationMap != null) {
            locationMap.put(rootObject.getClass(), fields);
            if (logger.isDebugEnabled()) {
                this.printLocation(rootObject.getClass());
            }
        }
        return underlyingObject;
    }

    private void printLocation(Class clazz) {
        try {
            String location = ReflectionUtility.getCodeSource(clazz);
            logger.debug("[" + clazz + "] loaded from " + location);
        }
        catch (Exception e) {
            logger.error("Error in finding location of class [" + clazz + "] ", (Throwable)e);
        }
    }

    private Object _findUnderlyingObjectRecursive(Object targetObject, int maxDepthToScan, int currentLevel, Class toScanFor, IClassList classList, LinkedList<Field> fields) throws IllegalAccessException {
        Class<?> targetClass = targetObject.getClass();
        List<Field> declaredFields = ReflectionUtility.getDeclaredFields(targetClass, true);
        Object underlyingObject = this.scanForUnderlyingObjectAtCurrentLevel(targetObject, declaredFields, currentLevel, toScanFor, classList, fields);
        if (underlyingObject == null) {
            if (currentLevel == maxDepthToScan) {
                return null;
            }
            for (Field declaredField : declaredFields) {
                Object nextLevelObject;
                if (this.checkIfTobeFiltered(declaredField.getType()) || (nextLevelObject = declaredField.get(targetObject)) == null || (underlyingObject = this._findUnderlyingObjectRecursive(nextLevelObject, maxDepthToScan, currentLevel + 1, toScanFor, classList, fields)) == null) continue;
                fields.addFirst(declaredField);
                if (logger.isDebugEnabled()) {
                    logger.debug("For [" + nextLevelObject.getClass() + "] @level[" + currentLevel + "] added Field [" + declaredField + "] ");
                }
                if (currentLevel != 1) continue;
                break;
            }
        }
        return underlyingObject;
    }

    private Object scanForUnderlyingObjectAtCurrentLevel(Object targetObject, List<Field> declaredFields, int currentLevel, Class toScanFor, IClassList classList, LinkedList<Field> fields) throws IllegalAccessException {
        if (logger.isTraceEnabled()) {
            logger.trace("\n Level [" + currentLevel + "], Target[" + targetObject.getClass() + "]\n Fields[" + declaredFields + "]");
        }
        for (Field declaredField : declaredFields) {
            Object potentialConnection;
            Class<?> fieldType = declaredField.getType();
            if (this.checkIfTobeFiltered(fieldType)) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("Matching " + fieldType + " if instance of Connection");
            }
            if ((potentialConnection = declaredField.get(targetObject)) != null && ReflectionUtility.isAssignableFrom(toScanFor, potentialConnection)) {
                if (classList.isContained(potentialConnection.getClass())) {
                    fields.add(declaredField);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Found [" + potentialConnection.getClass() + "]  for Class[" + targetObject.getClass() + "], ** @Level [" + currentLevel + "], @[" + targetObject.getClass() + "] @Field[" + declaredField + "] **");
                    }
                    return potentialConnection;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("[" + fieldType + "] not of type Driver Connection");
                continue;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("Object is null or not of type connection");
        }
        return null;
    }

    private boolean checkIfTobeFiltered(Class<?> fieldType) {
        return fieldType.isPrimitive() || fieldType.getComponentType() != null || AgentReflectionUtility.isAssignableFrom(Logger.class, fieldType) || AgentReflectionUtility.isAssignableFrom(Map.class, fieldType) || AgentReflectionUtility.isAssignableFrom(Collection.class, fieldType);
    }
}

