/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.reflect;

import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.controller.api.dto.transientoperations.ObjectRepresentation;
import com.singularity.ee.controller.api.dto.transientoperations.TreeNameValuePair;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PrintObjectUtility {
    private static IADLogger logger = ADLoggerFactory.getLogger(PrintObjectUtility.class);
    public static final String TO_STRING_PLACE_HOLDER = "#toString";
    public static final String TO_STRING_NOT_CAPTURED = "toString not captured";
    public static final int MAX_OBJECT_COUNT = 200;
    public static final int MAX_ARRAY_STRING_LENGTH = 200;

    public static boolean isFieldStringOrPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.equals(String.class);
    }

    public static String arrayToString(Object obj) {
        if (obj == null || !obj.getClass().isArray()) {
            return null;
        }
        String returnValue = obj instanceof byte[] ? Arrays.toString((byte[])obj) : (obj instanceof int[] ? Arrays.toString((int[])obj) : (obj instanceof float[] ? Arrays.toString((float[])obj) : (obj instanceof short[] ? Arrays.toString((short[])obj) : (obj instanceof long[] ? Arrays.toString((long[])obj) : (obj instanceof boolean[] ? Arrays.toString((boolean[])obj) : (obj instanceof double[] ? Arrays.toString((double[])obj) : (obj instanceof char[] ? Arrays.toString((char[])obj) : Arrays.toString((Object[])obj))))))));
        return returnValue;
    }

    public static TreeNameValuePair convertMapOfMapsToNameValuePair(Map<String, Object> allFields) {
        TreeNameValuePair node = new TreeNameValuePair();
        if (allFields == null) {
            node.setValue(String.valueOf(allFields));
            return node;
        }
        ArrayList<TreeNameValuePair> children = new ArrayList<TreeNameValuePair>();
        for (Map.Entry<String, Object> entry : allFields.entrySet()) {
            Object fieldValue = entry.getValue();
            if (fieldValue instanceof String || fieldValue == null) {
                if (entry.getKey().equals(TO_STRING_PLACE_HOLDER)) {
                    node.setValue(String.valueOf(entry.getValue()));
                    continue;
                }
                TreeNameValuePair nvp = new TreeNameValuePair();
                nvp.setName(entry.getKey());
                nvp.setValue((String)fieldValue);
                children.add(nvp);
                continue;
            }
            Map innerMap = (Map)fieldValue;
            TreeNameValuePair nestedObject = PrintObjectUtility.convertMapOfMapsToNameValuePair(innerMap);
            nestedObject.setName(entry.getKey());
            children.add(nestedObject);
        }
        node.setChildren(children.toArray(new TreeNameValuePair[children.size()]));
        return node;
    }

    public static ObjectRepresentation convertMapOfMapsToObjectRepresentation(Map<String, Object> allFields) {
        if (allFields == null) {
            return null;
        }
        ObjectRepresentation objectRepresentation = new ObjectRepresentation();
        Set<Map.Entry<String, Object>> entries = allFields.entrySet();
        ArrayList<String> primitiveFieldName = new ArrayList<String>();
        ArrayList<String> primitiveValues = new ArrayList<String>();
        ArrayList<String> complexFieldName = new ArrayList<String>();
        ArrayList<ObjectRepresentation> complexValues = new ArrayList<ObjectRepresentation>();
        for (Map.Entry<String, Object> entry : entries) {
            Object fieldValue = entry.getValue();
            if (fieldValue instanceof String) {
                if (entry.getKey().equals(TO_STRING_PLACE_HOLDER)) {
                    objectRepresentation.setToString((String)fieldValue);
                    continue;
                }
                primitiveFieldName.add(entry.getKey());
                primitiveValues.add((String)fieldValue);
                continue;
            }
            if (fieldValue == null) {
                complexFieldName.add(entry.getKey());
                complexValues.add(null);
                continue;
            }
            Map innerMap = (Map)fieldValue;
            ObjectRepresentation nestedObject = PrintObjectUtility.convertMapOfMapsToObjectRepresentation(innerMap);
            complexFieldName.add(entry.getKey());
            complexValues.add(nestedObject);
        }
        objectRepresentation.setPrimitiveFieldNames(primitiveFieldName.toArray(new String[primitiveFieldName.size()]));
        objectRepresentation.setPrimitives(primitiveValues.toArray(new String[primitiveValues.size()]));
        objectRepresentation.setComplexObjectsFieldNames(complexFieldName.toArray(new String[complexFieldName.size()]));
        objectRepresentation.setComplexObjects(complexValues.toArray(new ObjectRepresentation[complexValues.size()]));
        return objectRepresentation;
    }

    public static Map<String, Object> getAllFields(Object obj, int depth) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        PrintObjectUtility.getAllFieldsHelper(obj, depth, returnMap, 0);
        return returnMap;
    }

    private static int getAllFieldsHelper(Object obj, int depth, Map<String, Object> map, int parentSize) {
        block11: {
            String fieldToString = null;
            try {
                fieldToString = String.valueOf(obj);
                map.put(TO_STRING_PLACE_HOLDER, fieldToString);
            }
            catch (Exception ex) {
                map.put(TO_STRING_PLACE_HOLDER, TO_STRING_NOT_CAPTURED);
                if (!logger.isDebugEnabled()) break block11;
                logger.debug("Error capturing toString on " + obj.getClass().getName());
            }
        }
        int nestedObjectCount = 0;
        if (depth <= 0) {
            return nestedObjectCount;
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> tmpClass = obj.getClass(); tmpClass != null && !tmpClass.getName().startsWith("java"); tmpClass = tmpClass.getSuperclass()) {
            fields.addAll(Arrays.asList(tmpClass.getDeclaredFields()));
        }
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (parentSize + map.size() + nestedObjectCount > 200) break;
            try {
                field.setAccessible(true);
                Object fieldValue = field.get(obj);
                if (field.getType().isArray()) {
                    String arrayToString = PrintObjectUtility.arrayToString(fieldValue);
                    if (arrayToString != null && arrayToString.length() >= 200) {
                        arrayToString = arrayToString.substring(0, 200) + "...]";
                    }
                    map.put(field.getName(), arrayToString);
                    continue;
                }
                if (PrintObjectUtility.isFieldStringOrPrimitive(field.getType())) {
                    map.put(field.getName(), String.valueOf(fieldValue));
                    continue;
                }
                if (fieldValue == null) {
                    map.put(field.getName(), null);
                    continue;
                }
                HashMap<String, Object> nestedObject = new HashMap<String, Object>();
                nestedObjectCount += PrintObjectUtility.getAllFieldsHelper(fieldValue, depth - 1, nestedObject, parentSize + map.size() + nestedObjectCount);
                map.put(field.getName(), nestedObject);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Exception capturing field " + field.getName() + " on " + obj.getClass(), e);
            }
        }
        return nestedObjectCount + map.size();
    }
}

