/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.reflect;

import com.singularity.ee.agent.appagent.kernel.boot.IJavaAgentBootExtension;
import com.singularity.ee.agent.appagent.kernel.boot.JavaAgentBootExtension;
import com.singularity.ee.agent.appagent.kernel.config.acnp.NodeProperty;
import com.singularity.ee.agent.appagent.kernel.config.acnp.NodePropertyListener;
import com.singularity.ee.agent.appagent.services.transactionmonitor.error.common.spi.AgentInternalError;
import com.singularity.ee.agent.util.JavaVersionUtil;
import com.singularity.ee.agent.util.bounded.collections.BoundedConcurrentReferenceHashMapBuilder;
import com.singularity.ee.agent.util.io.Console;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.reflect.AgentReflectionUtility;
import com.singularity.ee.agent.util.reflect.ReflectionException;
import com.singularity.ee.agent.util.reflect.Types;
import com.singularity.ee.util.collections.AdaptableConcurrentHashMap;
import com.singularity.ee.util.collections.ArrayStack;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;
import com.singularity.ee.util.dtobootimpl.StringMatchBootType;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.logging.SysOutLogger;
import com.singularity.ee.util.reflect.DataGathererErrorCheck;
import com.singularity.ee.util.reflect.MethodCacheEntry;
import com.singularity.ee.util.string.StringOperations;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class ReflectionUtility
extends AgentReflectionUtility {
    private static final IJavaAgentBootExtension javaAgentBootExtension = JavaAgentBootExtension.getInstance();
    private static String USE_SAFE_GETTER_CHAINS = "appdynamics.agent.safeGetterChains";
    private static boolean useSafeGetterChains = StringOperations.safeParseBoolean((String)System.getProperty(USE_SAFE_GETTER_CHAINS), (boolean)true);
    private static final Set<String> BLACK_LISTED_GETTER_CHAIN_METHOD_CALLS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("getClassLoader", "loadClass", "invoke")));
    private static final Set<String> BLACK_LISTED_GETTER_CHAIN_CLASSES_AND_PACKAGES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.lang.reflect", "java.nio.file", "java.lang.ClassLoader", "java.io.File", "java.io.Socket", "java.net.Socket", "java.lang.ProcessBuilder", "java.lang.Runtime")));
    private static volatile boolean enableReportingDetail = false;
    private static volatile boolean reportAgentInternalError = true;
    private static volatile boolean shouldGetModifierUsingNativeMethod = false;
    private static String GET_DECLARED_FIELDS0 = "getDeclaredFields0";
    private static String GET_DECLARED_FIELDS_IMPL = "getDeclaredFieldsImpl";
    private static volatile String getAllFieldsNativeMethod = GET_DECLARED_FIELDS0;
    private static final int MAX_ARG_TYPES_TO_SEARCH = 10;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static AdaptableConcurrentHashMap<Class, AdaptableConcurrentHashMap<String, Object>> getterCache = new AdaptableConcurrentHashMap();
    private static AdaptableConcurrentHashMap<String, Class[]> paramCache = new AdaptableConcurrentHashMap();
    private static AdaptableConcurrentHashMap<String, Object[]> valuesCache = new AdaptableConcurrentHashMap();
    private static AdaptableConcurrentHashMap<String, String[]> chainCache = new BoundedConcurrentReferenceHashMapBuilder().withUpperLimit(2000).withPolicy(BoundsPolicy.SILENT_FAIL_BOUND_EXCEEDED).withServiceName("TransactionMonitoringService").withPropertyName("reflection-cache-limit").build();
    private static AdaptableConcurrentHashMap<Class, String[]> clazzToDeclaredInterfaces = new AdaptableConcurrentHashMap();
    private static AdaptableConcurrentHashMap<Class, String[]> clazzToDirectAnnotations = new AdaptableConcurrentHashMap();
    private static volatile ILogger logger = new SysOutLogger("com.singularity.ReflectionUtility", Console.out());
    private static AdaptableConcurrentHashMap<Method, Annotation[]> methodAnnotationCache = new AdaptableConcurrentHashMap(AdaptableConcurrentHashMap.ReferenceType.WEAK, AdaptableConcurrentHashMap.ReferenceType.WEAK);
    private static AdaptableConcurrentHashMap<Class<? extends Annotation>, Method[]> annotationMethodCache = new AdaptableConcurrentHashMap(AdaptableConcurrentHashMap.ReferenceType.WEAK, AdaptableConcurrentHashMap.ReferenceType.WEAK);
    private static Map<Class, Field[]> classToFieldMapping = new AdaptableConcurrentHashMap(32, AdaptableConcurrentHashMap.ReferenceType.WEAK, AdaptableConcurrentHashMap.ReferenceType.WEAK);
    private static AdaptableConcurrentHashMap<Method, AdaptableConcurrentHashMap<String, Object>> methodAnnotationValueCache = new AdaptableConcurrentHashMap();
    private static AdaptableConcurrentHashMap<Class, AdaptableConcurrentHashMap<String, Object>> classAnnotationValueCache = new AdaptableConcurrentHashMap();
    private static final Object NULL_OBJECT_PLACEHOLDER = new Object();
    private static final AdaptableConcurrentHashMap<Class<?>, String> mapOfSimpleClassNames = new AdaptableConcurrentHashMap();
    private static final int MAX_SIMPLE_CLASS_NAMES_TO_CACHE = 1000;
    private static final Object NO_METHOD = new Object();
    private static final char DOT_SEPARATOR = '.';
    private static String ESCAPED_DOT_SEPARATOR = "\\.";

    public static void initializeLogger() {
        logger = ADLoggerFactory.getLogger("com.singularity.ReflectionUtility");
    }

    public static void flushCaches() {
        methodCache.clear();
        fieldCache.clear();
        getterCache.clear();
        paramCache.clear();
        valuesCache.clear();
        mapOfClassAnnotations.clear();
        mapOfDeclaredClassAnnotations.clear();
    }

    static void setUseSafeGetterChains(boolean b) {
        useSafeGetterChains = b;
    }

    public static String getClassName(Object obj) {
        return ReflectionUtility.getClassName(obj.getClass());
    }

    public static String getClassSimpleName(Class<?> clazz) {
        String simpleName = (String)mapOfSimpleClassNames.get(clazz);
        if (simpleName != null) {
            return simpleName;
        }
        if (clazz.isArray()) {
            return ReflectionUtility.getClassSimpleName(clazz.getComponentType()) + "[]";
        }
        try {
            simpleName = clazz.getSimpleName();
            if (mapOfSimpleClassNames.fastApproximateSize() >= 1000) {
                mapOfSimpleClassNames.clear();
            }
            mapOfSimpleClassNames.putIfAbsent(clazz, (Object)simpleName);
            return simpleName;
        }
        catch (InternalError e) {
            Class<?> enclosingClass;
            if (logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Internal error occurred while fetching simple class name for " + clazz.getName() + ".");
                sb.append(" Will use alternate method to construct class simple name");
                logger.debug(sb.toString(), (Throwable)e);
            }
            if ((enclosingClass = clazz.getEnclosingClass()) == null) {
                return clazz.getName();
            }
            String simpleBinaryName = clazz.getName().substring(enclosingClass.getName().length());
            return ReflectionUtility.getSimpleNameFromSimpleBinaryName(simpleBinaryName);
        }
    }

    protected static String getSimpleNameFromSimpleBinaryName(String simpleBinaryName) {
        int index;
        int length = simpleBinaryName.length();
        if (length < 1 || simpleBinaryName.charAt(0) != '$') {
            int indexOfLastClassSeparator = simpleBinaryName.lastIndexOf(36);
            if (indexOfLastClassSeparator == -1) {
                return simpleBinaryName;
            }
            return simpleBinaryName.substring(indexOfLastClassSeparator + 1);
        }
        for (index = 1; index < length && Character.isDigit(simpleBinaryName.charAt(index)); ++index) {
        }
        return simpleBinaryName.substring(index);
    }

    public static String getCodeSource(Class clazz) {
        return clazz.getProtectionDomain().getCodeSource().getLocation().toString();
    }

    public static boolean declaresInterface(Class cls, String matchIntf) {
        String[] interfaceNames = ReflectionUtility.getDeclaredInterfaceNames(cls);
        for (int i = 0; i < interfaceNames.length; ++i) {
            if (!matchIntf.equals(interfaceNames[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean declaresInterfaceRecursively(Class cls, String matchIntf) {
        for (Class clz = cls; clz != null; clz = clz.getSuperclass()) {
            String[] interfaceNames = ReflectionUtility.getDeclaredInterfaceNames(clz);
            for (int i = 0; i < interfaceNames.length; ++i) {
                if (!matchIntf.equals(interfaceNames[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean declaresInterfaceRecursively(Class cls, StringMatchBoot matchIntfData) {
        for (Class clz = cls; clz != null; clz = clz.getSuperclass()) {
            String[] interfaceNames = ReflectionUtility.getDeclaredInterfaceNames(clz);
            for (int i = 0; i < interfaceNames.length; ++i) {
                if (!matchIntfData.matchString(interfaceNames[i])) continue;
                return true;
            }
        }
        return false;
    }

    private static String[] getDeclaredInterfaceNames(Class cls) {
        String[] interfaceNames = (String[])clazzToDeclaredInterfaces.get((Object)cls);
        if (interfaceNames == null) {
            Class<?>[] intfs = cls.getInterfaces();
            interfaceNames = new String[intfs.length];
            int intfsLength = intfs.length;
            for (int i = 0; i < intfsLength; ++i) {
                interfaceNames[i] = intfs[i].getName();
            }
            clazzToDeclaredInterfaces.put((Object)cls, (Object)interfaceNames);
        }
        return interfaceNames;
    }

    public static boolean declaresInterface(Class cls, StringMatchBoot matchIntfData) {
        String[] interfaceNames = ReflectionUtility.getDeclaredInterfaceNames(cls);
        for (int i = 0; i < interfaceNames.length; ++i) {
            if (!matchIntfData.matchString(interfaceNames[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean implementsInterface(Class cls, Class matchIntf) {
        return matchIntf.isAssignableFrom(cls);
    }

    public static boolean declaresSuperClass(Class cls, String superClassName) {
        return cls.getSuperclass().getName().equals(superClassName);
    }

    public static boolean declaresSuperClass(Class cls, StringMatchBoot superClassNameData) {
        return superClassNameData.matchString(cls.getSuperclass().getName());
    }

    public static boolean declaresSuperClassRecursively(Class cls, StringMatchBoot superClassNameData) {
        for (Class clz = cls; clz != null; clz = clz.getSuperclass()) {
            if (!superClassNameData.matchString(clz.getSuperclass().getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean extendsFromClass(Class cls, Class superClass) {
        return superClass.isAssignableFrom(cls);
    }

    public static boolean hasDirectAnnotation(Class cls, String annotationName) {
        List<Annotation> annos = ReflectionUtility.getDirectAnnotations(cls);
        for (Annotation annotation : annos) {
            if (!annotation.annotationType().getName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDirectAnnotationRecursively(Class cls, String annotationName) {
        for (Class clz = cls; clz != null; clz = clz.getSuperclass()) {
            List<Annotation> annos = ReflectionUtility.getDirectAnnotations(clz);
            for (Annotation annotation : annos) {
                if (!annotation.annotationType().getName().equals(annotationName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasDirectAnnotationRecursively(Class cls, StringMatchBoot annotationName) {
        try {
            for (Class clz = cls; clz != null; clz = clz.getSuperclass()) {
                Annotation[] annotations = ReflectionUtility.getAnnotationsFor(clz);
                for (int i = 0; i < annotations.length; ++i) {
                    Class[] interfaceClasses;
                    Class<? extends Annotation> annotationType = annotations[i].annotationType();
                    String annotationTypeName = annotationType.getName();
                    if (!annotationTypeName.equals("javax.ejb.Local") && !annotationTypeName.equals("javax.ejb.Remote") || (interfaceClasses = (Class[])ReflectionUtility.invokeMethod(annotations[i], "value")) == null) continue;
                    for (Class interfaceClass : interfaceClasses) {
                        String businessInterfaceName = interfaceClass.getName();
                        if (!annotationName.matchString(businessInterfaceName)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error trying to load annotations", (Throwable)e);
        }
        return false;
    }

    public static boolean hasAnnotation(Class cls, Class annotationCls) {
        if (null == cls) {
            return false;
        }
        if (ReflectionUtility.isObjectClass(cls)) {
            return false;
        }
        List<Annotation> annotations = ReflectionUtility.getAllAnnotationsForClass(cls);
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().getName().equals(annotationCls.getName())) continue;
            return true;
        }
        return ReflectionUtility.hasAnnotation(cls.getSuperclass(), annotationCls);
    }

    public static boolean hasAnnotation(Class cls, String annotationCls) {
        return ReflectionUtility.hasAnnotation(cls, new StringMatchBoot(StringMatchBootType.EQUALS, annotationCls));
    }

    public static Object getAnnotationElement(Class objectCls, String annotationName, String elementName) throws ReflectionException {
        Annotation[] annotations;
        for (Annotation annotation : annotations = ReflectionUtility.getAnnotationsFor(objectCls)) {
            Method[] annotationMethods = ReflectionUtility.getMethodsForAnnotationClass(annotation.annotationType());
            if (!annotation.annotationType().getName().equals(annotationName)) continue;
            for (Method method : annotationMethods) {
                if (!method.getName().equals(elementName)) continue;
                try {
                    ReflectionUtility.getJava9Permission(method.getDeclaringClass());
                    method.setAccessible(true);
                    return method.invoke((Object)annotation, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionException("Error finding annotation [" + annotationName + "] of class [" + objectCls.getName() + "]", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new ReflectionException("Error finding annotation [" + annotationName + "] of class [" + objectCls.getName() + "] ", e.getTargetException());
                }
            }
        }
        return null;
    }

    public static Object getAnnotationElement(Method methodCarryingAnnotation, String annotationName, String elementName) throws ReflectionException {
        Annotation[] annotations;
        for (Annotation annotation : annotations = ReflectionUtility.getAnnotationsFor(methodCarryingAnnotation)) {
            Method[] annotationMethods = ReflectionUtility.getMethodsForAnnotationClass(annotation.annotationType());
            if (!annotation.annotationType().getName().equals(annotationName)) continue;
            for (Method method : annotationMethods) {
                if (!method.getName().equals(elementName)) continue;
                try {
                    ReflectionUtility.getJava9Permission(method.getDeclaringClass());
                    method.setAccessible(true);
                    return method.invoke((Object)annotation, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionException("Error finding annotation [" + annotationName + "] of class [" + methodCarryingAnnotation.getName() + "]", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new ReflectionException("Error finding annotation [" + annotationName + "] of class [" + methodCarryingAnnotation.getClass().getName() + "] ", e.getTargetException());
                }
            }
        }
        return null;
    }

    public static Object getAnnotationElement(Object objCarryingAnnotation, Set<String> possibleAnnotationNames, String elementName) throws ReflectionException {
        Annotation[] annotations;
        for (Annotation annotation : annotations = ReflectionUtility.getAnnotationsFor(objCarryingAnnotation.getClass())) {
            Method[] annotationMethods = ReflectionUtility.getMethodsForAnnotationClass(annotation.annotationType());
            if (!possibleAnnotationNames.contains(annotation.annotationType().getName())) continue;
            for (Method method : annotationMethods) {
                if (!method.getName().equals(elementName)) continue;
                try {
                    ReflectionUtility.getJava9Permission(method.getDeclaringClass());
                    method.setAccessible(true);
                    return method.invoke((Object)annotation, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionException("Error finding annotation names[" + possibleAnnotationNames + "] of class [" + objCarryingAnnotation.getClass().getName() + "]", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new ReflectionException("Error finding annotation names [" + possibleAnnotationNames + "] of class [" + objCarryingAnnotation.getClass().getName() + "] ", e.getTargetException());
                }
            }
        }
        return null;
    }

    public static Object getAnnotationElementRecursively(Class objCarryingAnnotationCls, Set<String> possibleAnnotationNames, String elementName) throws ReflectionException {
        Object annotation = null;
        for (Class cls = objCarryingAnnotationCls; cls != null && annotation == null; cls = cls.getSuperclass()) {
            annotation = ReflectionUtility.getAnnotationElementRecursivelyInternal(cls, possibleAnnotationNames, elementName);
        }
        return annotation;
    }

    private static Object getAnnotationElementRecursivelyInternal(Class cls, Set<String> possibleAnnotationNames, String elementName) throws ReflectionException {
        Annotation[] annotations;
        for (Annotation annotation : annotations = ReflectionUtility.getAnnotationsFor(cls)) {
            Method[] annotationMethods = ReflectionUtility.getMethodsForAnnotationClass(annotation.annotationType());
            if (!possibleAnnotationNames.contains(annotation.annotationType().getName())) continue;
            for (Method method : annotationMethods) {
                if (!method.getName().equals(elementName)) continue;
                try {
                    ReflectionUtility.getJava9Permission(method.getDeclaringClass());
                    method.setAccessible(true);
                    return method.invoke((Object)annotation, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionException("Error finding annotation names[" + possibleAnnotationNames + "] of class [" + cls.getName() + "]", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new ReflectionException("Error finding annotation names [" + possibleAnnotationNames + "] of class [" + cls.getName() + "] ", e.getTargetException());
                }
            }
        }
        return null;
    }

    public static Object getStaticField(String className, ClassLoader loader, String fieldName) throws ReflectionException {
        try {
            Class<?> aClass = Class.forName(className, true, loader);
            return ReflectionUtility.getFieldFromSpecifiedClass(aClass, null, fieldName, true);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException("Class Loading error while trying to get static field value for class [" + className + "] field [" + fieldName + "]", (Throwable)e);
        }
    }

    public static Object invokeStaticMethod(String className, ClassLoader loader, String methodName, Class[] parameterTypes, Object ... args) throws ReflectionException {
        try {
            Class<?> aClass = Class.forName(className, true, loader);
            Method method = ReflectionUtility.getMethodFromClass(aClass, methodName, parameterTypes);
            if (method != null) {
                return method.invoke(null, args);
            }
            throw new ReflectionException("No method named [" + methodName + "] in class[" + className + "]");
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException("Class Loading error while trying to invoke static method for class [" + className + "] method [" + methodName + "]", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException("Error invoking Method [" + methodName + "] of class [" + className + "] ", e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException("Error accessing method [" + methodName + "] of class [" + className + "]", (Throwable)e);
        }
    }

    public static void setField(Object object, String fieldName, Object value, boolean scanSuperClass) throws ReflectionException {
        if (object == null) {
            throw new ReflectionException("setField called with on field [" + fieldName + "] with null object");
        }
        try {
            ReflectionUtility.getJava9Permission(object.getClass());
            Field field = ReflectionUtility.getDeclaredField(object.getClass(), fieldName, scanSuperClass);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException("Field [" + fieldName + "] of class [" + object.getClass().getName() + "] does not exist", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException("Error accessing field [" + fieldName + "] of class [" + object.getClass().getName() + "]", (Throwable)e);
        }
    }

    public static void setFinalField(Object object, String fieldName, Object value, boolean scanSuperClass) throws ReflectionException {
        if (object == null) {
            throw new ReflectionException("setField called with on field [" + fieldName + "] with null objectClass");
        }
        ReflectionUtility.setFinalField(object.getClass(), object, fieldName, value, scanSuperClass);
    }

    public static void setFinalField(Class objectClass, Object object, String fieldName, Object value, boolean scanSuperClass) throws ReflectionException {
        if (objectClass == null) {
            throw new ReflectionException("setField called with on field [" + fieldName + "] with null object");
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("Trying to set final field [" + fieldName + "] of class [" + objectClass.getName() + "].");
            }
            ReflectionUtility.getJava9Permission(objectClass);
            Field field = ReflectionUtility.getDeclaredField(objectClass, fieldName, scanSuperClass);
            field.setAccessible(true);
            ReflectionUtility.getJava9Permission(Field.class);
            Field modifiersField = ReflectionUtility.getModifier();
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(object, value);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException("Field [" + fieldName + "] of class [" + objectClass.getName() + "] does not exist", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException("Error accessing field [" + fieldName + "] of class [" + objectClass.getName() + "]", (Throwable)e);
        }
    }

    private static Field getModifier() throws NoSuchFieldException, ReflectionException {
        if (!shouldGetModifierUsingNativeMethod) {
            try {
                return Field.class.getDeclaredField("modifiers");
            }
            catch (NoSuchFieldException e) {
                if (JavaVersionUtil.isJava12orHigher()) {
                    return ReflectionUtility.getModifiersFieldUsingNativeMethod();
                }
                throw e;
            }
        }
        return ReflectionUtility.getModifiersFieldUsingNativeMethod();
    }

    private static Field getModifiersFieldUsingNativeMethod() throws ReflectionException {
        Field[] allFields;
        block3: {
            allFields = null;
            try {
                allFields = ReflectionUtility.getDeclaredFieldsUsingNativeMethod();
            }
            catch (ReflectionException e) {
                if (GET_DECLARED_FIELDS_IMPL.equals(getAllFieldsNativeMethod)) break block3;
                logger.info("Changing native method to getDeclaredFieldsImpl");
                getAllFieldsNativeMethod = GET_DECLARED_FIELDS_IMPL;
                allFields = ReflectionUtility.getDeclaredFieldsUsingNativeMethod();
            }
        }
        if (allFields != null && allFields.length > 4 && "modifiers".equals(allFields[4].getName())) {
            shouldGetModifierUsingNativeMethod = true;
            return allFields[4];
        }
        throw new ReflectionException("Error accessing field [modifiers] using Native Method.");
    }

    private static Field[] getDeclaredFieldsUsingNativeMethod() throws ReflectionException {
        if (GET_DECLARED_FIELDS0.equals(getAllFieldsNativeMethod)) {
            return (Field[])ReflectionUtility.invokeMethod(Field.class, getAllFieldsNativeMethod, Types.BOOLEAN_CLASS_ARRAY, new Object[]{false});
        }
        return (Field[])ReflectionUtility.invokeMethod(Field.class, getAllFieldsNativeMethod);
    }

    public static void setField(Object object, String fieldName, Object value) throws ReflectionException {
        if (object == null) {
            throw new ReflectionException("setField called with on field [" + fieldName + "] with null object");
        }
        try {
            ReflectionUtility.getJava9Permission(object.getClass());
            Field field = object.getClass().getField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException("Field [" + fieldName + "] of class [" + object.getClass().getName() + "] does not exist", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException("Error accessing field [" + fieldName + "] of class [" + object.getClass().getName() + "]", (Throwable)e);
        }
    }

    public static void setField(Class<?> clazz, Object object, String fieldName, Object value, boolean scanSuperClass) throws ReflectionException {
        try {
            ReflectionUtility.getJava9Permission(clazz);
            Field field = ReflectionUtility.getDeclaredField(clazz, fieldName, scanSuperClass);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException("Field [" + fieldName + "] of class [" + object.getClass().getName() + "] does not exist", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException("Error accessing field [" + fieldName + "] of class [" + object.getClass().getName() + "]", (Throwable)e);
        }
    }

    public static Object getField(Object object, String fieldName) throws ReflectionException {
        return ReflectionUtility.getFieldFromSpecifiedClass(object.getClass(), object, fieldName);
    }

    public static <T> T getField(IADLogger logger, Object toIntrospect, String fieldName) {
        Object result;
        block2: {
            result = null;
            try {
                result = ReflectionUtility.getField(toIntrospect, fieldName, true);
            }
            catch (ReflectionException e) {
                if (e.isCached()) break block2;
                String template = "Error occurred in fetching [%s]";
                logger.error(String.format(template, fieldName), e);
            }
        }
        return (T)result;
    }

    public static Object getField(Object object, String fieldName, boolean scanSuperClass) throws ReflectionException {
        return ReflectionUtility.getFieldFromSpecifiedClass(object.getClass(), object, fieldName, scanSuperClass);
    }

    public static Object getFieldFromSpecifiedClass(Class cls, Object object, String fieldName) throws ReflectionException {
        return ReflectionUtility.getFieldFromSpecifiedClass(cls, object, fieldName, false);
    }

    public static Object getPublicFieldFromSpecifiedClass(Object object, String fieldName) throws ReflectionException {
        return ReflectionUtility.getPublicFieldFromSpecifiedClass(object.getClass(), object, fieldName);
    }

    public static Object getPublicFieldFromSpecifiedClass(Class cls, Object object, String fieldName) throws ReflectionException {
        ConcurrentMap fieldMap = (ConcurrentMap)fieldCache.get(cls);
        if (fieldMap == null) {
            fieldCache.putIfAbsent(cls, new BoundedConcurrentReferenceHashMapBuilder().withUpperLimit(2000).withPolicy(BoundsPolicy.SILENT_FAIL_BOUND_EXCEEDED).withKeyType(AdaptableConcurrentHashMap.ReferenceType.WEAK).withValueType(AdaptableConcurrentHashMap.ReferenceType.WEAK).withServiceName("TransactionMonitoringService").withPropertyName("reflection-cache-limit").build());
            fieldMap = (ConcurrentMap)fieldCache.get(cls);
        }
        Field field = (Field)fieldMap.get(fieldName);
        try {
            if (field == noSuchField) {
                ReflectionUtility.reportError(AgentInternalError.REFLECTION_UTIL_ERROR);
                if (logger.isTraceEnabled()) {
                    logger.trace("Public field [" + fieldName + "] of class [" + cls.getName() + "] does not exist");
                }
                throw cachedNoSuchFieldException;
            }
            if (field == null) {
                Field fieldFromMap;
                ReflectionUtility.getJava9Permission(cls);
                field = cls.getField(fieldName);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if ((fieldFromMap = fieldMap.putIfAbsent(fieldName, field)) != null) {
                    field = fieldFromMap;
                }
            }
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            fieldMap.putIfAbsent(fieldName, noSuchField);
            throw new ReflectionException("Public field [" + fieldName + "] of class [" + cls.getName() + "] does not exist", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            fieldMap.putIfAbsent(fieldName, noSuchField);
            throw new ReflectionException("Error accessing public field [" + fieldName + "] of class [" + cls.getName() + "]", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String classLoaderMessage = "";
            if (field != null && object != null) {
                classLoaderMessage = "Field CL " + field.getDeclaringClass().getClassLoader() + ", object  CL " + object.getClass().getClassLoader();
            }
            fieldMap.putIfAbsent(fieldName, noSuchField);
            throw new ReflectionException("Error  accessing field [" + fieldName + "] of class [" + cls.getName() + "] " + classLoaderMessage, (Throwable)e);
        }
    }

    public static Object getFieldFromSpecifiedClass(Class cls, Object object, String fieldName, boolean scanSuperClass) throws ReflectionException {
        Field field;
        ConcurrentMap fieldMap = (ConcurrentMap)fieldCache.get(cls);
        if (fieldMap == null) {
            fieldCache.putIfAbsent(cls, new BoundedConcurrentReferenceHashMapBuilder().withUpperLimit(2000).withPolicy(BoundsPolicy.SILENT_FAIL_BOUND_EXCEEDED).withKeyType(AdaptableConcurrentHashMap.ReferenceType.WEAK).withValueType(AdaptableConcurrentHashMap.ReferenceType.WEAK).withServiceName("TransactionMonitoringService").withPropertyName("reflection-cache-limit").build());
            fieldMap = (ConcurrentMap)fieldCache.get(cls);
        }
        if ((field = (Field)fieldMap.get(fieldName)) == noSuchField) {
            ReflectionUtility.reportError(AgentInternalError.REFLECTION_UTIL_ERROR);
            if (logger.isTraceEnabled()) {
                logger.trace("Field [" + fieldName + "] of class [" + cls.getName() + "] does not exist in class hierarchy");
            }
            throw cachedNoSuchFieldException;
        }
        try {
            Field fieldFromMap;
            if (field == null && (fieldFromMap = fieldMap.putIfAbsent(fieldName, field = ReflectionUtility.getDeclaredField(cls, fieldName, scanSuperClass))) != null) {
                field = fieldFromMap;
            }
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            fieldMap.putIfAbsent(fieldName, noSuchField);
            String fieldNotExitMessage = "Field [" + fieldName + "] of class [" + cls.getName() + "] does not exist";
            if (scanSuperClass) {
                fieldNotExitMessage = fieldNotExitMessage + " in class hierarchy";
            }
            ReflectionUtility.reportDetailedError(fieldNotExitMessage, e);
            throw new ReflectionException(fieldNotExitMessage, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            fieldMap.putIfAbsent(fieldName, noSuchField);
            String illegalAccessMessage = "Error accessing field [" + fieldName + "] of class [" + cls.getName() + "]";
            ReflectionUtility.reportDetailedError(illegalAccessMessage, e);
            throw new ReflectionException(illegalAccessMessage, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String classLoaderMessage = "";
            if (field != null && object != null) {
                classLoaderMessage = "Field CL " + field.getDeclaringClass().getClassLoader() + ", object  CL " + object.getClass().getClassLoader();
            }
            fieldMap.putIfAbsent(fieldName, noSuchField);
            String illegalArgumentMessage = "Error  accessing field [" + fieldName + "] of class [" + cls.getName() + "] " + classLoaderMessage;
            ReflectionUtility.reportDetailedError(illegalArgumentMessage, e);
            throw new ReflectionException(illegalArgumentMessage, (Throwable)e);
        }
    }

    public static Field getDeclaredField(Class cls, String fieldName, boolean scanSuperClass) throws NoSuchFieldException {
        Field field = null;
        if (scanSuperClass) {
            while (cls != null) {
                try {
                    field = cls.getDeclaredField(fieldName);
                    if (field != null) {
                        break;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                cls = cls.getSuperclass();
            }
            if (field == null) {
                throw new NoSuchFieldException();
            }
            ReflectionUtility.getJava9Permission(field.getDeclaringClass());
            field.setAccessible(true);
            return field;
        }
        field = cls.getDeclaredField(fieldName);
        ReflectionUtility.getJava9Permission(cls);
        field.setAccessible(true);
        return field;
    }

    public static Object invokeSimpleGetter(Object object, String methodName) throws ReflectionException {
        return ReflectionUtility.invokeMethod(object, methodName, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public static Object invokeSimpleGetterRecursive(Object target, List<String> methodList) throws ReflectionException {
        Object returnVal = null;
        try {
            for (String method : methodList) {
                target = returnVal = ReflectionUtility.invokeMethod(target, method, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
            }
        }
        catch (ReflectionException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new ReflectionException("Exception caught in ReflectionUtility.invokeSimpleGetterRecursive: " + t.toString(), t);
        }
        return returnVal;
    }

    public static Object getMethodOrField(Object target, String method) {
        return ReflectionUtility.getMethodOrField(target, method, false, null);
    }

    public static Object getSimpleGetterChainWithoutExceptionAndLogsRecursive(Object target, String getterChain) {
        return ReflectionUtility.getSimpleGetterChainWithoutLogsRecursive(target, getterChain);
    }

    public static Object getSimpleGetterChainWithoutLogsRecursive(Object target, String getterChain) {
        return ReflectionUtility.invokeSimpleGetterRecursiveWithStringInternal(target, getterChain, null, false);
    }

    public static Object getSimpleGetterChainWithoutExceptionAndLogsRecursive(Object target, String[] getterChainList) {
        return ReflectionUtility.invokeSimpleGetterRecursiveWithStringParamInternal(target, getterChainList, null, false);
    }

    private static Object getMethodOrField(Object target, String method, boolean logErrors, DataGathererErrorCheck result) {
        AdaptableConcurrentHashMap cacheForClass;
        Object found;
        block28: {
            int braceBeginIndex;
            if (target == null || method == null) {
                if (result != null) {
                    result.setValid(false);
                    result.setErrorMessage("CANNOT EVALUATE: No target or method specified - target = [" + target + "], method = [" + method + "]");
                }
                return null;
            }
            found = null;
            cacheForClass = (AdaptableConcurrentHashMap)getterCache.get(target.getClass());
            if (cacheForClass != null) {
                Object methodOrField = cacheForClass.get((Object)method);
                if (methodOrField != null && methodOrField != NO_METHOD) {
                    return methodOrField;
                }
                if (methodOrField != null && methodOrField == NO_METHOD) {
                    if (result != null) {
                        result.setValid(false);
                        result.setErrorMessage("CANNOT EVALUATE: Could not find specified method = [" + method + "]");
                    }
                    return null;
                }
            }
            if ((braceBeginIndex = method.indexOf(40)) > 0) {
                String methodName = method.substring(0, braceBeginIndex);
                Class[] classArray = ReflectionUtility.getParamClassList(method, braceBeginIndex);
                if (classArray.length > 0) {
                    try {
                        found = ReflectionUtility.findMethodWithSpecifiedClassLoader(methodName, target, classArray);
                    }
                    catch (ReflectionException e) {
                        if (result != null) {
                            result.setValid(false);
                            result.setErrorMessage("CANNOT EVALUATE: Could not find specified method");
                        }
                        if (logErrors) {
                            logger.error("No method named [" + methodName + "] with a parameters " + StringOperations.classArrayToString((Class[])classArray) + " found in class [" + target.getClass().getName() + "]. This error will not be repeated.", (Throwable)e);
                        }
                        break block28;
                    }
                }
                try {
                    found = ReflectionUtility.findMethodWithSpecifiedClassLoader(methodName, target, null);
                }
                catch (ReflectionException e) {
                    if (result != null) {
                        result.setValid(false);
                        result.setErrorMessage("CANNOT EVALUATE: Could not find specified method");
                    }
                    if (logErrors) {
                        logger.error("No method named [" + methodName + "] with no parameters found in class [" + target.getClass().getName() + "]. This error will not be repeated.", (Throwable)e);
                    }
                    break block28;
                }
            }
            try {
                found = ReflectionUtility.getDeclaredField(target.getClass(), method, true);
            }
            catch (NoSuchFieldException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No field named [" + method + "] found in class [" + target.getClass().getName() + "]. This error will not be repeated. Will look for a method instead.", (Throwable)e);
                }
                try {
                    found = ReflectionUtility.findMethodWithSpecifiedClassLoader(method, target, null);
                }
                catch (ReflectionException e2) {
                    if (result != null) {
                        result.setValid(false);
                        result.setErrorMessage("No field or no-parameter method named [" + method + "] found in class (This was done after the field check) [" + target.getClass().getName() + "]. This error will not be repeated.");
                    }
                    if (logErrors) {
                        logger.error("No field or no-parameter method named [" + method + "] found in class (This was done after the field check) [" + target.getClass().getName() + "]. This error will not be repeated.", (Throwable)e);
                    }
                }
            }
            catch (Throwable t) {
                if (result != null) {
                    result.setValid(false);
                    result.setErrorMessage("No field or no-parameter method named [" + method + "] found in class [" + target.getClass().getName() + "]. This error will not be repeated. Will look for a method instead.");
                }
                if (!logErrors) break block28;
                logger.error("No field or no-parameter method named [" + method + "] found in class [" + target.getClass().getName() + "]. This error will not be repeated. Will look for a method instead.", t);
            }
        }
        if (found == null) {
            found = NO_METHOD;
        }
        if (cacheForClass == null) {
            cacheForClass = new BoundedConcurrentReferenceHashMapBuilder().withUpperLimit(2000).withPolicy(BoundsPolicy.SILENT_FAIL_BOUND_EXCEEDED).withKeyType(AdaptableConcurrentHashMap.ReferenceType.WEAK).withValueType(AdaptableConcurrentHashMap.ReferenceType.WEAK).withServiceName("TransactionMonitoringService").withPropertyName("reflection-cache-limit").build();
            AdaptableConcurrentHashMap present = (AdaptableConcurrentHashMap)getterCache.putIfAbsent(target.getClass(), (Object)cacheForClass);
            if (present != null) {
                cacheForClass = present;
            }
        }
        cacheForClass.put((Object)method, found);
        return found != NO_METHOD ? found : null;
    }

    public static Method findMethodWithSpecifiedClassLoader(String methodName, Object target, Class[] paramClassList) throws ReflectionException {
        try {
            return ReflectionUtility.getMethodWithSpecifiedClassLoader(methodName, target, paramClassList);
        }
        catch (ReflectionException e) {
            return ReflectionUtility.getDeclaredMethodWithSpecifiedClassLoader(methodName, target, paramClassList);
        }
    }

    public static Class[] getParamClassList(String arrayParamStr, int braceIndex) {
        Class[] paramsList = (Class[])paramCache.get((Object)arrayParamStr);
        if (paramsList == null) {
            ReflectionUtility.parseParams(arrayParamStr, braceIndex);
            paramsList = (Class[])paramCache.get((Object)arrayParamStr);
        }
        return paramsList;
    }

    public static Object[] getParamObjectList(String arrayParamStr, int braceIndex) {
        Object[] objectList = (Object[])valuesCache.get((Object)arrayParamStr);
        if (objectList == null) {
            ReflectionUtility.parseParams(arrayParamStr, braceIndex);
            objectList = (Object[])valuesCache.get((Object)arrayParamStr);
        }
        return objectList;
    }

    private static void parseParams(String paramStr, int braceIndex) {
        ArrayList<Class<Float>> paramsList = new ArrayList<Class<Float>>();
        ArrayList<Float> valuesList = new ArrayList<Float>();
        char[] arrayParamStr = paramStr.toCharArray();
        int length = arrayParamStr.length;
        int i = braceIndex + 1;
        while (i < length) {
            Object value;
            Class<Object> clazz;
            StringBuilder sb = new StringBuilder();
            int classEnd = 0;
            int valueBegin = 0;
            int valueEnd = 0;
            int ch = 0;
            while (i < length) {
                ch = arrayParamStr[i];
                ++i;
                if (ch == 44 || ch == 41) break;
                if (Character.isWhitespace((char)ch)) {
                    if (sb.length() <= 0) continue;
                    sb.append((char)ch);
                    continue;
                }
                if (ch == 47 && valueBegin == 0) {
                    classEnd = sb.length();
                    sb.append((char)ch);
                    while (i < length && Character.isWhitespace(arrayParamStr[i])) {
                        sb.append(arrayParamStr[i]);
                        ++i;
                    }
                    valueEnd = valueBegin = sb.length();
                    continue;
                }
                if (ch == 92 && i < length) {
                    ch = arrayParamStr[i];
                    ++i;
                    switch (ch) {
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                            break;
                        }
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 116: {
                            ch = 9;
                        }
                    }
                }
                sb.append((char)ch);
                valueEnd = sb.length();
            }
            if (valueEnd == 0 && ch != 44 && paramsList.isEmpty()) break;
            String parsedString = sb.toString();
            String className = parsedString.substring(0, classEnd).toLowerCase().trim();
            String valueString = parsedString.substring(valueBegin, valueEnd);
            if (className.equals("float")) {
                clazz = Float.TYPE;
                value = Float.valueOf(Float.parseFloat(valueString));
            } else if (className.equals("boolean")) {
                clazz = Boolean.class;
                value = Boolean.parseBoolean(valueString);
            } else if (className.equals("bool")) {
                clazz = Boolean.TYPE;
                value = Boolean.parseBoolean(valueString);
            } else if (className.equals("int")) {
                clazz = Integer.TYPE;
                value = Integer.parseInt(valueString);
            } else if (className.equals("long")) {
                clazz = Long.TYPE;
                value = Long.parseLong(valueString);
            } else if (className.equals("object")) {
                clazz = Object.class;
                value = valueString;
            } else if (className.equals("string")) {
                clazz = String.class;
                value = valueString;
            } else {
                clazz = String.class;
                value = parsedString.substring(0, valueEnd);
            }
            paramsList.add(clazz);
            valuesList.add((Float)value);
        }
        paramCache.put((Object)paramStr, (Object)paramsList.toArray(new Class[paramsList.size()]));
        valuesCache.put((Object)paramStr, (Object)valuesList.toArray(new Object[valuesList.size()]));
    }

    public static String[] parseGetterChainMethods(String getterChain) {
        ArrayList<String> parsedList = new ArrayList<String>();
        boolean escaped = false;
        boolean inParan = false;
        int prevSplit = 0;
        int splits = 0;
        for (int i = 0; i < getterChain.length(); ++i) {
            if (escaped) {
                escaped = false;
                continue;
            }
            if (getterChain.charAt(i) == '(') {
                inParan = true;
            }
            if (getterChain.charAt(i) == ')') {
                inParan = false;
                continue;
            }
            if (getterChain.charAt(i) == '\\') {
                escaped = true;
                continue;
            }
            if (inParan || '.' != getterChain.charAt(i)) continue;
            parsedList.add(getterChain.substring(prevSplit, i).trim());
            prevSplit = i + 1;
            ++splits;
        }
        parsedList.add(getterChain.substring(prevSplit, getterChain.length()).trim());
        return parsedList.toArray(new String[parsedList.size()]);
    }

    public static Object invokeSimpleGetterRecursiveWithString(Object target, String getterChain) {
        return ReflectionUtility.invokeSimpleGetterRecursiveWithString(target, getterChain, null);
    }

    public static Object invokeSimpleGetterRecursiveWithString(Object target, String getterChain, DataGathererErrorCheck result) {
        return ReflectionUtility.invokeSimpleGetterRecursiveWithStringInternal(target, getterChain, result, true);
    }

    private static Object invokeSimpleGetterRecursiveWithStringInternal(Object target, String getterChain, DataGathererErrorCheck result, boolean shouldLog) {
        if (getterChain == null) {
            return null;
        }
        String[] methodList = (String[])chainCache.get((Object)getterChain);
        if (methodList == null) {
            methodList = ReflectionUtility.parseGetterChainMethods(getterChain);
            chainCache.put((Object)getterChain, (Object)methodList);
        }
        return ReflectionUtility.invokeSimpleGetterRecursiveWithStringParamInternal(target, methodList, result, shouldLog);
    }

    private static Object safeArrayIdx(Object[] array, int index) {
        Object obj = null;
        if (index >= 0 && index < array.length) {
            obj = array[index];
        }
        return obj;
    }

    @Deprecated
    public static Object invokeSimpleGetterRecursiveWithStringParam(Object target, String[] methodList) {
        return ReflectionUtility.invokeSimpleGetterRecursiveWithStringParam(target, methodList, null);
    }

    @Deprecated
    public static Object invokeSimpleGetterRecursiveWithStringParam(Object target, String[] methodList, DataGathererErrorCheck result) {
        return ReflectionUtility.invokeSimpleGetterRecursiveWithStringParamInternal(target, methodList, result, true);
    }

    private static Object invokeSimpleGetterRecursiveWithStringParamInternal(Object target, String[] methodList, DataGathererErrorCheck result, boolean shouldLog) {
        if (logger.isTraceEnabled()) {
            logger.trace("Invoking getter-chain [" + Arrays.toString(methodList) + "]");
        }
        Object returnVal = null;
        for (String method : methodList) {
            if (target == null) {
                ReflectionUtility.buildResultObject(result, "CANNOT EVALUATE: No target specified", false);
                return null;
            }
            if (useSafeGetterChains) {
                if (returnVal != null && ReflectionUtility.isBlacklistedClass(returnVal.getClass().getName())) {
                    ReflectionUtility.buildResultObject(result, "CANNOT EVALUATE: Getter chains on object of type [" + returnVal.getClass().getName() + "] not allowed.", false);
                    return null;
                }
                if (ReflectionUtility.isBlacklistedMethod(method)) {
                    ReflectionUtility.buildResultObject(result, "CANNOT EVALUATE: Getter chains not allowed to invoke method [" + method + "].", false);
                    return null;
                }
            }
            if (method.equals("this")) {
                returnVal = target;
            } else if (method.equals("length") && target.getClass().isArray()) {
                returnVal = Array.getLength(target);
            } else if (method.startsWith("[") && method.endsWith("]") && target.getClass().isArray()) {
                String[] indices = method.substring(1, method.length() - 1).split(",");
                try {
                    if (indices.length == 1) {
                        returnVal = ReflectionUtility.getIndexedObjectFromUnknownArray(target, Integer.parseInt(indices[0].trim()));
                    }
                    StringBuilder builder = new StringBuilder();
                    for (int n = 0; n < indices.length; ++n) {
                        int index = Integer.parseInt(indices[n].trim());
                        builder.append(String.valueOf(ReflectionUtility.getIndexedObjectFromUnknownArray(target, index)));
                    }
                    returnVal = builder.toString();
                }
                catch (ClassCastException e) {
                    ReflectionUtility.buildResultObject(result, "CANNOT EVALUATE: Error retrieving target, array expected and received [" + target.getClass() + "]", false);
                    return null;
                }
            } else {
                Object cachedMethod = ReflectionUtility.getMethodOrField(target, method, shouldLog, result);
                if (cachedMethod == null) {
                    if (result != null && result.isValid()) {
                        result.setValid(false);
                        result.setErrorMessage("CANNOT EVALUATE: Invalid getter chain specified");
                    }
                    return null;
                }
                try {
                    if (cachedMethod instanceof Method) {
                        Object[] arrayParamStr;
                        ReflectionUtility.getJava9Permission(((Method)cachedMethod).getDeclaringClass());
                        int braceBeginIndex = method.indexOf(40);
                        returnVal = braceBeginIndex > 0 ? ((arrayParamStr = ReflectionUtility.getParamObjectList(method, braceBeginIndex)).length > 0 ? ((Method)cachedMethod).invoke(target, arrayParamStr) : ((Method)cachedMethod).invoke(target, new Object[0])) : ((Method)cachedMethod).invoke(target, new Object[0]);
                    } else if (cachedMethod instanceof Field) {
                        ReflectionUtility.getJava9Permission(((Field)cachedMethod).getDeclaringClass());
                        returnVal = ((Field)cachedMethod).get(target);
                    }
                }
                catch (IllegalAccessException e) {
                    ReflectionUtility.buildResultObject(result, "CANNOT EVALUATE", false);
                    return null;
                }
                catch (InvocationTargetException e) {
                    ReflectionUtility.buildResultObject(result, "CANNOT EVALUATE: Invalid getter chain", false);
                    return null;
                }
            }
            target = returnVal;
        }
        return returnVal;
    }

    private static final boolean isBlacklistedMethod(String method) {
        int openParenIndex = method.indexOf("(");
        String methodName = openParenIndex == -1 ? method : method.substring(0, openParenIndex);
        return BLACK_LISTED_GETTER_CHAIN_METHOD_CALLS.contains(methodName);
    }

    private static final boolean isBlacklistedClass(String className) {
        for (String blackListedClass : BLACK_LISTED_GETTER_CHAIN_CLASSES_AND_PACKAGES) {
            if (!className.startsWith(blackListedClass)) continue;
            return true;
        }
        return false;
    }

    private static void buildResultObject(DataGathererErrorCheck result, String errorMessage, boolean valid) {
        if (result != null) {
            result.setValid(valid);
            result.setErrorMessage(errorMessage);
        }
    }

    private static Object getIndexedObjectFromUnknownArray(Object inputArray, int index) throws ClassCastException {
        Object result = null;
        if (Object.class.isAssignableFrom(inputArray.getClass().getComponentType())) {
            Object[] inputObjects = (Object[])inputArray;
            result = ReflectionUtility.safeArrayIdx(inputObjects, index);
        } else if (inputArray instanceof int[]) {
            int[] array = (int[])inputArray;
            result = index >= 0 && index < array.length ? new Integer(array[index]) : null;
        } else if (inputArray instanceof byte[]) {
            byte[] array = (byte[])inputArray;
            result = index >= 0 && index < array.length ? new Byte(array[index]) : null;
        } else if (inputArray instanceof short[]) {
            short[] array = (short[])inputArray;
            result = index >= 0 && index < array.length ? new Short(array[index]) : null;
        } else if (inputArray instanceof long[]) {
            long[] array = (long[])inputArray;
            result = index >= 0 && index < array.length ? new Long(array[index]) : null;
        } else if (inputArray instanceof float[]) {
            float[] array = (float[])inputArray;
            result = index >= 0 && index < array.length ? new Float(array[index]) : null;
        } else if (inputArray instanceof double[]) {
            double[] array = (double[])inputArray;
            result = index >= 0 && index < array.length ? new Double(array[index]) : null;
        } else if (inputArray instanceof char[]) {
            char[] array = (char[])inputArray;
            result = index >= 0 && index < array.length ? new Character(array[index]) : null;
        } else if (inputArray instanceof boolean[]) {
            boolean[] array = (boolean[])inputArray;
            result = index >= 0 && index < array.length ? new Boolean(array[index]) : null;
        }
        return result;
    }

    public static Object invokeSimpleGetterRecursive(Object target, String[] methodList) throws ReflectionException {
        Object returnVal = null;
        try {
            for (String method : methodList) {
                int braceBeginIndex = method.indexOf(40);
                if (braceBeginIndex > 0) {
                    String methodName = method.substring(0, braceBeginIndex);
                    String arrayIndexStr = method.substring(braceBeginIndex + 1, method.indexOf(41));
                    if (arrayIndexStr.length() > 0) {
                        Integer arrayIndex = new Integer(arrayIndexStr);
                        returnVal = ReflectionUtility.invokeMethod(target, methodName, Types.INT_CLASS_ARRAY, new Object[]{arrayIndex});
                    } else {
                        returnVal = ReflectionUtility.invokeMethod(target, methodName, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
                    }
                } else {
                    returnVal = ReflectionUtility.invokeMethod(target, method, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
                }
                target = returnVal;
            }
        }
        catch (ReflectionException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new ReflectionException("Exception caught in ReflectionUtility.invokeSimpleGetterRecursive: " + t.toString(), t);
        }
        return returnVal;
    }

    public static Object newInstanceNullOnException(String className, ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className, false, classLoader);
            return ReflectionUtility.newInstance(clazz);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Error creating new instance for: " + className, e);
            }
            return null;
        }
    }

    public static <T> T newInstance(Class<T> clazz) throws IllegalAccessException, InstantiationException {
        ReflectionUtility.getJava9Permission(clazz);
        return clazz.newInstance();
    }

    public static <T> T newInstance(Class<T> clazz, Class[] constructorParamTypes, Object ... constructorParams) throws ReflectionException {
        try {
            ReflectionUtility.getJava9Permission(clazz);
            return clazz.getDeclaredConstructor(constructorParamTypes).newInstance(constructorParams);
        }
        catch (InstantiationException e) {
            throw new ReflectionException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException((Throwable)e);
        }
    }

    public static <T> T defaultValue() {
        return null;
    }

    public static Object findAndInvokeMethod(Object object, String methodName, Class[] paramCls, Object[] params) throws ReflectionException {
        if (object != null) {
            Method m = ReflectionUtility.findMethodWithSpecifiedClassLoader(methodName, object, paramCls);
            if (m == noSuchMethod) {
                throw cachedNoSuchMethodException;
            }
            try {
                return m.invoke(object, params);
            }
            catch (Throwable t) {
                throw new ReflectionException("Error invoking method" + methodName + " on object " + object.getClass().getName(), t);
            }
        }
        return null;
    }

    public static <T> T call(IADLogger logger, Object toIntrospect, String methodName) {
        Object result;
        block2: {
            result = null;
            try {
                result = ReflectionUtility.invokeMethod(toIntrospect, methodName);
            }
            catch (ReflectionException e) {
                if (e.isCached()) break block2;
                String template = "Error occurred in calling method [%s]";
                logger.error(String.format(template, methodName), e);
            }
        }
        return (T)result;
    }

    public static Object invokeMethod(Object object, String methodName, String[] types, Object[] values) throws ReflectionException {
        if (object == null) {
            throw new ReflectionException("Reflection target cannot be null");
        }
        if (types != null && values != null && types.length > 0) {
            if (types.length != values.length) {
                throw new ReflectionException("Number of reflection arg values and types do not match");
            }
            Class[] typeClasses = new Class[types.length];
            try {
                for (int i = 0; i < types.length; ++i) {
                    typeClasses[i] = Class.forName(types[i]);
                }
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException("Error occurred in finding type classes", (Throwable)e);
            }
            return ReflectionUtility.invokeMethod(object, methodName, typeClasses, values);
        }
        return ReflectionUtility.invokeMethod(object, methodName);
    }

    public static Object invokeMethod(Object object, String methodName, Class[] paramCls, Object[] params) throws ReflectionException {
        if (object == null) {
            throw new ReflectionException("Reflection target cannot be null");
        }
        return ReflectionUtility.invokeMethodOnSpecifiedClass(object.getClass(), object, methodName, paramCls, params);
    }

    public static Object invokeMethod(Object object, String methodName) throws ReflectionException {
        return ReflectionUtility.invokeMethod(object, methodName, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public static Object invokeMethodOnSpecifiedClass(Class cls, Object object, String methodName, Class[] paramCls, Object[] params) throws ReflectionException {
        return ReflectionUtility.doInvokeMethodOnSpecifiedClass(cls, object, methodName, paramCls, params, true);
    }

    public static Object invokeDeclaredMethodOnSpecifiedClass(Class cls, Object object, String methodName, Class[] paramCls, Object[] params) throws ReflectionException {
        return ReflectionUtility.doInvokeMethodOnSpecifiedClass(cls, object, methodName, paramCls, params, false);
    }

    private static Object doInvokeMethodOnSpecifiedClass(Class cls, Object object, String methodName, Class[] paramCls, Object[] params, boolean publicAccess) throws ReflectionException {
        if (object == null) {
            throw new ReflectionException("Object cannot be null");
        }
        try {
            Method method = null;
            Map methodCacheSet = (Map)methodCache.get(cls);
            if (methodCacheSet == null) {
                methodCache.putIfAbsent(cls, new BoundedConcurrentReferenceHashMapBuilder().withUpperLimit(2000).withPolicy(BoundsPolicy.SILENT_FAIL_BOUND_EXCEEDED).withKeyType(AdaptableConcurrentHashMap.ReferenceType.WEAK).withValueType(AdaptableConcurrentHashMap.ReferenceType.WEAK).withServiceName("TransactionMonitoringService").withPropertyName("reflection-cache-limit").build());
                methodCacheSet = (Map)methodCache.get(cls);
            }
            if ((method = (Method)methodCacheSet.get(new MethodCacheEntry(methodName, ReflectionUtility.convertParams(paramCls)))) == noSuchMethod) {
                ReflectionUtility.reportError(AgentInternalError.REFLECTION_UTIL_ERROR);
                if (logger.isTraceEnabled()) {
                    logger.trace("Method [" + methodName + "] of class [" + cls.getName() + "] with param length " + paramCls.length + " does not exist.");
                }
                throw cachedNoSuchMethodException;
            }
            if (method == null) {
                try {
                    ReflectionUtility.getJava9Permission(cls);
                    if (publicAccess) {
                        try {
                            method = cls.getMethod(methodName, paramCls);
                        }
                        catch (NoSuchMethodException ex) {
                            try {
                                method = cls.getDeclaredMethod(methodName, paramCls);
                            }
                            catch (NoSuchMethodException m) {
                                methodCacheSet.put(new MethodCacheEntry(methodName, ReflectionUtility.convertParams(paramCls)), noSuchMethod);
                                throw new ReflectionException("Method [" + methodName + "] of class [" + cls.getName() + "] with param length " + paramCls.length + " does not exist.", (Throwable)m);
                            }
                        }
                    } else {
                        method = cls.getDeclaredMethod(methodName, paramCls);
                    }
                    method.setAccessible(true);
                    methodCacheSet.put(new MethodCacheEntry(methodName, ReflectionUtility.convertParams(paramCls)), method);
                }
                catch (NoSuchMethodException e) {
                    methodCacheSet.put(new MethodCacheEntry(methodName, ReflectionUtility.convertParams(paramCls)), noSuchMethod);
                    String noSuchMethodMessage = "Method [" + methodName + "] of class [" + cls.getName() + "] with param length " + paramCls.length + " does not exist.";
                    ReflectionUtility.reportDetailedError(noSuchMethodMessage, e);
                    throw new ReflectionException(noSuchMethodMessage, (Throwable)e);
                }
                catch (Throwable t) {
                    methodCacheSet.put(new MethodCacheEntry(methodName, ReflectionUtility.convertParams(paramCls)), noSuchMethod);
                    String errorGettingMethod = "Error getting method [" + methodName + "] of class [" + cls.getName() + "]";
                    ReflectionUtility.reportDetailedError(errorGettingMethod, t);
                    if (t instanceof ReflectionException) {
                        throw (ReflectionException)t;
                    }
                    throw new ReflectionException(errorGettingMethod, t);
                }
            }
            try {
                return method.invoke(object, params);
            }
            catch (InvocationTargetException e) {
                String errorInvokingMessage = "Error invoking Method [" + methodName + "] of class [" + cls.getName() + "] ";
                ReflectionUtility.reportDetailedError(errorInvokingMessage, e.getTargetException());
                throw new ReflectionException(errorInvokingMessage, e.getTargetException());
            }
            catch (IllegalAccessException e) {
                methodCacheSet.put(new MethodCacheEntry(methodName, ReflectionUtility.convertParams(paramCls)), noSuchMethod);
                String illegalAccessMessage = "Error accessing method [" + methodName + "] of class [" + cls.getName() + "]";
                ReflectionUtility.reportDetailedError(illegalAccessMessage, e);
                throw new ReflectionException(illegalAccessMessage, (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                String classLoaderMessage = "";
                if (method != null && object != null) {
                    classLoaderMessage = "Field CL " + method.getDeclaringClass().getClassLoader() + ", object  CL " + object.getClass().getClassLoader();
                }
                methodCacheSet.put(new MethodCacheEntry(methodName, ReflectionUtility.convertParams(paramCls)), noSuchMethod);
                String illegalArgumentMessage = "Error invoking method [" + methodName + "] of class [" + cls.getName() + "] " + classLoaderMessage;
                ReflectionUtility.reportDetailedError(illegalArgumentMessage, e);
                throw new ReflectionException(illegalArgumentMessage, (Throwable)e);
            }
        }
        catch (Throwable e) {
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            throw new ReflectionException("Error invoking Method [" + methodName + "] of class [" + cls.getName() + "] ", e);
        }
    }

    static Method getCachedMethod(Object object, String methodName, Class[] paramCls) {
        Map methodCacheSet = (Map)methodCache.get(object.getClass());
        if (methodCacheSet != null) {
            return (Method)methodCacheSet.get(new MethodCacheEntry(methodName, ReflectionUtility.convertParams(paramCls)));
        }
        return null;
    }

    public static Class[] convertParamsForReflection(Object[] params) {
        Class[] classArray = new Class[params.length];
        int i = 0;
        for (Object param : params) {
            classArray[i++] = param.getClass();
        }
        return classArray;
    }

    public static Set<String> getMethodsOnIntfImplementedByClass(Class cls, String intfName) {
        Class<?>[] intfs;
        HashSet<String> intfMethods = new HashSet<String>();
        for (Class<?> intf : intfs = cls.getInterfaces()) {
            Method[] methods;
            if (!intfName.equals(intf.getName())) continue;
            for (Method intfMethod : methods = intf.getDeclaredMethods()) {
                intfMethods.add(intfMethod.getName());
            }
        }
        return intfMethods;
    }

    public static Method getDeclaredMethodWithSpecifiedClassLoader(String methodName, Object obj, Class ... parameterTypes) throws ReflectionException {
        return ReflectionUtility.getDeclaredMethodWithSpecifiedClassLoader(obj.getClass().getName(), methodName, obj, parameterTypes);
    }

    public static Method getDeclaredMethodWithSpecifiedClassLoader(String className, String methodName, Object obj, Class ... parameterTypes) throws ReflectionException {
        if (obj == null) {
            throw new ReflectionException("Object is null, cannot lookup method using its classLoader");
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(className, true, obj.getClass().getClassLoader());
            ReflectionUtility.getJava9Permission(cls);
            Method m = cls.getDeclaredMethod(methodName, parameterTypes);
            m.setAccessible(true);
            return m;
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException("Error in loading class [" + className + "] with loader [" + obj.getClass().getClassLoader() + "].", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            if (parameterTypes != null && parameterTypes.length > 0) {
                try {
                    Method m = ReflectionUtility.getMethodWithSpecifiedClassLoaderWithSuperParms(cls, methodName, true, parameterTypes);
                    if (m != null) {
                        return m;
                    }
                }
                catch (Exception e1) {
                    logger.error(String.format("Exception %s caught in getDeclaredMethodWithSpecifiedClassLoader()", e1), (Throwable)e1);
                }
            }
            throw new ReflectionException("No method named [" + methodName + "] with parameter(s) " + StringOperations.classArrayToString((Class[])parameterTypes) + " found in class [" + className + "].", (Throwable)e);
        }
    }

    private static Method getMethodWithSpecifiedClassLoader(String methodName, Object obj, Class ... parameterTypes) throws ReflectionException {
        Class<?> cls = null;
        if (obj == null) {
            throw new ReflectionException("Object is null, cannot lookup method using its classLoader");
        }
        String className = obj.getClass().getName();
        try {
            cls = obj.getClass();
            ReflectionUtility.getJava9Permission(cls);
            Method m = cls.getMethod(methodName, parameterTypes);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException e) {
            if (parameterTypes != null && parameterTypes.length > 0) {
                try {
                    Method m = ReflectionUtility.getMethodWithSpecifiedClassLoaderWithSuperParms(cls, methodName, false, parameterTypes);
                    if (m != null) {
                        return m;
                    }
                }
                catch (Exception e1) {
                    logger.error(String.format("Exception %s caught in getMethodWithSpecifiedClassLoader()", e1), (Throwable)e1);
                }
            }
            throw new ReflectionException("No method by name [" + methodName + "] found in class [" + className + "]", (Throwable)e);
        }
        catch (Throwable t) {
            throw new ReflectionException("Error while trying to get method by name [" + methodName + "] found in class [" + className + "]", t);
        }
    }

    private static void getAllPossibleArgTypes(int varyIndex, Class<?>[] initialArgTypes, Set<ArgTypes> addToSet) {
        Class<?>[] newArgTypes = ReflectionUtility.copyArgTypes(initialArgTypes);
        while (newArgTypes[varyIndex].getSuperclass() != null && addToSet.size() < 10) {
            newArgTypes[varyIndex] = newArgTypes[varyIndex].getSuperclass();
            addToSet.add(new ArgTypes(newArgTypes));
            if (varyIndex >= newArgTypes.length - 1) continue;
            ReflectionUtility.getAllPossibleArgTypes(varyIndex + 1, newArgTypes, addToSet);
        }
        if (varyIndex < initialArgTypes.length - 1 && addToSet.size() < 10) {
            ReflectionUtility.getAllPossibleArgTypes(varyIndex + 1, initialArgTypes, addToSet);
        }
    }

    private static Class<?>[] copyArgTypes(Class<?>[] argTypeArray) {
        Class[] argTypes = new Class[argTypeArray.length];
        System.arraycopy(argTypeArray, 0, argTypes, 0, argTypes.length);
        return argTypes;
    }

    private static Method getMethodWithSpecifiedClassLoaderWithSuperParms(Class<?> clazz, String methodName, boolean getDeclaredMethod, Class ... parameterTypes) throws Exception {
        Method returnMethod = null;
        HashSet<ArgTypes> setOfAllArgTypes = new HashSet<ArgTypes>();
        ReflectionUtility.getAllPossibleArgTypes(0, parameterTypes, setOfAllArgTypes);
        for (ArgTypes nextArgType : setOfAllArgTypes) {
            try {
                ReflectionUtility.getJava9Permission(clazz);
                returnMethod = getDeclaredMethod ? clazz.getDeclaredMethod(methodName, nextArgType.argTypes) : clazz.getMethod(methodName, nextArgType.argTypes);
                returnMethod.setAccessible(true);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return returnMethod;
    }

    public static Class getIntfForClass(Class cls, String intfName) {
        Class<?>[] intfs;
        for (Class<?> intf : intfs = cls.getInterfaces()) {
            if (!intf.getName().equals(intfName)) continue;
            return intf;
        }
        return null;
    }

    public static String getDescriptorForClass(Class cls) {
        Class<?>[] intfs;
        StringBuilder sb = new StringBuilder();
        sb.append("Class Name [").append(cls.getName()).append("]");
        sb.append("Class Hierarchy [");
        while (!cls.getName().equals("java.lang.Object")) {
            sb.append(cls.getName()).append("-");
            cls = cls.getSuperclass();
        }
        sb.append("]");
        sb.append("Interfaces Implemented [");
        for (Class<?> intf : intfs = cls.getInterfaces()) {
            sb.append(intf.getName()).append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean isAssignableFrom(Class targetClass, Object srcObject) {
        ReflectionUtility.getJava9Permission(targetClass);
        ReflectionUtility.getJava9Permission(srcObject.getClass());
        return targetClass.isAssignableFrom(srcObject.getClass());
    }

    public static boolean isAssignableFrom(Class targetClass, Class srcClass) {
        ReflectionUtility.getJava9Permission(targetClass);
        ReflectionUtility.getJava9Permission(srcClass);
        return targetClass.isAssignableFrom(srcClass);
    }

    public static FieldLocation getContainedClassThatMatchesGivenClassNamesAndIsAssignableFrom(Object container, String assignableFrom, String[] classNamesToMatch) throws ClassNotFoundException {
        Class<?> assignableFromClass = Class.forName(assignableFrom, true, container.getClass().getClassLoader());
        return ReflectionUtility.getContainedClassThatMatchesGivenClassNamesAndIsAssignableFrom(container, assignableFromClass, classNamesToMatch);
    }

    public static FieldLocation getContainedClassThatMatchesGivenClassNamesAndIsAssignableFrom(Object container, Class assignableFrom, String[] classNamesToMatch) throws ClassNotFoundException {
        FindField ff = new FindField(container, assignableFrom, classNamesToMatch);
        ff.findContainedClassThatMatchesGivenClassNamesAndIsAssignableFrom();
        if (ff.matchedYou != null) {
            return new FieldLocation(ff.matchedYou, ff.fldExpression);
        }
        return null;
    }

    public static Class classForName(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public static Class classForName(String className, boolean initialize, Class clazz) throws ClassNotFoundException {
        return Class.forName(className, initialize, clazz.getClassLoader());
    }

    public static Class classForName(String className, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(className, initialize, loader);
    }

    public static List<Field> getDeclaredFields(Class cls, boolean scanSuperClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (scanSuperClass) {
            while (cls != null) {
                ReflectionUtility.getJava9Permission(cls);
                Field[] fieldArr = classToFieldMapping.get(cls);
                if (fieldArr == null) {
                    fieldArr = cls.getDeclaredFields();
                    classToFieldMapping.put(cls, fieldArr);
                }
                for (Field field : fieldArr) {
                    if (field.getName().startsWith("this$")) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    fields.add(field);
                }
                cls = cls.getSuperclass();
            }
        } else {
            Field[] fieldArr = classToFieldMapping.get(cls);
            if (fieldArr == null) {
                fieldArr = cls.getDeclaredFields();
                classToFieldMapping.put(cls, fieldArr);
            }
            for (Field field : fieldArr) {
                if (field.getName().startsWith("this$")) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                fields.add(field);
            }
        }
        return fields;
    }

    public static String printAllMethods(Class cls) {
        Field[] fields1;
        Field[] fileds;
        Method[] methods1;
        Method[] methods;
        Class<?>[] intfs;
        System.out.println("Class Name (((((((((((((((((((((((((())))))))))))))))))))))))))" + cls.getName());
        if (cls.getProtectionDomain() != null && cls.getProtectionDomain().getCodeSource() != null) {
            System.out.println("Location ((((((((((((((((( " + cls.getProtectionDomain().getCodeSource().getLocation());
        }
        System.out.println("Interfaces  (((((((((((((((((((((((((())))))))))))))))))))))))))");
        for (Class<?> intf : intfs = cls.getInterfaces()) {
            System.out.println("Interface ################# " + intf.getName());
        }
        System.out.println("End Interfaces  (((((((((((((((((((((((((())))))))))))))))))))))))))");
        System.out.println("Public  Methods  (((((((((((((((((((((((((())))))))))))))))))))))))))");
        for (Method method : methods = cls.getMethods()) {
            System.out.println("Method >" + method.getName() + "Desc >" + method);
        }
        System.out.println("End Public  Methods  (((((((((((((((((((((((((())))))))))))))))))))))))))");
        System.out.println("All  Methods  (((((((((((((((((((((((((())))))))))))))))))))))))))");
        for (Method method1 : methods1 = cls.getDeclaredMethods()) {
            System.out.println("Declared Method >" + method1.getName() + "Desc >" + method1);
        }
        System.out.println("All FIELDS  (((((((((((((((((((((((((())))))))))))))))))))))))))");
        System.out.println("Public  Fields  (((((((((((((((((((((((((())))))))))))))))))))))))))");
        for (Field field : fileds = cls.getFields()) {
            System.out.println("Field >" + field.getName() + "Desc >" + field);
        }
        System.out.println("End Public  Fields  (((((((((((((((((((((((((())))))))))))))))))))))))))");
        System.out.println("All  Fields  (((((((((((((((((((((((((())))))))))))))))))))))))))");
        for (Field field : fields1 = cls.getDeclaredFields()) {
            System.out.println("Declared Field >" + field.getName() + "Desc >" + field);
        }
        System.out.println("All Methods  (((((((((((((((((((((((((())))))))))))))))))))))))))");
        System.out.println("End Class Name (((((((((((((((((((((((((())))))))))))))))))))))))))" + cls.getName());
        return "";
    }

    public static void printClassStructure(Class cls, StringBuilder sb) {
        Annotation[] declaredAnnotations;
        Method[] declaredMethods;
        Class<?>[] intfs;
        sb.append("Class Name [").append(cls.getName()).append("]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
        if (cls.getProtectionDomain() != null && cls.getProtectionDomain().getCodeSource() != null) {
            sb.append("Location [").append(cls.getProtectionDomain().getCodeSource().getLocation()).append("]\n\n");
        }
        sb.append("Super Class [").append(cls.getSuperclass()).append("]\n\n");
        sb.append("Directly Implemented Interfaces *******************************************\n");
        for (Class<?> intf : intfs = cls.getInterfaces()) {
            sb.append("Interface [ ").append(intf.getName()).append(" ]\n");
        }
        sb.append("End Directly Implemented Interfaces  ******************************************************\n\n");
        sb.append("All  Declared Methods  ************************************************************\n");
        for (Method declaredMethod : declaredMethods = cls.getDeclaredMethods()) {
            sb.append("Declared Method [ ").append(declaredMethod.getName()).append(" ] Desc [ ").append(declaredMethod).append(" ]\n\n");
        }
        sb.append("End Declared Methods  **************************************************************\n\n");
        sb.append("All  Declared Annotations  ************************************************************\n");
        for (Annotation declaredAnnotation : declaredAnnotations = ReflectionUtility.getAnnotationsFor(cls)) {
            sb.append("Declared Annotation [ ").append(declaredAnnotation.annotationType().getName()).append(" ] Desc [ ").append(declaredAnnotation).append(" ]\n");
        }
        sb.append("End Declared Annotation  **************************************************************\n\n");
        sb.append("End Class Name [").append(cls.getName()).append("]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n");
        Class superClass = cls.getSuperclass();
        if (superClass == null) {
            return;
        }
        String superClassName = superClass.getName();
        if (superClassName.startsWith("java")) {
            sb.append("Stops at class [").append(superClassName).append(" ] !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n");
        } else {
            sb.append("Continuing with class structure for [ ").append(superClassName).append(" ]\n\n");
            ReflectionUtility.printClassStructure(superClass, sb);
        }
    }

    private static Annotation[] getAnnotationsFor(Class clazz) {
        List<Annotation> annotationList = ReflectionUtility.getDeclaredAnnotationsForClass(clazz);
        Annotation[] returnObject = annotationList.toArray(new Annotation[annotationList.size()]);
        return returnObject;
    }

    private static Annotation[] getAnnotationsFor(Method method) {
        Annotation[] returnObject = (Annotation[])methodAnnotationCache.get((Object)method);
        if (returnObject == null) {
            returnObject = method.getDeclaredAnnotations();
            if (returnObject == null) {
                returnObject = new Annotation[]{};
            }
            methodAnnotationCache.put((Object)method, (Object)returnObject);
        }
        return returnObject;
    }

    private static Method[] getMethodsForAnnotationClass(Class<? extends Annotation> annotation) {
        Method[] returnObject = (Method[])annotationMethodCache.get(annotation);
        if (returnObject == null) {
            returnObject = annotation.getDeclaredMethods();
            if (returnObject == null) {
                returnObject = new Method[]{};
            }
            annotationMethodCache.put(annotation, (Object)returnObject);
        }
        return returnObject;
    }

    private static void reportError(AgentInternalError error) {
        if (!reportAgentInternalError) {
            return;
        }
        javaAgentBootExtension.getBootServiceProvider().reportError(error);
    }

    private static void reportDetailedError(String detailedMessage, Throwable throwable) {
        if (!reportAgentInternalError) {
            return;
        }
        if (!enableReportingDetail) {
            return;
        }
        javaAgentBootExtension.getBootServiceProvider().reportDetailedError(new AgentInternalError("com.singularity.ReflectionError " + detailedMessage), throwable);
    }

    public static Object getValueFromField(Field field, Object obj) throws Exception {
        Class<?> clazz = obj == null ? field.getDeclaringClass() : obj.getClass();
        ReflectionUtility.getJava9Permission(clazz);
        return field.get(obj);
    }

    public static boolean isInstance(Class cls, Object obj) {
        return cls.isInstance(obj);
    }

    public static Object getAnnotationElementForClassWithDeepSearch(Class cls, String annotationName, String elementName) throws ReflectionException {
        Object returnVal;
        AdaptableConcurrentHashMap annotationValueMap = (AdaptableConcurrentHashMap)classAnnotationValueCache.get((Object)cls);
        if (annotationValueMap != null && annotationValueMap.containsKey((Object)annotationName)) {
            Object returnVal2 = annotationValueMap.get((Object)annotationName);
            return NULL_OBJECT_PLACEHOLDER.equals(returnVal2) ? null : returnVal2;
        }
        if (annotationValueMap == null) {
            annotationValueMap = new AdaptableConcurrentHashMap(AdaptableConcurrentHashMap.ReferenceType.WEAK, AdaptableConcurrentHashMap.ReferenceType.WEAK);
            classAnnotationValueCache.put((Object)cls, (Object)annotationValueMap);
        }
        Object valueToSave = (returnVal = ReflectionUtility.getAnnotationElementForClassWithDeepSearchInternal(cls, annotationName, elementName)) == null ? NULL_OBJECT_PLACEHOLDER : returnVal;
        annotationValueMap.put((Object)annotationName, valueToSave);
        return returnVal;
    }

    private static Object getAnnotationElementForClassWithDeepSearchInternal(Class cls, String annotationName, String elementName) throws ReflectionException {
        if (cls == null) {
            return null;
        }
        Object returnVal = ReflectionUtility.getAnnotationElement(cls, annotationName, elementName);
        if (returnVal != null) {
            return returnVal;
        }
        returnVal = ReflectionUtility.getAnnotationElementForClassWithDeepSearchInternal(cls.getSuperclass(), annotationName, elementName);
        if (returnVal != null) {
            return returnVal;
        }
        returnVal = ReflectionUtility.getAnnotationElementForInterfacesRecursively(cls.getInterfaces(), annotationName, elementName);
        if (returnVal != null) {
            return returnVal;
        }
        return returnVal;
    }

    private static Object getAnnotationElementForInterfacesRecursively(Class[] interfaces, String annotationName, String elementName) throws ReflectionException {
        if (interfaces == null) {
            return null;
        }
        Object returnVal = null;
        for (int i = 0; i < interfaces.length; ++i) {
            returnVal = ReflectionUtility.getAnnotationElementForInterfaceRecursively(interfaces[i], annotationName, elementName);
            if (returnVal == null) continue;
            return returnVal;
        }
        return returnVal;
    }

    private static Object getAnnotationElementForInterfaceRecursively(Class interfce, String annotationName, String elementName) throws ReflectionException {
        if (interfce == null) {
            return null;
        }
        Object returnVal = ReflectionUtility.getAnnotationElement(interfce, annotationName, elementName);
        if (returnVal != null) {
            return returnVal;
        }
        return ReflectionUtility.getAnnotationElementForInterfacesRecursively(interfce.getInterfaces(), annotationName, elementName);
    }

    public static Object getAnnotationElementForMethodWithDeepSearch(Method mthd, String annotationName, String elementName) throws ReflectionException {
        Object returnVal;
        AdaptableConcurrentHashMap annotationValueMap = (AdaptableConcurrentHashMap)methodAnnotationValueCache.get((Object)mthd);
        if (annotationValueMap != null && annotationValueMap.containsKey((Object)annotationName)) {
            Object returnVal2 = annotationValueMap.get((Object)annotationName);
            return NULL_OBJECT_PLACEHOLDER.equals(returnVal2) ? null : returnVal2;
        }
        if (annotationValueMap == null) {
            annotationValueMap = new AdaptableConcurrentHashMap(AdaptableConcurrentHashMap.ReferenceType.WEAK, AdaptableConcurrentHashMap.ReferenceType.WEAK);
            methodAnnotationValueCache.put((Object)mthd, (Object)annotationValueMap);
        }
        Object valueToSave = (returnVal = ReflectionUtility.getAnnotationElementForMethodWithDeepSearchInternal(mthd.getDeclaringClass(), mthd.getName(), mthd.getParameterTypes(), annotationName, elementName)) == null ? NULL_OBJECT_PLACEHOLDER : returnVal;
        annotationValueMap.put((Object)annotationName, valueToSave);
        return returnVal;
    }

    private static Object getAnnotationElementForMethodWithDeepSearchInternal(Class cls, String methodName, Class[] parameterTypes, String annotationName, String elementName) throws ReflectionException {
        Object returnVal;
        if (cls == null) {
            return null;
        }
        Method mthd = ReflectionUtility.getMethodFromClass(cls, methodName, parameterTypes);
        if (mthd != null && (returnVal = ReflectionUtility.getAnnotationElement(mthd, annotationName, elementName)) != null) {
            return returnVal;
        }
        returnVal = ReflectionUtility.getAnnotationElementForMethodWithDeepSearchInternal(cls.getSuperclass(), methodName, parameterTypes, annotationName, elementName);
        if (returnVal != null) {
            return returnVal;
        }
        returnVal = ReflectionUtility.getAnnotationElementForInterfaceMethodRecursively(cls.getInterfaces(), methodName, parameterTypes, annotationName, elementName);
        return returnVal;
    }

    public static Method getMethodFromClass(Class cls, String methodName, Class[] parameterTypes) throws ReflectionException {
        Method mthd;
        ReflectionUtility.getJava9Permission(cls);
        try {
            mthd = cls.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Exception e) {
            throw new ReflectionException("Unable to get Method(" + methodName + ") from class(" + cls.getName() + ")", (Throwable)e);
        }
        return mthd;
    }

    public static Method[] getMethodsFromClass(Class cls) throws ReflectionException {
        Method[] methods;
        ReflectionUtility.getJava9Permission(cls);
        try {
            methods = cls.getDeclaredMethods();
        }
        catch (Exception e) {
            throw new ReflectionException("Unable to get declared methods from class(" + cls.getName() + ")", (Throwable)e);
        }
        return methods;
    }

    private static Object getAnnotationElementForInterfaceMethodRecursively(Class[] interfaces, String methodName, Class[] parameterTypes, String annotationName, String elementName) throws ReflectionException {
        if (interfaces == null) {
            return null;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            Object returnVal = ReflectionUtility.getAnnotationElementForInterfaceMethodRecursively(interfaces[i], methodName, parameterTypes, annotationName, elementName);
            if (returnVal == null) continue;
            return returnVal;
        }
        return null;
    }

    private static Object getAnnotationElementForInterfaceMethodRecursively(Class interfce, String methodName, Class[] parameterTypes, String annotationName, String elementName) throws ReflectionException {
        Object returnVal;
        if (interfce == null) {
            return null;
        }
        Method mthd = ReflectionUtility.getMethodFromClass(interfce, methodName, parameterTypes);
        if (mthd != null && (returnVal = ReflectionUtility.getAnnotationElement(mthd, annotationName, elementName)) != null) {
            return returnVal;
        }
        return ReflectionUtility.getAnnotationElementForInterfaceMethodRecursively(interfce.getInterfaces(), methodName, parameterTypes, annotationName, elementName);
    }

    public static <A extends Annotation> A getSingleAnnotation(AnnotatedElement obj, Class<A> annotationClass) {
        return obj.getAnnotation(annotationClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method[] getPublicMethods(Object obj, IADLogger logger) {
        Method[] methods = null;
        try {
            Method method = Class.class.getDeclaredMethod("privateGetPublicMethods", new Class[0]);
            method.setAccessible(true);
            methods = (Method[])method.invoke(obj.getClass(), new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
            logger.info("Class.privateGetPublicMethods() is not available, will try the public methods");
        }
        catch (Exception e) {
            logger.error("Cannot get methods, will try the public methods", e);
        }
        finally {
            if (methods == null) {
                methods = obj.getClass().getMethods();
            }
        }
        return methods;
    }

    public static String getMethodName(Method method) {
        return method.getName();
    }

    public static Class[] getParameterTypes(Method method) {
        return method.getParameterTypes();
    }

    @NodePropertyListener(id="ReflectionUtility")
    public static class ReflectionUtilityNodeProperty {
        private static final ReflectionUtilityNodeProperty INSTANCE = new ReflectionUtilityNodeProperty();

        public static ReflectionUtilityNodeProperty getInstance() {
            return INSTANCE;
        }

        @NodeProperty(key="enable-stacktrace-on-reflection-exception", description="Enable reporting detail information and stacktrace for reflection exception", defaultValue="false")
        public static void enableReportDetailedError(boolean enabled) {
            enableReportingDetail = enabled;
            if (enabled) {
                ReflectionUtilityNodeProperty.cleanUpInvalidEntry(AgentReflectionUtility.fieldCache, AgentReflectionUtility.noSuchField);
                ReflectionUtilityNodeProperty.cleanUpInvalidEntry(AgentReflectionUtility.methodCache, AgentReflectionUtility.noSuchMethod);
            }
        }

        @NodeProperty(key="enable-agent-internal-error", description="Enable reporting agent Internal Error to controller", defaultValue="true")
        public static void enableAgentInternalError(boolean enabled) {
            reportAgentInternalError = enabled;
        }

        private static <C, K, V> void cleanUpInvalidEntry(ConcurrentMap<C, ConcurrentMap<K, V>> cache, V nonExistMark) {
            for (Map classFields : cache.values()) {
                Iterator fieldIterator = classFields.entrySet().iterator();
                while (fieldIterator.hasNext()) {
                    Map.Entry field = fieldIterator.next();
                    if (field.getValue() != nonExistMark) continue;
                    fieldIterator.remove();
                }
            }
        }
    }

    static class FieldLocation {
        Class matchedClass;
        String[] pathToReach;

        private FieldLocation(Class matchedClass, ArrayStack fldExpression) {
            this.matchedClass = matchedClass;
            this.pathToReach = new String[fldExpression.size()];
            int i = 0;
            for (Object o : fldExpression) {
                this.pathToReach[i++] = o.toString();
            }
        }
    }

    static class FindField {
        ArrayStack fldExpression = new ArrayStack();
        Set<Class> alreadySeenYou = new HashSet<Class>();
        private Object container;
        private Class assignableFrom;
        private String[] classNamesToMatch;
        Class matchedYou = null;

        FindField(Object container, Class assignableFrom, String[] classNamesToMatch) {
            this.container = container;
            this.assignableFrom = assignableFrom;
            this.classNamesToMatch = classNamesToMatch;
        }

        public void findContainedClassThatMatchesGivenClassNamesAndIsAssignableFrom() throws ClassNotFoundException {
            List<Field> declaredFields = ReflectionUtility.getDeclaredFields(this.container.getClass(), true);
            block0: for (Field fld : declaredFields) {
                Class<?> fldClass;
                if (Modifier.isStatic(fld.getModifiers()) || this.alreadySeenYou.contains(fldClass = fld.getDeclaringClass())) continue;
                this.alreadySeenYou.add(fldClass);
                if (!ReflectionUtility.isAssignableFrom(this.assignableFrom, fldClass)) continue;
                for (String classNameToMatch : this.classNamesToMatch) {
                    if (!fldClass.getClass().getName().equals(classNameToMatch)) continue;
                    this.fldExpression.push(fld.getName());
                    this.matchedYou = fldClass;
                    continue block0;
                }
            }
            if (this.matchedYou == null) {
                for (Field field : declaredFields) {
                    this.fldExpression.push(field.getName());
                    this.findContainedClassThatMatchesGivenClassNamesAndIsAssignableFrom();
                    if (this.matchedYou != null) break;
                    this.fldExpression.pop();
                }
            }
        }
    }

    private static class ArgTypes {
        final Class<?>[] argTypes;
        private final int hashValue;

        ArgTypes(Class<?>[] argTypes) {
            this.argTypes = ReflectionUtility.copyArgTypes(argTypes);
            int hashValue = 0;
            for (Class<?> nextType : this.argTypes) {
                hashValue ^= nextType.hashCode();
            }
            this.hashValue = hashValue;
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object o) {
            boolean bReturn;
            boolean bl = bReturn = this == o;
            if (!bReturn && o instanceof ArgTypes) {
                ArgTypes other = (ArgTypes)o;
                if (this.hashValue == other.hashValue && this.argTypes.length == other.argTypes.length) {
                    bReturn = true;
                    for (int i = 0; i < this.argTypes.length && bReturn; ++i) {
                        bReturn = this.argTypes[i] == other.argTypes[i];
                    }
                }
            }
            return bReturn;
        }
    }
}

