/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.rule.bci;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.InterceptorClassRegistryBoot;
import com.singularity.ee.agent.appagent.services.bciengine.custom.interceptors.BCIMatchRule;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.BCIRuleApplier;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.UnableToRetransformException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.appagent.services.transactionmonitor.common.boot.ATrackedMethodInterceptor;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.dtobootimpl.POJOMatchTypeBoot;
import com.singularity.ee.util.string.StringOperations;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public class ClassRuleApplier {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.ClassRuleApplier");
    private static final String DELIM = ",";
    private final BCIRuleApplier bciRuleApplier;
    private final Map<String, String> classNameMap;
    private final Class interceptor;

    public ClassRuleApplier(IBCIEngineService bciEngine, Class<? extends ATrackedMethodInterceptor> interceptor) {
        this.interceptor = interceptor;
        this.classNameMap = new ConcurrentHashMap<String, String>();
        this.bciRuleApplier = new BCIRuleApplier(logger, bciEngine);
        InterceptorClassRegistryBoot.bindClass((String)interceptor.getName(), interceptor);
    }

    public void applyRules(String clsNameStr) throws UnableToRetransformException {
        this.parseClassNamesString(clsNameStr);
        this.applyBCIRules();
        logger.info("Finished applying new rule set for " + this.classNameMap.keySet());
    }

    private void parseClassNamesString(String clsNameStr) {
        this.classNameMap.clear();
        if (StringOperations.isEmpty((String)clsNameStr)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(clsNameStr, DELIM);
        while (st.hasMoreTokens()) {
            String className = st.nextToken().trim();
            if (className.length() == 0) continue;
            this.classNameMap.put(className, className);
        }
    }

    private void applyBCIRules() throws UnableToRetransformException {
        this.bciRuleApplier.startApplyingNewSet();
        for (String clsAndMethodName : this.classNameMap.keySet()) {
            String className = this.classNameMap.get(clsAndMethodName);
            BCIMatchRule bciMatchRule = new BCIMatchRule(POJOMatchTypeBoot.MATCHES_CLASS, className, "<init>", this.interceptor);
            this.bciRuleApplier.applyInterceptor(bciMatchRule);
        }
        this.bciRuleApplier.finishApplyingNewSet();
    }
}

