/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.rule.bci;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.InterceptorClassRegistryBoot;
import com.singularity.ee.agent.appagent.services.bciengine.custom.interceptors.BCIMatchRule;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.BCIRuleApplier;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.UnableToRetransformException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.appagent.services.transactionmonitor.common.boot.ATrackedMethodInterceptor;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.dtobootimpl.POJOMatchTypeBoot;
import com.singularity.ee.util.string.StringOperations;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public class MethodRuleApplier {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.MethodRuleApplier");
    private static final char CLASS_METHOD_DELIM = '#';
    private static final String DELIM = ",";
    private final BCIRuleApplier bciRuleApplier;
    private final Map<String, ClassAndMethodName> classNameMap;
    private final Class interceptor;

    public MethodRuleApplier(IBCIEngineService bciEngine, Class<? extends ATrackedMethodInterceptor> interceptor) {
        this.interceptor = interceptor;
        this.classNameMap = new ConcurrentHashMap<String, ClassAndMethodName>();
        this.bciRuleApplier = new BCIRuleApplier(logger, bciEngine);
        InterceptorClassRegistryBoot.bindClass((String)interceptor.getName(), interceptor);
    }

    public void applyRules(String clsNameStr) throws UnableToRetransformException {
        this.parseClassNamesString(clsNameStr);
        this.applyBCIRules();
        logger.info("Finished applying new rule set for " + this.classNameMap);
    }

    private void parseClassNamesString(String clsNameStr) {
        this.classNameMap.clear();
        if (StringOperations.isEmpty((String)clsNameStr)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(clsNameStr, DELIM);
        while (st.hasMoreTokens()) {
            String clsAndMethodName = st.nextToken().trim();
            if (clsAndMethodName.length() == 0) continue;
            int inx = clsAndMethodName.indexOf(35);
            if (inx == -1) {
                logger.warn("Class method definitions to track memory must include both class and method name separated by #, the following doesn't :" + clsAndMethodName);
                continue;
            }
            String clsName = clsAndMethodName.substring(0, inx);
            String methodName = clsAndMethodName.substring(inx + 1, clsAndMethodName.length());
            this.classNameMap.put(clsAndMethodName, new ClassAndMethodName(clsName, methodName));
        }
    }

    private void applyBCIRules() throws UnableToRetransformException {
        this.bciRuleApplier.startApplyingNewSet();
        for (String clsAndMethodName : this.classNameMap.keySet()) {
            ClassAndMethodName name = this.classNameMap.get(clsAndMethodName);
            BCIMatchRule bciMatchRule = new BCIMatchRule(POJOMatchTypeBoot.MATCHES_CLASS, name.className, name.methodName, this.interceptor);
            this.bciRuleApplier.applyInterceptor(bciMatchRule);
        }
        this.bciRuleApplier.finishApplyingNewSet();
    }

    class ClassAndMethodName {
        String className;
        String methodName;

        public ClassAndMethodName(String clsName, String methodName) {
            this.className = clsName;
            this.methodName = methodName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" ");
            sb.append("[className='").append(this.className).append('\'');
            sb.append(", methodName='").append(this.methodName).append('\'');
            sb.append(']');
            return sb.toString();
        }
    }
}

