/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.rule.reflect;

import com.singularity.ee.agent.appagent.kernel.boot.IJavaAgentBootExtension;
import com.singularity.ee.agent.appagent.kernel.boot.JavaAgentBootExtension;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.appagent.services.objectmonitor.config.boot.ObjectMonitoringServiceConfig;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.reflect.ReflectionException;
import com.singularity.ee.agent.util.reflect.ReflectionUtility;
import com.singularity.ee.agent.util.rule.reflect.IFieldListener;
import com.singularity.ee.util.collections.AdaptableConcurrentHashMap;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.string.StringOperations;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;

public class FieldReflector
implements IAgentRunnable {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.diagnostics.FieldReflector");
    private static final int INTERVAL = 60;
    public static final char CLASS_FIELD_DELIMITER = '#';
    public static final String DELIMITER = ",";
    private final Set<ClassAndFieldName> fieldNames;
    private final Map<ClassAndFieldName, WeakReference> fieldNameToObjectMap;
    private final IBCIEngineService bciEngine;
    private final IFieldListener fieldListener;
    private final AdaptableConcurrentHashMap<String, Class> classCache;
    private final AdaptableConcurrentHashMap<String, Class> toBeLoadedClass;
    private final Set<ClassAndFieldName> toBeInitFields;
    private static final IJavaAgentBootExtension javaAgentBootExtension = JavaAgentBootExtension.getInstance();
    private AtomicBoolean isModified;
    private volatile boolean disabled = false;

    public FieldReflector(IBCIEngineService bciEngineService, IAgentScheduledExecutorService scheduler, IFieldListener fieldListener) {
        this.bciEngine = bciEngineService;
        this.fieldListener = fieldListener;
        this.fieldNames = new HashSet<ClassAndFieldName>();
        this.fieldNameToObjectMap = new HashMap<ClassAndFieldName, WeakReference>();
        this.toBeInitFields = new HashSet<ClassAndFieldName>();
        this.classCache = new AdaptableConcurrentHashMap(AdaptableConcurrentHashMap.ReferenceType.WEAK, AdaptableConcurrentHashMap.ReferenceType.WEAK);
        this.toBeLoadedClass = new AdaptableConcurrentHashMap(AdaptableConcurrentHashMap.ReferenceType.WEAK, AdaptableConcurrentHashMap.ReferenceType.WEAK);
        this.isModified = new AtomicBoolean(true);
        scheduler.scheduleWithFixedDelay(this, 60L, 60L, AgentTimeUnit.SECONDS);
    }

    public void setFieldNames(String fieldsToCapture) {
        if (StringOperations.isEmpty((String)fieldsToCapture)) {
            return;
        }
        this.fieldNames.clear();
        StringTokenizer st = new StringTokenizer(fieldsToCapture, DELIMITER);
        while (st.hasMoreTokens()) {
            String clsAndFieldName = st.nextToken().trim();
            if (clsAndFieldName.length() == 0) continue;
            int inx = clsAndFieldName.indexOf(35);
            if (inx == -1) {
                logger.warn("Class field definitions to track memory must include both class and field name separated by #, the following doesn't :" + clsAndFieldName);
                continue;
            }
            String clsName = clsAndFieldName.substring(0, inx);
            String fieldName = clsAndFieldName.substring(inx + 1, clsAndFieldName.length());
            if (StringOperations.isEmpty((String)clsName) || StringOperations.isEmpty((String)fieldName)) {
                logger.warn("Class Name [" + clsName + "] or static field Name[" + fieldName + "] can't be empty");
                continue;
            }
            this.fieldNames.add(new ClassAndFieldName(clsName, fieldName));
        }
        if (this.fieldNames.size() > 0) {
            this.isModified.set(true);
        }
        logger.info("Memory tracking fields to capture set to " + this.fieldNames);
    }

    public void hotDisable() {
        this.disabled = true;
        this.fieldNames.clear();
        this.fieldNameToObjectMap.clear();
        this.classCache.clear();
        this.toBeInitFields.clear();
        this.toBeLoadedClass.clear();
    }

    public void hotEnable() {
        this.disabled = false;
    }

    public void run() {
        try {
            if (this.disabled || !ObjectMonitoringServiceConfig.isObjectSizeMonitoringEnabled()) {
                return;
            }
            if (javaAgentBootExtension.isInPreMain()) {
                return;
            }
            this.checkIfObjectWasGC();
            if (this.isModified.get()) {
                this.isModified.set(false);
                logger.info("New fields were set, will reload class cache map " + this.fieldNames);
                this.populateClassCache();
                this.processFields();
            } else {
                this.processPendingInitFieldsIfAny();
                this.loadPendingClassesIfAny();
            }
        }
        catch (Throwable t) {
            logger.error("Error in processing class static fields " + this.fieldNames, t);
        }
    }

    private void checkIfObjectWasGC() {
        for (ClassAndFieldName name : this.fieldNameToObjectMap.keySet()) {
            if (this.fieldNameToObjectMap.get(name).get() != null) continue;
            this.toBeInitFields.add(name);
            logger.info("Field object for " + name + " was garbage collected adding to pending init field list");
        }
    }

    private void populateClassCache() {
        this.classCache.clear();
        for (ClassAndFieldName name : this.fieldNames) {
            this.classCache.put((Object)name.className, NoClassFound.class);
        }
        if (this.bciEngine != null && this.classCache.size() > 0) {
            this.bciEngine.getClassObjects((Map<String, Class>)this.classCache);
            logger.info("Populated class cache with " + this.classCache);
        } else if (this.classCache.size() > 0) {
            logger.info("BCIEngine not initialized yet");
        }
    }

    private void processFields() {
        for (ClassAndFieldName name : this.fieldNames) {
            logger.info("Processing field " + name);
            Class clazz = (Class)this.classCache.get((Object)name.className);
            if (clazz == null || clazz == NoClassFound.class) {
                logger.info("Class Object not found for " + name.className + " will retry after " + 60);
                this.toBeLoadedClass.put((Object)name.className, null);
                continue;
            }
            try {
                Object field = ReflectionUtility.getFieldFromSpecifiedClass(clazz, null, name.fieldName);
                if (field != null) {
                    logger.info("Adding field " + field.getClass().getName() + " from " + name);
                    this.fieldListener.setFieldValue(field, name.className, name.fieldName);
                    this.fieldNameToObjectMap.put(name, new WeakReference<Object>(field));
                    continue;
                }
                this.toBeInitFields.add(name);
                logger.info("Field " + name + " is not initialized yet, will try after " + 60 + " seconds.");
            }
            catch (ReflectionException e) {
                logger.error("Error in getting static " + name.fieldName + " from class " + name.className + ", error :" + (Object)((Object)e));
            }
        }
    }

    private void loadPendingClassesIfAny() {
        if (this.toBeLoadedClass.isEmpty()) {
            return;
        }
        this.bciEngine.getClassObjects((Map<String, Class>)this.toBeLoadedClass);
        this.classCache.putAll(this.toBeLoadedClass);
        this.toBeLoadedClass.clear();
        this.processFields();
    }

    private void processPendingInitFieldsIfAny() {
        if (this.toBeInitFields.isEmpty()) {
            return;
        }
        HashSet<ClassAndFieldName> pendingInitFieldsCopy = new HashSet<ClassAndFieldName>(this.toBeInitFields);
        for (ClassAndFieldName name : pendingInitFieldsCopy) {
            try {
                Class clazz = (Class)this.classCache.get((Object)name.className);
                if (clazz == null || clazz == NoClassFound.class) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Class Object was probably Garbage Collected for " + name);
                    }
                    this.toBeInitFields.remove(name);
                    this.toBeLoadedClass.put((Object)name.className, NoClassFound.class);
                    continue;
                }
                Object field = ReflectionUtility.getFieldFromSpecifiedClass(clazz, null, name.fieldName);
                if (field != null) {
                    logger.info("On retry adding field " + field + " from " + name);
                    this.fieldListener.setFieldValue(field, name.className, name.fieldName);
                    this.fieldNameToObjectMap.put(name, new WeakReference<Object>(field));
                    this.toBeInitFields.remove(name);
                    continue;
                }
                logger.info("Field " + name + " is yet to be  initialized yet, will try after " + 60 + " seconds.");
            }
            catch (ReflectionException e) {
                logger.error("Error in getting static " + name.fieldName + " from class " + name.className + ", error :" + (Object)((Object)e));
            }
        }
    }

    private static class NoClassFound {
        private NoClassFound() {
        }
    }

    private static class ClassAndFieldName {
        final String className;
        final String fieldName;

        public ClassAndFieldName(String clsName, String fieldName) {
            this.className = clsName;
            this.fieldName = fieldName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" ");
            sb.append("[className='").append(this.className).append('\'');
            sb.append(", static fieldName='").append(this.fieldName).append('\'');
            sb.append(']');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassAndFieldName that = (ClassAndFieldName)o;
            if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
                return false;
            }
            return !(this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null);
        }

        public int hashCode() {
            int result = this.className != null ? this.className.hashCode() : 0;
            result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
            return result;
        }
    }
}

