/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.strset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class ATrie {
    private static final ImmutableTrieNode[] EMPTY = new ImmutableTrieNode[0];
    final ImmutableTrieNode root;

    ATrie(String[] strings) {
        MutableTrieNode tempRoot = new MutableTrieNode('\u0000');
        for (String string : strings) {
            if (string.length() == 0) {
                tempRoot.isEndOfString = true;
                continue;
            }
            tempRoot.add(string);
        }
        this.root = tempRoot.getImmutableTrieNode();
    }

    ATrie(Collection<String> strings) {
        MutableTrieNode tempRoot = new MutableTrieNode('\u0000');
        for (String string : strings) {
            if (string.length() == 0) {
                tempRoot.isEndOfString = true;
                continue;
            }
            tempRoot.add(string);
        }
        this.root = tempRoot.getImmutableTrieNode();
    }

    private static class MutableTrieNode {
        public final char content;
        public final List<MutableTrieNode> children = new ArrayList<MutableTrieNode>(2);
        public boolean isEndOfString = false;

        public MutableTrieNode(char content) {
            this.content = content;
        }

        public void add(String string) {
            MutableTrieNode node = this;
            for (int index = 0; index < string.length(); ++index) {
                char key = string.charAt(index);
                MutableTrieNode child = null;
                int len = node.children.size();
                for (int i = 0; i < len; ++i) {
                    MutableTrieNode n = node.children.get(i);
                    if (n.content != key) continue;
                    child = n;
                    break;
                }
                if (child == null) {
                    child = new MutableTrieNode(key);
                    node.children.add(child);
                }
                node = child;
            }
            node.isEndOfString = true;
        }

        public ImmutableTrieNode getImmutableTrieNode() {
            if (this.children.isEmpty()) {
                return new ImmutableTrieNode(this.content, EMPTY, this.isEndOfString);
            }
            Collections.sort(this.children, new Comparator<MutableTrieNode>(){

                @Override
                public int compare(MutableTrieNode o1, MutableTrieNode o2) {
                    return o1.content - o2.content;
                }
            });
            ImmutableTrieNode[] nodes = new ImmutableTrieNode[this.children.size()];
            int len = this.children.size();
            for (int i = 0; i < len; ++i) {
                nodes[i] = this.children.get(i).getImmutableTrieNode();
            }
            return new ImmutableTrieNode(this.content, nodes, this.isEndOfString);
        }
    }

    static class ImmutableTrieNode {
        final char content;
        final ImmutableTrieNode[] sortedChildren;
        final boolean isEndOfString;

        ImmutableTrieNode(char content, ImmutableTrieNode[] sortedChildren, boolean isEndOfString) {
            this.content = content;
            this.sortedChildren = sortedChildren;
            this.isEndOfString = isEndOfString;
        }
    }
}

