/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.strset;

import com.singularity.ee.agent.util.strset.PrefixStringSet;
import com.singularity.ee.agent.util.strset.SuffixStringSet;
import com.singularity.ee.agent.util.strset.TriePrefixStringSet;
import com.singularity.ee.agent.util.strset.TrieSuffixStringSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;

public class LinearStringSet
implements PrefixStringSet,
SuffixStringSet {
    private final String[] contents;
    private final int length;
    private static final char[] alphabets = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] digits = "0123456789".toCharArray();
    private static final Random random = new Random();

    public LinearStringSet(Collection<String> strings) {
        this.length = strings.size();
        this.contents = strings.toArray(new String[0]);
    }

    public LinearStringSet(String[] strings) {
        this.length = strings.length;
        this.contents = new String[this.length];
        System.arraycopy(strings, 0, this.contents, 0, this.length);
    }

    @Override
    public boolean contains(String key) {
        for (int i = 0; i < this.length; ++i) {
            if (!key.equals(this.contents[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsPrefixOf(String key) {
        for (int i = 0; i < this.length; ++i) {
            if (!key.startsWith(this.contents[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsSuffixOf(String key) {
        for (int i = 0; i < this.length; ++i) {
            if (!key.endsWith(this.contents[i])) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        boolean actual;
        boolean expected;
        int i;
        String[] contents = new String[1000];
        int mid = contents.length / 2;
        for (i = 0; i < mid; ++i) {
            contents[i] = LinearStringSet.randomString(random.nextInt(20) + 1, alphabets);
        }
        for (i = mid; i < contents.length; ++i) {
            String s = contents[random.nextInt(mid)];
            contents[i] = s.length() == 1 ? s : s.substring(0, random.nextInt(s.length() - 1) + 1);
        }
        Collections.shuffle(Arrays.asList(contents));
        String[] keys = new String[5000];
        block8: for (int i2 = 0; i2 < keys.length; ++i2) {
            switch (random.nextInt(4)) {
                case 0: {
                    keys[i2] = contents[random.nextInt(contents.length)];
                    continue block8;
                }
                case 1: {
                    keys[i2] = contents[random.nextInt(contents.length)] + LinearStringSet.randomString(10, digits);
                    continue block8;
                }
                case 2: {
                    keys[i2] = LinearStringSet.randomString(10, digits) + contents[random.nextInt(contents.length)];
                    continue block8;
                }
                case 3: {
                    keys[i2] = LinearStringSet.randomString(100, digits);
                }
            }
        }
        LinearStringSet model = new LinearStringSet(contents);
        TriePrefixStringSet prefixStringSet = new TriePrefixStringSet(contents);
        TrieSuffixStringSet suffixStringSet = new TrieSuffixStringSet(contents);
        boolean passed = true;
        for (String key : keys) {
            expected = model.contains(key);
            if (expected == (actual = prefixStringSet.contains(key))) continue;
            System.out.println(prefixStringSet.getClass().getSimpleName() + " failed on contains for key [" + key + "] expected [" + expected + "] actual [" + actual + "]");
            passed = false;
        }
        for (String key : keys) {
            expected = model.containsPrefixOf(key);
            if (expected == (actual = prefixStringSet.containsPrefixOf(key))) continue;
            System.out.println(prefixStringSet.getClass().getSimpleName() + " failed on containsPrefixOf for key [" + key + "] expected [" + expected + "] actual [" + actual + "]");
            passed = false;
        }
        for (String key : keys) {
            expected = model.contains(key);
            if (expected == (actual = suffixStringSet.contains(key))) continue;
            System.out.println(suffixStringSet.getClass().getSimpleName() + " failed on contains for key [" + key + "] expected [" + expected + "] actual [" + actual + "]");
            passed = false;
        }
        for (String key : keys) {
            expected = model.containsSuffixOf(key);
            if (expected == (actual = suffixStringSet.containsSuffixOf(key))) continue;
            System.out.println(suffixStringSet.getClass().getSimpleName() + " failed on containsSuffixOf for key [" + key + "] expected [" + expected + "] actual [" + actual + "]");
            passed = false;
        }
        if (!passed) {
            System.out.println("The content strings were: ");
            for (String content : contents) {
                System.out.println(content);
            }
            System.out.println("");
        } else {
            System.out.println("All tests passed!");
        }
    }

    private static String randomString(int length, char[] symbols) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(symbols[random.nextInt(symbols.length)]);
        }
        return sb.toString();
    }
}

