/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.strset;

import com.singularity.ee.agent.util.strset.ATrie;
import com.singularity.ee.agent.util.strset.PrefixStringSet;
import java.util.Collection;

public class TriePrefixStringSet
extends ATrie
implements PrefixStringSet {
    public TriePrefixStringSet(String[] strings) {
        super(strings);
    }

    public TriePrefixStringSet(Collection<String> strings) {
        super(strings);
    }

    @Override
    public boolean contains(String key) {
        int sLength = key.length();
        ATrie.ImmutableTrieNode node = this.root;
        block0: for (int index = 0; index < sLength; ++index) {
            char keyChar = key.charAt(index);
            int low = 0;
            int high = node.sortedChildren.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                char midVal = node.sortedChildren[mid].content;
                if (midVal < keyChar) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > keyChar) {
                    high = mid - 1;
                    continue;
                }
                node = node.sortedChildren[mid];
                continue block0;
            }
            return false;
        }
        return node.isEndOfString;
    }

    @Override
    public boolean containsPrefixOf(String key) {
        int sLength = key.length();
        ATrie.ImmutableTrieNode node = this.root;
        block0: for (int index = 0; index < sLength; ++index) {
            if (node.isEndOfString) {
                return true;
            }
            char keyChar = key.charAt(index);
            int low = 0;
            int high = node.sortedChildren.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                char midVal = node.sortedChildren[mid].content;
                if (midVal < keyChar) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > keyChar) {
                    high = mid - 1;
                    continue;
                }
                node = node.sortedChildren[mid];
                continue block0;
            }
            return false;
        }
        return node.isEndOfString;
    }
}

