/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.strset;

import com.singularity.ee.agent.util.strset.ATrie;
import com.singularity.ee.agent.util.strset.SuffixStringSet;
import java.util.Collection;

public class TrieSuffixStringSet
extends ATrie
implements SuffixStringSet {
    TrieSuffixStringSet(String[] strings) {
        super(TrieSuffixStringSet.reverse(strings));
    }

    TrieSuffixStringSet(Collection<String> strings) {
        super(TrieSuffixStringSet.reverse(strings));
    }

    @Override
    public boolean containsSuffixOf(String key) {
        ATrie.ImmutableTrieNode node = this.root;
        block0: for (int index = key.length() - 1; index >= 0; --index) {
            if (node.isEndOfString) {
                return true;
            }
            char keyChar = key.charAt(index);
            int low = 0;
            int high = node.sortedChildren.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                char midVal = node.sortedChildren[mid].content;
                if (midVal < keyChar) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > keyChar) {
                    high = mid - 1;
                    continue;
                }
                node = node.sortedChildren[mid];
                continue block0;
            }
            return false;
        }
        return node.isEndOfString;
    }

    @Override
    public boolean contains(String key) {
        ATrie.ImmutableTrieNode node = this.root;
        block0: for (int index = key.length() - 1; index >= 0; --index) {
            char keyChar = key.charAt(index);
            int low = 0;
            int high = node.sortedChildren.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                char midVal = node.sortedChildren[mid].content;
                if (midVal < keyChar) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > keyChar) {
                    high = mid - 1;
                    continue;
                }
                node = node.sortedChildren[mid];
                continue block0;
            }
            return false;
        }
        return node.isEndOfString;
    }

    private static String[] reverse(String[] strings) {
        String[] reversed = new String[strings.length];
        int len = strings.length;
        for (int i = 0; i < len; ++i) {
            StringBuilder sb = new StringBuilder(strings[i]);
            reversed[i] = sb.reverse().toString();
        }
        return reversed;
    }

    private static String[] reverse(Collection<String> strings) {
        String[] reversed = new String[strings.size()];
        int i = 0;
        for (String string : strings) {
            StringBuilder sb = new StringBuilder(string);
            reversed[i++] = sb.reverse().toString();
        }
        return reversed;
    }
}

