/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.version.determiner;

import com.appdynamics.org.apache.commons.io.DirectoryWalker;
import com.appdynamics.org.apache.commons.io.filefilter.FileFilterUtils;
import com.appdynamics.org.apache.commons.io.filefilter.IOFileFilter;
import com.singularity.ee.agent.appagent.kernel.config.acnp.NodeProperty;
import com.singularity.ee.agent.appagent.kernel.config.acnp.NodePropertyListener;
import com.singularity.ee.agent.appagent.kernel.spi.IConfigManager;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.reflect.AgentReflectionUtility;
import com.singularity.ee.agent.util.reflect.ReflectionException;
import com.singularity.ee.util.system.SystemUtils;
import dagger.CustomImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@CustomImpl
@NodePropertyListener(id="TomcatVersionDeterminer")
public class TomcatVersionDeterminer {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.kernel.TomcatVersionDeterminer");
    private static final int TOMCAT_VER8 = 8;
    private static final String SERVER_NUMBER_PROP_NAME = "server.number";
    private static final String CATALINA_BASE_PROP_NAME = "catalina.base";
    private static final String CATALINA_JAR_FILE_NAME = "catalina.jar";
    private static final String SERVER_INFO_FILE_NAME = "org/apache/catalina/util/ServerInfo.properties";
    private static final String APP_SERVER_VERSION_UNKNOWN = "App Server Version Unknown";
    private static final int DEFAULT_TOMCAT_CATALINA_SEARCH_DEPTH = 10;
    private static final String TOMCAT_CATALINA_SEARCH_DEPTH = "max-tomcat-catalina-search-depth";
    protected String appServerVersion;
    private Version tomcatVersion;
    private int tomcatCatalinaSearchDepth = 10;

    @Inject
    public TomcatVersionDeterminer(IConfigManager configManager) {
        configManager.registerConfigPropertyChangeListener(this);
    }

    public String getVersion() {
        if (this.appServerVersion == null) {
            this.appServerVersion = APP_SERVER_VERSION_UNKNOWN;
            String catalinaBaseProp = SystemUtils.getProperty((String)CATALINA_BASE_PROP_NAME);
            if (catalinaBaseProp != null) {
                try {
                    ZipFile catalinaZip;
                    ZipEntry catalinaPropertiesZipEntry;
                    File catalinaJar = this.locateFile(CATALINA_JAR_FILE_NAME, new File(catalinaBaseProp));
                    if (catalinaJar != null && catalinaJar.exists() && !catalinaJar.isDirectory() && (catalinaPropertiesZipEntry = (catalinaZip = new ZipFile(catalinaJar)).getEntry(SERVER_INFO_FILE_NAME)) != null) {
                        InputStream is = catalinaZip.getInputStream(catalinaPropertiesZipEntry);
                        Properties props = new Properties();
                        props.load(is);
                        is.close();
                        String serverNumber = props.getProperty(SERVER_NUMBER_PROP_NAME);
                        if (serverNumber != null) {
                            this.appServerVersion = serverNumber;
                        }
                    }
                }
                catch (IOException e) {
                    logger.error(String.format("%s caught attempting to determine Tomcat version", e.toString()));
                }
            }
        }
        return this.appServerVersion;
    }

    public boolean isTomcatClassLoaderStarted(ClassLoader loader) {
        try {
            if (this.tomcatVersion == null) {
                String tomcatVersionString = this.getVersion();
                if (APP_SERVER_VERSION_UNKNOWN.equals(tomcatVersionString)) {
                    this.tomcatVersion = Version.UNKNOWN;
                } else if (tomcatVersionString != null) {
                    this.tomcatVersion = this.parseTomcatVersionString(tomcatVersionString);
                }
            }
            if (this.tomcatVersion.equals((Object)Version.VERSION_8_OR_ABOVE)) {
                return this.extractStartedStateTomcat8(loader);
            }
            if (this.tomcatVersion.equals((Object)Version.VERSION_LESS_THAN_8)) {
                return this.extractStartedStateTomcat7(loader);
            }
            if (this.tomcatVersion.equals((Object)Version.UNKNOWN)) {
                return this.extractStartedStateTomcatUnknown(loader);
            }
        }
        catch (ReflectionException e) {
            return true;
        }
        return true;
    }

    private Version parseTomcatVersionString(String versionString) {
        String tomcatVersionString = versionString.trim();
        int indexOfDelim = tomcatVersionString.indexOf(46);
        if (indexOfDelim < 0) {
            return Version.UNKNOWN;
        }
        String majorVersion = tomcatVersionString.substring(0, indexOfDelim);
        try {
            int iMajorVersion = Integer.parseInt(majorVersion);
            return 8 <= iMajorVersion ? Version.VERSION_8_OR_ABOVE : Version.VERSION_LESS_THAN_8;
        }
        catch (NumberFormatException e) {
            logger.error(String.format("Invalid Tomcat version value: %s", tomcatVersionString));
            return Version.UNKNOWN;
        }
    }

    private boolean extractStartedStateTomcat8(ClassLoader classLoader) throws ReflectionException {
        String stateAsString;
        Object state = AgentReflectionUtility.invokeSimpleGetterWithoutReporting(classLoader, "getState");
        if (state != null && (stateAsString = (String)AgentReflectionUtility.invokeSimpleGetterWithoutReporting(state, "name")) != null) {
            return stateAsString.equals("STARTED");
        }
        return true;
    }

    private boolean extractStartedStateTomcat7(ClassLoader classLoader) throws ReflectionException {
        Boolean isStarted = (Boolean)AgentReflectionUtility.getFieldWithoutReporting(classLoader, "started", true);
        return isStarted != null && isStarted != false;
    }

    private boolean extractStartedStateTomcatUnknown(ClassLoader classLoader) throws ReflectionException {
        try {
            return this.extractStartedStateTomcat7(classLoader);
        }
        catch (ReflectionException e) {
            return this.extractStartedStateTomcat8(classLoader);
        }
    }

    private File locateFile(String simpleFileName, File mainDirectory) throws IOException {
        IOFileFilter fileFilter;
        IOFileFilter dirFilter = FileFilterUtils.directoryFileFilter();
        TomcatDirectoryWalker directoryWalker = new TomcatDirectoryWalker(dirFilter, fileFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.fileFileFilter(), FileFilterUtils.nameFileFilter((String)simpleFileName)}), mainDirectory);
        Collection<File> foundFiles = directoryWalker.getFoundFiles();
        if (foundFiles != null && foundFiles.size() > 0) {
            return foundFiles.iterator().next();
        }
        return null;
    }

    @NodeProperty(key="max-tomcat-catalina-search-depth", description="Depth for catalina.jar search in directory.", defaultValue="10")
    public void setTomcatCatalinaSearchDepth(int tomcatCatalinaSearchDepth) {
        this.tomcatCatalinaSearchDepth = tomcatCatalinaSearchDepth;
        logger.info("Updating tomcat catalina search depth to " + tomcatCatalinaSearchDepth);
    }

    private class TomcatDirectoryWalker
    extends DirectoryWalker<File> {
        private final Collection<File> foundFiles;

        TomcatDirectoryWalker(IOFileFilter dirFilter, IOFileFilter fileFilter, File startDirectory) throws IOException {
            block2: {
                super(dirFilter, fileFilter, TomcatVersionDeterminer.this.tomcatCatalinaSearchDepth);
                this.foundFiles = new ArrayList<File>();
                try {
                    this.walk(startDirectory, this.foundFiles);
                }
                catch (DirectoryWalker.CancelException e) {
                    if (!logger.isDebugEnabled()) break block2;
                    logger.debug(String.format("\"%s\" caught in TomcatDirectoryWalker constructor", e.toString()), e);
                }
            }
        }

        protected void handleFile(File file, int depth, Collection<File> foundFiles) throws DirectoryWalker.CancelException {
            foundFiles.add(file);
            throw new DirectoryWalker.CancelException("Found the file", file, depth);
        }

        Collection<File> getFoundFiles() {
            return this.foundFiles;
        }
    }

    private static enum Version {
        VERSION_LESS_THAN_8,
        VERSION_8_OR_ABOVE,
        UNKNOWN;

    }
}

