/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.boot.math;

import com.appdynamics.org.apache.commons.math.stat.regression.SimpleRegression;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.logging.SysOutLogger;
import java.util.Random;

public class GrowthFactorCalculator {
    private final int warmupPeriod;
    private SimpleRegression regressionModel = new SimpleRegression();
    private volatile int warmupCount;
    private ILogger iLogger;
    private String objectName;

    public GrowthFactorCalculator(String name, int warmUpPeriod, ILogger iLogger) {
        this.warmupPeriod = warmUpPeriod;
        this.iLogger = iLogger;
        this.objectName = name;
    }

    public String getObjectName() {
        return this.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(long timestamp, long dataPoint) {
        if (dataPoint < 0L) {
            return;
        }
        if (this.warmupCount < this.warmupPeriod) {
            ++this.warmupCount;
            return;
        }
        GrowthFactorCalculator growthFactorCalculator = this;
        synchronized (growthFactorCalculator) {
            this.regressionModel.addData((double)timestamp, (double)dataPoint);
        }
        if (this.iLogger.isDebugEnabled()) {
            this.iLogger.debug("Add data :: for objectName [" + this.objectName + "], at time=" + timestamp + ", data=" + dataPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGrowthFactor() {
        long numberOfObservations;
        double rSquared;
        double slope;
        GrowthFactorCalculator growthFactorCalculator = this;
        synchronized (growthFactorCalculator) {
            slope = this.regressionModel.getSlope();
            rSquared = this.regressionModel.getRSquare();
            numberOfObservations = this.regressionModel.getN();
        }
        if (this.iLogger.isDebugEnabled()) {
            this.iLogger.debug("Get Growth Factor :: for objectName [" + this.objectName + "] numberOfObservations=" + numberOfObservations + ", slope=" + slope + ", rSquared=" + rSquared);
        }
        if (numberOfObservations > 15L && slope > 0.0 && rSquared >= 0.27) {
            if (this.iLogger.isDebugEnabled()) {
                this.iLogger.debug("Get Growth Factor :: for objectName [" + this.objectName + "] returning slope=" + Math.round(slope * 10000.0));
            }
            return Math.round(slope * 10000.0);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        GrowthFactorCalculator growthFactorCalculator = this;
        synchronized (growthFactorCalculator) {
            this.regressionModel.clear();
        }
    }

    public static void main(String[] args) {
        GrowthFactorCalculator.test(0, "Test1");
        GrowthFactorCalculator.test(100, "Test2");
        GrowthFactorCalculator.test(1000, "Test3");
    }

    private static void test(int leakRange, String testId) {
        System.out.println("##################################################################################");
        System.out.println("##################################################################################");
        System.out.println("##################################################################################");
        GrowthFactorCalculator calc = new GrowthFactorCalculator("Stand Alone", 0, (ILogger)new SysOutLogger("Stand Alone"));
        int baseRange = 10000;
        int maxN = 1000;
        long timestamp = ClockUtils.getCurrentTime();
        Random baseRandom = new Random();
        Random leakRandom = new Random();
        int accumulatedLeak = 0;
        for (int i = 0; i < maxN; ++i) {
            int datapoint = baseRandom.nextInt(baseRange) + (accumulatedLeak += leakRange == 0 ? 0 : leakRandom.nextInt(leakRange));
            calc.addData(timestamp += 60000L, datapoint);
            System.out.println(testId + ">> " + i + ": Size=" + datapoint + " Calculated Growth Factor=" + calc.getGrowthFactor());
        }
        System.out.println("##################################################################################");
        System.out.println("##################################################################################");
        System.out.println("##################################################################################");
    }
}

