/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.collections;

import com.singularity.ee.util.collections.ArrayUtils;
import com.singularity.ee.util.reflect.ReflectionUtilityCommon;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Enumeration;

public class ArrayUtilsHelper {
    public static final String INT_ARRAY = "[I";
    public static final String FLOAT_ARRAY = "[F";
    public static final String BOOLEAN_ARRAY = "[Z";
    public static final String CHAR_ARRAY = "[C";
    public static final String BYTE_ARRAY = "[B";
    public static final String SHORT_ARRAY = "[S";
    public static final String LONG_ARRAY = "[J";
    public static final String DOUBLE_ARRAY = "[D";
    public static final String OBJECT_ARRAY_TERMINATOR = ";";

    static String arrayToStringJavaSpecific(Object obj) {
        String ret = "";
        ArrayUtils.ArrayType arrayType = ArrayUtilsHelper.getArrayType(obj);
        switch (arrayType) {
            case BOOLEAN: {
                ret = Arrays.toString((boolean[])obj);
                break;
            }
            case BYTE: {
                ret = Arrays.toString((byte[])obj);
                break;
            }
            case CHAR: {
                ret = Arrays.toString((char[])obj);
                break;
            }
            case DOUBLE: {
                ret = Arrays.toString((double[])obj);
                break;
            }
            case FLOAT: {
                ret = Arrays.toString((float[])obj);
                break;
            }
            case INT: {
                ret = Arrays.toString((int[])obj);
                break;
            }
            case LONG: {
                ret = Arrays.toString((long[])obj);
                break;
            }
            case OBJECT: {
                ret = ArrayUtilsHelper.objectArrayToString((Object[])obj);
                break;
            }
        }
        return ret;
    }

    public static String arrayOfCustomObjectsToString(Object arr) {
        if (arr == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder();
        int iMax = Array.getLength(arr) - 1;
        if (iMax == -1) {
            b.append("[]");
            return b.toString();
        }
        b.append('[');
        for (int i = 0; i <= iMax; ++i) {
            b.append(Array.get(arr, i));
            if (i == iMax) {
                b.append(']');
                return b.toString();
            }
            b.append(", ");
        }
        return null;
    }

    public static ArrayUtils.ArrayType getArrayType(Object arr) {
        if (!ReflectionUtilityCommon.isArray(arr.getClass())) {
            return null;
        }
        String arrClassName = ReflectionUtilityCommon.getName(arr.getClass());
        if (arrClassName.endsWith(OBJECT_ARRAY_TERMINATOR) || arrClassName.startsWith("[[")) {
            return ArrayUtils.ArrayType.OBJECT;
        }
        if (arrClassName.endsWith(FLOAT_ARRAY)) {
            return ArrayUtils.ArrayType.FLOAT;
        }
        if (arrClassName.endsWith(INT_ARRAY)) {
            return ArrayUtils.ArrayType.INT;
        }
        if (arrClassName.endsWith(BOOLEAN_ARRAY)) {
            return ArrayUtils.ArrayType.BOOLEAN;
        }
        if (arrClassName.endsWith(CHAR_ARRAY)) {
            return ArrayUtils.ArrayType.CHAR;
        }
        if (arrClassName.endsWith(BYTE_ARRAY)) {
            return ArrayUtils.ArrayType.BYTE;
        }
        if (arrClassName.endsWith(SHORT_ARRAY)) {
            return ArrayUtils.ArrayType.SHORT;
        }
        if (arrClassName.endsWith(LONG_ARRAY)) {
            return ArrayUtils.ArrayType.LONG;
        }
        if (arrClassName.endsWith(DOUBLE_ARRAY)) {
            return ArrayUtils.ArrayType.DOUBLE;
        }
        return null;
    }

    public static String objectArrayToString(Object[] a) {
        return ArrayUtilsHelper.objectArrayToString(a, Integer.MAX_VALUE);
    }

    public static String objectArrayToString(Object[] a, int maxLength) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            Object element;
            if ((element = a[i]) == null) {
                b.append("null");
            } else if (!element.getClass().isArray()) {
                b.append(String.valueOf(element));
            } else {
                b.append(ArrayUtilsHelper.arrayToStringJavaSpecific(element));
            }
            if (i == iMax) {
                return b.append(']').toString();
            }
            if (b.length() > maxLength) {
                b.append("] ... Max length limit [" + maxLength + "] reached, not all data points were captured");
                return b.toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void arrayFillObject(Object[] arr, Object value) {
        Arrays.fill(arr, value);
    }

    public static void arrayFillShort(short[] arr, int start, int end, short value) {
        Arrays.fill(arr, start, end, value);
    }

    public static void arrayFillInt(int[] arr, int start, int end, int value) {
        Arrays.fill(arr, start, end, value);
    }

    public static void arrayFillString(String[] arr, int start, int end, String value) {
        Arrays.fill(arr, start, end, value);
    }

    public static <T> T[] createArray(Class<T> clazz, int size) {
        return (Object[])Array.newInstance(clazz, size);
    }

    static String enumerationToStringJavasSpecific(Object enumObj) {
        StringBuilder builder = new StringBuilder();
        Enumeration obj = (Enumeration)enumObj;
        while (obj.hasMoreElements()) {
            Object o = obj.nextElement();
            builder.append(String.valueOf(o));
            builder.append(",");
        }
        return builder.toString();
    }

    static boolean checkIfEnumeration(Object obj) {
        return obj instanceof Enumeration;
    }

    public static void sort(Object[] a) {
        Arrays.sort(a);
    }

    public static void sort(int[] a) {
        Arrays.sort(a);
    }

    public static void sort(double[] a) {
        Arrays.sort(a);
    }

    public static void sort(long[] a) {
        Arrays.sort(a);
    }

    public static void sort(double[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex);
    }

    public static void fill(boolean[] a, boolean val) {
        Arrays.fill(a, val);
    }
}

