/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.collections;

import com.singularity.ee.util.collections.ICircularQueueElement;
import com.singularity.ee.util.collections.ICircularQueueElementFactory;
import com.singularity.ee.util.logging.ILogger;

public class CircularQueue<T extends ICircularQueueElement> {
    private T[] queue;
    private int nextElementToSet;
    private int nextElementToDrain;
    private int numWaiting;
    private volatile int numUsed;
    private volatile int numAddRequests;
    private volatile int numWaits;
    private final ILogger logger;
    private final ICircularQueueElementFactory<T> queueElementFactory;

    public CircularQueue(ICircularQueueElementFactory<T> queueElementFactory, int initialSize, ILogger logger) {
        this.queueElementFactory = queueElementFactory;
        this.queue = queueElementFactory.createAndFillQueueElementArray(initialSize);
        this.logger = logger;
    }

    public synchronized void add(ICircularQueueElement copyFromElement) {
        try {
            if (this.numUsed == this.queue.length) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("CircularQueue.getAndUse() has to wait for a free queue element");
                }
                ++this.numWaits;
                do {
                    ++this.numWaiting;
                    this.wait();
                    --this.numWaiting;
                } while (this.numUsed == this.queue.length);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("CircularQueue.getAndUse() is done waiting for a free queue element");
                }
            }
            T elementToSet = this.queue[this.nextElementToSet];
            elementToSet.copy(copyFromElement);
            ++this.numUsed;
            if (++this.nextElementToSet == this.queue.length) {
                this.nextElementToSet = 0;
            }
            ++this.numAddRequests;
        }
        catch (InterruptedException e) {
            --this.numWaiting;
        }
    }

    public synchronized void drainInto(T[] returnArray) {
        if (this.numUsed > 0) {
            int numToDrain = this.numUsed;
            if (numToDrain > returnArray.length) {
                numToDrain = returnArray.length;
            }
            if (this.nextElementToDrain + numToDrain > this.queue.length) {
                int numPriorToWrap = this.queue.length - this.nextElementToDrain;
                int numAfterWrap = numToDrain - numPriorToWrap;
                System.arraycopy(this.queue, this.nextElementToDrain, returnArray, 0, numPriorToWrap);
                System.arraycopy(this.queue, 0, returnArray, numPriorToWrap, numAfterWrap);
            } else {
                System.arraycopy(this.queue, this.nextElementToDrain, returnArray, 0, numToDrain);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("CircularQueue.drainInto() has returned " + Integer.toString(numToDrain) + " queue elements");
            }
        }
    }

    public synchronized void returnProcessedElements(int numToReturn) {
        this.numUsed -= numToReturn;
        this.nextElementToDrain += numToReturn;
        if (this.nextElementToDrain >= this.queue.length) {
            this.nextElementToDrain -= this.queue.length;
        }
        if (this.numWaiting > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("CircularQueue.returnProcessedElements() is notifying " + Integer.toString(this.numWaiting) + " waiters");
            }
            this.notifyAll();
        }
    }

    public int getQueueSize() {
        return this.queue.length;
    }

    public int getNumUsed() {
        return this.numUsed;
    }

    public synchronized void expandQueue(int newSize) {
        if (newSize >= this.numUsed) {
            ICircularQueueElement[] newQueue = this.queueElementFactory.createQueueElementArray(newSize);
            this.drainInto(newQueue);
            if (this.numUsed < newSize) {
                for (int i = this.numUsed; i < newSize; ++i) {
                    newQueue[i] = this.queueElementFactory.createQueueElement();
                }
            }
            this.nextElementToDrain = 0;
            this.nextElementToSet = this.numUsed;
            if (this.nextElementToSet >= newQueue.length) {
                this.nextElementToSet = 0;
            }
            this.queue = newQueue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("CircularQueue.expandQueue() changed size of queue to " + Integer.toString(newSize));
            }
            if (this.numWaiting > 0 && newSize > this.numUsed) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("CircularQueue.expandQueue() is notifying " + Integer.toString(this.numWaiting) + " waiters");
                }
                this.notifyAll();
            }
        }
    }

    public float getWaitPercentage() {
        float returnValue = this.numAddRequests > 0 ? (float)this.numWaits / (float)this.numAddRequests : 0.0f;
        this.numAddRequests = 0;
        this.numWaits = 0;
        return returnValue;
    }
}

