/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.collections.bounded;

import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.IBoundedCollection;
import com.singularity.ee.util.collections.bounded.SharedBoundsEnforcer;
import com.singularity.ee.util.logging.ILogger;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SharedBoundedConcurrentLinkedQueue<E>
extends ConcurrentLinkedQueue<E>
implements IBoundedCollection {
    private static final long serialVersionUID = 1L;
    private final SharedBoundsEnforcer boundsEnforcer;

    public SharedBoundedConcurrentLinkedQueue(int upperLimit) {
        this.boundsEnforcer = new SharedBoundsEnforcer(this, upperLimit);
    }

    public SharedBoundedConcurrentLinkedQueue(int upperLimit, BoundsPolicy policy) {
        this.boundsEnforcer = new SharedBoundsEnforcer(this, upperLimit, policy);
    }

    public void setILogger(ILogger logger) {
        this.boundsEnforcer.setLogger(logger);
    }

    @Override
    public boolean offer(E e) {
        boolean bReturn = false;
        if (this.boundsEnforcer.checkCapacity(1)) {
            bReturn = super.offer(e);
        }
        return bReturn;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean bReturn = false;
        if (this.boundsEnforcer.checkCapacity(c.size())) {
            bReturn = super.addAll(c);
        }
        return bReturn;
    }

    @Override
    public void _resize(int newLimit) {
    }

    @Override
    public int getCurrentSize() {
        return this.size();
    }

    @Override
    public void setNewUpperBound(int newUpperBound) {
        this.boundsEnforcer.setNewLimit(newUpperBound);
    }

    @Override
    public void setNewPolicy(BoundsPolicy policy) {
        this.boundsEnforcer.setNewPolicy(policy);
    }

    @Override
    public SharedBoundsEnforcer getBoundsEnforcer() {
        return this.boundsEnforcer;
    }

    @Override
    public void setShouldIssue80PercentWarning(boolean shouldIssue80PercentWarning) {
        this.boundsEnforcer.setShouldIssue80PercentWarning(shouldIssue80PercentWarning);
    }
}

